// BTable.inc


#declare Ax = 230		// location of white ball
#declare Ay = 140

#declare Bx = 80		// location of the targeted ball
#declare By = -50

/* make the table 1118x2235 mm */

#declare Table_Left =  0
#declare Table_Right=  Table_Left + 1118
#declare Table_Far  =   500
#declare Table_Near = Table_Far - 2235

#declare Table_Height = 762	// 30 inches, not used in this file

#declare BTable = union {

#if(do_balls)

#declare BBallCol1 = color White
#declare BBallCol2 = color White
#declare BBallFont = "symbol.ttf"
#declare BBallText = ""
#declare BBallTextXOffs = 0
#declare BBallTextYOffs = 0
#include "BBall.inc"
object {
  BBall
	rotate <10,-20,50 >
	translate < Ax, BBall_r, Ay >
}

/* MAGENTA BALL */
#declare BBallCol1 = color < 0.6, 0.0, 1.0 >
#declare BBallCol2 = color < 0.6, 0.0, 1.0 >
#declare BBallFont = "symbol.ttf"
#declare BBallText = "p"		// pi
#declare BBallTextXOffs = 0
#declare BBallTextYOffs = 0
#include "BBall.inc"
object {
  BBall
	rotate <30,-20 >
	translate < Bx, BBall_r, By >
}

/* ORANGE BALL */
#declare BBallCol1 = color rgb < 206/255, 90/255, 15/255 >
#declare BBallCol2 = BBallCol1
#declare BBallFont = "symbol.ttf"
#declare BBallText = "a"			// alpha
#declare BBallTextXOffs = 0
#declare BBallTextYOffs = .75
#include "BBall.inc"
object {
  BBall
	rotate <-10,70,70 >
	rotate <-30,0,50>
	translate < 310, BBall_r, -40 >
}

/* RED BALL */
#declare BBallCol1 = color White
#declare BBallCol2 = color Red
#declare BBallText = "x"
#declare BBallFont = "arial.ttf"
#declare BBallTextXOffs = 0
#declare BBallTextYOffs = 0
#include "BBall.inc"
object {
  BBall
	rotate y*30
	rotate x*-10
	translate < 290, BBall_r, 60 >
}

/* BLACK BALL */
#declare BBallCol1 = color White*0.01
#declare BBallCol2 = color White*0.01
#declare BBallFont = "symbol.ttf"
#declare BBallText = ""		// infinity symbol
#declare BBallTextXOffs = -1.5
#declare BBallTextYOffs = 0
#include "BBall.inc"
object {
  BBall
	rotate <10,-20,50 >
	translate < 225, BBall_r, -270 >
}

/* GREEN BALL */
#declare BBallCol1 = color White
#declare BBallCol2 = color Green*0.5
#declare BBallFont = "arial.ttf"
#declare BBallText = "0"
#declare BBallTextXOffs = 0
#declare BBallTextYOffs = -2
#include "BBall.inc"
object {
  BBall
	rotate <20,15,7 >
	translate < 120, BBall_r, 154 >
}

#declare BBallCol1 = White
#declare BBallCol2 = color rgb < 206/255, 90/255, 15/255 >
#declare BBallFont = "arial.ttf"
#declare BBallText = "W"
#declare BBallTextXOffs = 0
#declare BBallTextYOffs = -2
#include "BBall.inc"
object {
  BBall
	rotate <0,0,0 >
	translate < 132, BBall_r, -500 >
}
#else
#declare BBall_r = 57.15/2		// pocket billiard ball radius according to BCA (millimeters)
#end // do_balls

#declare T_Hole = texture {
	pigment { color Black }
	finish {
		reflection 0.1
		phong 0.5
		phong_size 30
	}
}

#declare CHole = union {		// Corner pocket hole
	cylinder {
		<0,-50,40>,<0,Edge_h+1,40>,50
		texture { T_Hole }
	}
	intersection {
		plane { x,50 }
		plane { -x,50 }
		plane { -z,90 }
		plane { z,40 }
		texture { T_Filt }
	}
/*	box {
		<-50,-50,-100>,<50,Edge_h+1,40>
		texture { T_Filt }
	}*/
	inverse
}

#declare SHole = union {		// Side pocket hole
	cylinder {
		<0,-50,40>,<0,Edge_h+1,40>,50
		texture { T_Hole }
	}
	intersection {
		plane { x,50 rotate y*-45 translate z*0 }
		plane { -x,50 rotate y*45 translate z*0 }
		plane { -z,90 }
		plane { z,40 }
	}
	inverse
}

#declare Square = polygon {
	5
	< 0,0 >, < 0,1 >, < 1,1 >, < 1,0 >, < 0,0 >
}

#declare ringoffs = 40
#declare padstart = -5

#declare HoleRing = union {
	intersection {
		torus { 50+5, 5 }
		plane { -z,0 }
		translate < 0,0, ringoffs >
	}
	cylinder { < 55, 0, padstart >, < 55, 0, ringoffs >, 5 }
	//sphere { < 55, 0, padstart >, 5 }
	cylinder { <-55, 0, padstart >, <-55, 0, ringoffs >, 5 }
	//sphere { <-55, 0, padstart >, 5 }

	object {
		Square
		scale < -100, ringoffs-padstart, 1 >
		rotate < 90, 0, 90 >
		translate x*49.999
		translate z*padstart
	}
	object {
		Square
		scale < -100, ringoffs-padstart, 1 >
		rotate < 90, 0, 90 >
		translate x*-49.999
		translate z*padstart
	}
	translate y*Edge_h
	texture { T_Hole }
}
/*
intersection {
	object { TableFrame }
	plane {  z,1 }
	plane { -z,1 }
	translate x*Table_Left+100
}*/

#if(do_frame)
intersection {
	union {
		intersection {
			object { TableFrame }
			plane {  z,0 rotate y*45  translate z*Table_Far }
			plane { -z,0 rotate y*-45 translate z*Table_Near }
			translate x*Table_Left
		}
		intersection {
			object { TableFrame rotate y*90 }
			plane {  x,0 rotate y*45  translate x*Table_Right }
			plane { -x,0 rotate y*-45 translate x*(Table_Left /*+Edge_w*/ ) }
			//translate x*-Edge_w
			translate z*Table_Far
		}
		intersection {
			object { TableFrame }
			plane {  z,0 rotate y*45  translate z*Table_Far }
			plane { -z,0 rotate y*-45 translate z*Table_Near }
			scale < -1,1,1 >	// mirror
			translate x*Table_Right
			//translate x*-Edge_w
		}
		intersection {
			object { TableFrame rotate y*90 }
			plane {  x,0 rotate y*45  translate x*Table_Right }
			plane { -x,0 rotate y*-45 translate x*Table_Left }
			scale <1,1,-1>
			//translate x*-Edge_w
			translate z*Table_Near
		}
	}
	object { CHole rotate y*-45 translate < Table_Left,0,Table_Far > }
#if (do_holes)
	object { CHole rotate y*45 translate < Table_Right,0,Table_Far > }
	object { CHole rotate y*135 translate < Table_Right,0,Table_Near > }
	object { CHole rotate y*-135 translate < Table_Left,0,Table_Near > }
	object { SHole rotate y*-90 translate < Table_Left,0,(Table_Far+Table_Near)/2 > }
	object { SHole rotate y*90 translate < Table_Right,0,(Table_Far+Table_Near)/2 > }
#end
}
#end // do_frame

#if (do_holes)
object { HoleRing rotate y*-45 translate < Table_Left,0,Table_Far > }
object { HoleRing rotate y*45 translate < Table_Right,0,Table_Far > }
object { HoleRing rotate y*135 translate < Table_Right,0,Table_Near > }
object { HoleRing rotate y*-135 translate < Table_Left,0,Table_Near > }
object { HoleRing rotate y*-90 translate < Table_Left,0,(Table_Far+Table_Near)/2 > }
object { HoleRing rotate y*90 translate < Table_Right,0,(Table_Far+Table_Near)/2 > }
#end // do_holes

#declare off1 = Edge_w

intersection {
	polygon {
		5
		< Table_Left -off1,0, Table_Far +off1>
		< Table_Right+off1,0, Table_Far +off1>
		< Table_Right+off1,0, Table_Near-off1>
		< Table_Left -off1,0, Table_Near-off1>
		< Table_Left -off1,0, Table_Far +off1>
		texture { T_Filt }
	}
	#declare HoleOffs = sqrt((40*40)/2) + 30 - 20
	//28.28
	cylinder { < 0,-10,0 >,<0,10,0>,50+30 inverse translate < Table_Left  - HoleOffs, 0, Table_Far + HoleOffs > }
	cylinder { < 0,-10,0 >,<0,10,0>,50+30 inverse translate < Table_Right + HoleOffs, 0, Table_Far + HoleOffs > }
	cylinder { < 0,-10,0 >,<0,10,0>,50+30 inverse translate < Table_Right + HoleOffs, 0, Table_Near- HoleOffs > }
	cylinder { < 0,-10,0 >,<0,10,0>,50+30 inverse translate < Table_Left  - HoleOffs, 0, Table_Near- HoleOffs > }

	cylinder { < 0,-10,0 >,<0,10,0>,50+30 inverse translate < Table_Left  - HoleOffs, 0, (Table_Near+Table_Far)/2 > }
	cylinder { < 0,-10,0 >,<0,10,0>,50+30 inverse translate < Table_Right + HoleOffs, 0, (Table_Near+Table_Far)/2 > }
}

#if(do_ruler)
object {
	Ruler
	rotate x*90
	rotate y*-55
	translate < 50,0,-190 >
}
#end

#declare Cx = Table_Left + BBall_r
#declare a = atan2(Ay-By,Ax-Bx)
#declare Cy = By - (sin(a)*(Bx-Cx))

#render concat("Cx = ",str(Cx,6,2),"  Cy = ",str(Cy,6,2),"  a = ",str(degrees(a),6,2),"\n")

#if(do_chalklines)

#declare Clength = 300
#include "ChalkLine.inc"
object {
	ChalkLine
	rotate y*-degrees(a)
	translate < Cx, 0.0001, Cy >
}

#declare Clength = 210
#include "ChalkLine.inc"
object {
	ChalkLine
	rotate y*degrees(a)
	translate < Cx, 0.0002, Cy >
}

#declare Clength = 30
#include "ChalkLine.inc"
object {
	ChalkLine
	rotate y*155
	translate x*210
	rotate y*degrees(a)
	translate < Cx, 0.0003, Cy >
}

#declare Clength = 34
#include "ChalkLine.inc"
object {
	ChalkLine
	rotate y*-150
	translate x*210
	rotate y*degrees(a)
	translate < Cx, 0.0004, Cy >
}
#end	// do_chalklines

#if(do_chalk)
object {
	ChalkWithGrains
	rotate y*-23
	translate < 110, 0, -280 >
}
#end	// do_chalk

#if(do_protractor)
object {
	Protractor
	rotate x*90
//	rotate y*34
//	translate <-65, Edge_h, 70>
	rotate y*142
	translate <156, 0, -92>
}
#end // do_protractor

#if(do_chalkbox)
object {
	ChalkBox
	rotate y*52
	translate <-65, Edge_h, 144>
}
#end // do_chalkbox
}	// BTable
