
#version 3.0

#declare do_arealight			= 1
#declare do_balls					= 1
#declare do_btext					= 1
#declare do_chalk					= 1
#declare do_chalkbox			= 1
#declare do_chalklines		= 1
#declare do_cue						= 1
#declare do_frame					= 1
#declare do_holes					= 1
#declare do_lamp					= 1
#declare do_protractor		= 1
#declare do_room					= 1
#declare do_ruler					= 1
#declare do_rulernumbers	= 1
#declare do_windows				= 1

#include "colors.inc"
#include "metals.inc"
#include "woods.inc"

#include "Ruler.inc"
#include "TableFrame.inc"
#include "Protractor.inc"
#include "Room.inc"
#include "Chalk.inc"
#include "ChalkBox.inc"
#include "BTable.inc"
#include "Window.inc"
#include "BLamp.inc"
#include "Cue.inc"

global_settings { max_trace_level 30 }
global_settings { assumed_gamma 2.2 }

light_source {
	< 2000, 1700, -1000 >
	color rgb <1.0,0.9,0.8>*0.3
	#if(do_arealight)
	area_light z*200, y*200, 5, 5
	jitter
	adaptive 0
	#end
}

light_source {			// the sun
	<50000,10000,1000>
	color rgb < 0.85, 0.90, 1.00 >*.8
/*	#if(do_arealight)
	area_light z*3000, y*3000, 5, 5
	jitter
	adaptive 0
	#end*/
}

#declare cam=1

#declare cam1angle = degrees(atan2(18,50)*2)
// calculates camera angle given a focal length in millimeters

#if(cam=1)
#render concat("Camera angle = ",str(cam1angle,5,1),"\n")
camera {
  location < 190, 140+Table_Height, -500>
	right < 4/3,0,0 >
	look_at <150, Table_Height-50, 0>
  angle cam1angle
}
#end
#if(cam=2)
camera {
  location < 190, 500, -300>
	right < 4/3,0,0 >
  look_at <190, 0, 200>
	angle 35
}
#end
#if(cam=3)		// from above
camera {
  location < 500, 3500, -400>
	right < 4/3,0,0 >
  look_at <500-1,0,-400>
	angle 40
}
#end
#if(cam=4)		// the hole
camera {
  location < 0, 250, 500>
	right < 4/3,0,0 >
  look_at <0,0,500>
	//angle 40
}
#end
#if(cam=5)		// the table
camera {
//  location < Table_Left-700, Table_Height+300, Table_Far-400 >
  location < Table_Left-700, Table_Height+300, Table_Far-2000 >
	right < 4/3,0,0 >
  look_at <Table_Left+1500,Table_Height+200,Table_Far-400>
}
#end
#if(cam=6)		// the table
camera {
//  location < Table_Left-700, Table_Height+300, Table_Far-400 >
  location < (Table_Left+Table_Right)/2, Table_Height+300, Table_Far-2000 >
	right < 4/3,0,0 >
  look_at <(Table_Left+Table_Right)/2,Table_Height+200,Table_Far-400>
}
#end

object {
	BTable
	translate y*Table_Height
}

#if(do_room)

#declare T_OutsideWall = texture {
	pigment { color White*.5 }
	normal {
		bumps 1
	}
}

intersection {
	object {
		Room
		translate x*-3000
		translate z*-3000
	}
	box { <0, 0, 0>,< big, Window_Height, Window_Width > translate <0,800,-500> inverse texture { T_OutsideWall } }
	box { <0, 0, 0>,< big, Window_Height, Window_Width > translate <0,800,-1600> inverse texture { T_OutsideWall } }
}
#end	// do_room

#if(do_windows)
object {
	Window
	rotate y*90
	translate < RoomW-3000, 800, Window_Width-500 >
}

object {
	Window
	rotate y*90
	translate < RoomW-3000, 800, Window_Width-1600 >
}
#end	// do_windows

#if(do_lamp)
object {
	BLamp
	translate < (Table_Right+Table_Left)/2, Table_Height+600 , (Table_Far+Table_Near)/2 >
}
#end	// do_lamp

#if(do_cue)
object {
	Cue
	translate x*-6
	scale < 0.8,1,1 >		// it looked too fat!
	rotate z*-88
	translate < 176, Table_Height, 370 >
}
#end // do_cue

#include "skies.inc"
#if(1)
sky_sphere { S_Cloud4 }
#else
sky_sphere {
	pigment {
    gradient y
		color_map {
			[ 0.0 color rgb <0.0,0.5,0.9> ]
			[ 0.3 color rgb <0.0,0.8,1.0> ]
			[ 1.0 color rgb <0.3,1.0,1.0> ]
		}
		turbulence 0.05
		scale 2
		translate -1
  }
}
#end

plane {			// the ground
	y,-400
	texture {
		pigment {
			bozo
			color_map {
				[ 0.0 rgb < 0.4, 0.8, 0.4 > ]
				[ 1.0 rgb < 0.3, 0.9, 0.4 > ]
			}
		}
	}
}
