/*
ChalkBox.inc

Copyright 1997 Martin Vilcans (marvil@algonet.se)
*/

#declare P_CB1 = pigment {
	gradient y
	color_map {
		[ 0.00 color rgb < 0.80, 0.11, 0.20 >*.6 ]
		[ 0.47 color rgb < 0.80, 0.11, 0.20 >*.6 ]
		[ 0.47 color Clear ]
	}
	turbulence 0.06
	scale 4
	translate -1
}

#declare P_CB2 = pigment { color White*.6 }

#declare ChalkBox = union {
	intersection {
		superellipsoid { <0.2,0.2> scale .999 }
		sphere { < 0,1.7,0 >, 1 inverse }
		bounded_by { box { -1,1 }}
		texture {
			pigment { color rgb < 0.01, 0.4, 0.9 >*.7 }
			normal {
				bumps 0.1
				scale 1/10
			}
			finish {
				brilliance 0.7
				diffuse 0.5
			}
		}
	}
	#declare tmpply = polygon { 5 < -1,-1,-1 >, < 1,-1,-1>, < 1,1,-1 >, <-1,1,-1>, <-1,-1,-1 > }
	union {
		object { tmpply }
		object { tmpply rotate y*90 }
		object { tmpply rotate y*180 }
		object { tmpply rotate y*-90 }
		texture {
			pigment {
				gradient y
				pigment_map {
					[ 0.00 P_CB1 ]
					[ 0.10 P_CB1 ]
					[ 0.10 P_CB2 ]
					[ 0.15 P_CB2 ]
					[ 0.15 P_CB1 ]
					[ 0.25 P_CB1 ]
					[ 0.25 P_CB2 ]
					[ 0.30 P_CB2 ]
					[ 0.30 P_CB1 ]
				}
				scale 2
				translate y*-1
			}
			finish {
				phong 0.3
				phong_size 40
			}
		}
	}
	translate y*1
	scale 10
}
