
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc: bike_autokotac.inc
// Date: 17.06.97
// Auth: Anto Matkovic
// email: anto.matkovic@zg.tel.hr



// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

#declare radkapa= texture {pigment {colour rgb <0.64, 0.64, 0.64>} finish {ambient 0.18 diffuse 0.6
specular 0.6 roughness 0.05 brilliance 6 reflection <0.15, 0.12, 0.1>irid   {0.14  thickness 0.2 turbulence 0.7}}}

#declare slova = texture {pigment {colour rgb <0.17, 0.17, 0.17>} finish {ambient 0.35 diffuse 0.55}}

#declare guma= texture {pigment {bozo scale 1.2
colour_map {[0 colour rgb <0.35, 0.35, 0.35>]
            [0.2 colour rgb <0.35, 0.35, 0.38>]
            [1 colour rgb <0.37, 0.36, 0.36>]}}
            finish {ambient 0.2 diffuse 0.6 phong 0.1 phong_size 12}}
texture {pigment {bozo scale 1.2
colour_map {[0 colour rgb <0.35, 0.35, 0.35>]
            [0.2 colour rgb <0.35, 0.35, 0.38>]
            [1 colour rgb <0.37, 0.36, 0.36>]}}
            finish {ambient 0.2 diffuse 0.6 specular 0.1 roughness 0.15}}


#declare  to1=box {<0.3, 0.5 , 0.16><-0.3, -0.5 , -0.16> rotate x*45  translate x*4.5 texture{guma}}
#declare  to2=box {<0.3, 0.5 , 0.16><-0.3, -0.5 , -0.16> rotate x*-45  translate <4.5, 0.5, 0> texture{guma}}
#declare  to3=box {<0.3, 0.5 , 0.16><-0.3, -0.5 , -0.16> rotate x*45  translate <4.5, 1, 0> texture{guma}}
#declare  to4=box {<0.3, 0.5 , 0.16><-0.3, -0.5 , -0.16> rotate x*-45  translate <4.5, 1.5, 0> texture{guma}}
#declare  to5=box {<0.3, 0.5 , 0.16><-0.3, -0.5 , -0.16> rotate x*-45  translate <4.5, -0.5, 0> texture{guma}}
#declare  to6=box {<0.3, 0.5 , 0.16><-0.3, -0.5 , -0.16> rotate x*45  translate <4.5, -1, 0> texture{guma}}
#declare  to7=box {<0.3, 0.5 , 0.16><-0.3, -0.5 , -0.16> rotate x*-45  translate <4.5, -1.5, 0> texture{guma}}


#declare kotac = union {
intersection{
cylinder {<0, -4, 0>,<0, 4, 0>,4 }
torus{4, 1.44 scale <1, 1.6, 1>}texture {guma}}//unutarnji dio gumene gume

intersection{
cylinder {<0, -3, 0>,<0, 3, 0>,4.7 }//pod je onda na z-2.35
torus{4, 1.44 scale <1, 1.6, 1> }texture {guma}}//vanjski dio gumene gume

#declare oho = 0
	#while (oho <50)
object {to1 rotate <0,(oho * 7.2), 0>  }
object {to2 rotate <0,(oho * 7.2), 0>  }
object {to3 rotate <0,(oho * 7.2), 0>  }
object {to4 rotate <0,(oho * 7.2), 0>  }
object {to5 rotate <0,(oho * 7.2), 0>  }
object {to6 rotate <0,(oho * 7.2), 0>  }
object {to7 rotate <0,(oho * 7.2), 0>  }


		#declare oho = (oho + 1)
#end



blob{ threshold 0.5
cylinder {<-2.29, 0.1, 0>,<2.29, 0.1, 0>,1, 1  scale <1.1, 1.8, 1.1>}
cylinder {<-2.29, 0.1, 0>,<2.29, 0.1, 0>,1, 1  scale <1.1, 1.8, 1.1> rotate y*60}
cylinder {<-2.29, 0.1, 0>,<2.29, 0.1, 0>,1, 1  scale <1.1, 1.8, 1.1> rotate y*120}
#declare ohobl = 0
#while (ohobl <90)
sphere {<0, 0, 0>,1, 1   scale <0.7, 1.8, 0.7>   translate <2.45, 0, 0> rotate <0,(ohobl *4), 0>}
#declare ohobl = (ohobl + 1)
#end
texture {radkapa}}




// create a TrueType text shape
text {ttf  "arialn.ttf", "P",  0.31, 0.31  scale 0.52  rotate <64, 0, 180>  translate <0, 1.31, 0.47>
rotate <0, -20, 0> texture {slova}}
text {ttf  "arialn.ttf", "H",  0.31, 0.31  scale 0.52  rotate <64, 0, 180>   translate <0, 1.31, 0.47>
 rotate <0, -50, 0>texture {slova}}
text {ttf  "arialn.ttf", "Y",  0.31, 0.31  scale 0.52  rotate <64, 0, 180>translate <0, 1.31, 0.47>
 rotate <0, -80, 0> texture {slova}}
text {ttf  "arialn.ttf", "S",  0.31, 0.31  scale 0.52 rotate <64, 0, 180>translate <0, 1.31, 0.47>
rotate <0, -110, 0> texture {slova}}
text {ttf  "arialn.ttf", "I",  0.31, 0.31  scale 0.52  rotate <64, 0, 180>translate <0, 1.31, 0.47>
rotate <0, -140, 0> texture {slova}}
text {ttf  "arialn.ttf", "C",  0.31, 0.31  scale 0.52  rotate <64, 0, 180>translate <0, 1.31, 0.47>
rotate <0, -150, 0> texture {slova}}
text {ttf  "arialn.ttf", "S",  0.31, 0.31  scale 0.52  rotate <64, 0, 180>translate <0, 1.31, 0.47>
rotate <0, -180, 0>  texture{slova}}
text {ttf  "arialn.ttf", "&",  0.31, 0.31  scale 0.52  rotate <64, 0, 180>translate <0, 1.31, 0.47>
rotate <0, -210, 0>  texture{slova}}
text {ttf  "arialn.ttf", "M",  0.31, 0.31  scale 0.52  rotate <64, 0, 180>translate <0, 1.31, 0.47>
rotate <0, -240, 0>  texture{slova}}
text {ttf  "arialn.ttf", "A",  0.31, 0.31  scale 0.52  rotate <64, 0, 180>translate <0, 1.31, 0.47>
rotate <0, -272, 0> texture{slova}}
text {ttf  "arialn.ttf", "T",  0.31, 0.31  scale 0.52  rotate <64, 0, 180>translate <0, 1.31, 0.47>
rotate <0, -300, 0> texture{slova}}
text {ttf  "arialn.ttf", "H",  0.31, 0.31  scale 0.52  rotate <64, 0, 180>translate <0, 1.31, 0.47>
rotate <0, -325, 0>  texture{slova}}
}//kraj kotaca union


object {kotac  rotate z*-33 translate <-6, -0.7, -0.07>}
object {kotac  rotate z*-33 translate <-6, -17.4, -0.07>}
object {kotac   translate <-37, -0.7, -0.3>}









