/*
----------------------------------------------------------------
Interpretation of a graphical representation of a gravity well
created by a black hole, intentionally made to look like a
tile drain with a plug in it.  A little play on the whole
space/time thing.  Throw in a few Einstein and Theory of
Relativity items and we are ready to go!

Created for entry in the Internet RayTracing Competition,
May/June 1997, theme is Physics & Math.

Copyright 1997
By Blaine Holmes

Started-		June 9, 1997
Complete-	June 24, 1997
----------------------------------------------------------------
*/

#include "colors.inc"			//	Includes
#include "textures.inc"
#include "metals.inc"
#include "woods.inc"

global_settings { assumed_gamma 2.2 }	//	Global settings

camera{								//	Camera
	location <0, 19, -9>
	look_at <0, 3, 0.8>
	angle 30
}

light_source {						// Main light
	<40, 100, -25>
	color White *1.7
	area_light <5, 0, 0>, <0, 0, 5>, 5, 5
	adaptive 1
	jitter
}
light_source {						//	Light in box to produce Einstein saying
	<0, 32.4, -25>
	color rgb <1, 0.95, 0.8> *5
	area_light <1, 0, 0>, <0, 0, 1>, 1, 1
	adaptive 1
	jitter
}

sphere {								//	Cloudy sky, for reflections
	<0, 0, 0>, 200
   texture {
		pigment {
			image_map {
      		gif "einstein.gif"
				map_type 0
			}
			scale <60, 60, 60>
		}
	}
	texture {
		pigment {
			bozo
			turbulence 0.65
			octaves 6
			omega 0.7
			lambda 2
			color_map {
				[0.0 0.15 color rgb <1, 1, 1> color rgbt <0.7, 0.7, 0.8, 0.2>]
				[0.15 0.5 color rgb <0.7, 0.7, 0.8> color rgbt <0.7, 0.8, 1.0, 0.7>]
				[0.5 1.0 color rgbt <0.7, 0.8, 1, 0.7> color rgbt <0.8, 0.9, 1, 1>]
			}
			scale 20
		}
	}
}

union {								//	Tile grid
	torus {
		5, 5
	}
	disc {
		<0, 5, 0>, y, 10, 5
	}
	texture {
		pigment { color Gray05 }
	}
	texture {
		pigment {
			radial
			color_map {
				[0.00 color rgb <1, 1, 1>]
				[0.05 color rgb <1, 1, 1>]
				[0.05 color rgbt <1, 1, 1, 1>]
				[1.00 color rgbt <1, 1, 1, 1>]
			}
			triangle_wave
			frequency 24
		}
		finish {
			diffuse 0.4
			brilliance 0.2
			specular 0.2
			roughness 0.01
			reflection 0.06
			crand 0.01
		}
		normal {
			radial
			slope_map {
				[0.00 <0.0, 0>]
				[0.05 <0.0, 0>]
				[0.05 <0.0, 1.5>]
				[0.06 <0.5, 1.5>]
				[0.10 <0.85, 0.5>]
				[1.00 <0.9, 0>]
			}
			triangle_wave
			frequency 24
		}
	}
	texture {
		pigment {
			gradient y
			color_map {
				[0.00 color rgb <1, 1, 1>]
				[0.05 color rgb <1, 1, 1>]
				[0.05 color rgbt <1, 1, 1, 1>]
				[1.00 color rgbt <1, 1, 1, 1>]
			}
			triangle_wave
			scale 0.197
		}
		finish {
			diffuse 0.4
			brilliance 0.2
			specular 0.2
			roughness 0.01
			reflection 0.06
			crand 0.01
		}
		normal {
			gradient y
			slope_map {
				[0.00 <0.0, 0>]
				[0.05 <0.0, 0>]
				[0.05 <0.0, 1.5>]
				[0.06 <0.5, 1.5>]
				[0.10 <0.85, 0.5>]
				[1.00 <0.9, 0>]
			}
			triangle_wave
			scale 0.197
		}

	}
	scale <1, 3, 1>
	rotate y*24
	translate <0, -10, 0>
}

#declare RandSeed = seed(0)	//	Water in drain
#declare Counter=0
merge {
	blob {
		threshold 0.65
		#while ( Counter < 10000)
			#declare SphrRad=rand(RandSeed)*0.5
			sphere { <rand(RandSeed)*20, 0, rand(RandSeed)*20>, SphrRad+0.3, 1 translate <0, 0.8-SphrRad, 0> }
			#declare Counter=Counter+1
		#end
		scale <1, 0.2, 1>
		translate <-10, 3.1, -10>
	}
	box {
		<-10, -10, -10>, <10, 3.2, 10>
	}
	texture {
		pigment { color rgbf <0.92, 0.98, 1, 0.9> }
		finish {
			refraction 1
			ior 1.33
			reflection 0.2
			caustics 0.5
		}
	}
	translate <-5, 0, 0>
}

union {								//	Drain plug
	sphere {
		<0, 0, 0>, 1.1
		scale <1, 0.2, 1>
	}
	disc {
		<0, 0.1, 0>, y, 1.3
	}
	torus {
		0.83, 0.05
		translate <0, 0.11, 0>
	}
	torus {
		0.86, 0.05
		translate <0, 0.107, 0>
	}
	intersection {
		difference {
			cylinder {
    			<0, 0.35, 0.1>, <0, 0.35, -0.1>, 0.2
				scale <0.7, 1, 1>
			}
			cylinder {
				<0, 0.40, 0.2>, <0, 0.40, -0.2>, 0.1
			}
		}
		sphere {
			<0, 0.35, 0>, 0.2
			scale <1, 1, 0.8>
		}
	}
	union {
		difference {
			torus { 0.2, 0.02 }
			box { <-1, -1, 0.03>, <1, 1, 1> }
			rotate y*-30
			translate <0.2, 0, 0>
			rotate z*-15
		}
		difference {
			torus { 0.2, 0.02 }
			box { <-1, -1, 0.03>, <1, 1, 1> }
			rotate y*210
			translate <0.2, 0, 0>
			rotate z*0
		}
		translate <0, 0.38, 0>
		texture {T_Silver_2B}
	}
	text {
		ttf "arialblk.ttf", "P", 1, 0
		translate <-0.3, 0, 0>
		rotate x*90
		scale 0.33
		rotate x*5
		translate <0, 0.29, 0.4>
		rotate y*-70
	}
	text {
		ttf "arialblk.ttf", "L", 1, 0
		translate <-0.3, 0, 0>
		rotate x*90
		scale 0.33
		rotate x*5
		translate <0, 0.29, 0.4>
		rotate y*-44
	}
	text {
		ttf "arialblk.ttf", "U", 1, 0
		translate <-0.3, 0, 0>
		rotate x*90
		scale 0.33
		rotate x*5
		translate <0, 0.29, 0.4>
		rotate y*-19
	}
	text {
		ttf "arialblk.ttf", "G", 1, 0
		translate <-0.3, 0, 0>
		rotate x*90
		scale 0.33
		rotate x*5
		translate <0, 0.29, 0.4>
		rotate y*10
	}
	text {
		ttf "arialblk.ttf", "C", 1, 0
		translate <-0.3, 0, 0>
		rotate x*90
		scale 0.33
		rotate x*5
		translate <0, 0.29, 0.4>
		rotate y*41
	}
	text {
		ttf "arialblk.ttf", "O", 1, 0
		translate <-0.3, 0, 0>
		rotate x*90
		scale 0.33
		rotate x*5
		translate <0, 0.29, 0.4>
		rotate y*70
	}
	text {
		ttf "arial.ttf", "We got a", 1, 0
		translate <-2.1, 0, 0>
		rotate x*90
		scale 0.16
		rotate x*-5
		translate <0, 0.29, -0.31>
	}
	text {
		ttf "arial.ttf", "stopper for", 1, 0
		translate <-2.4, 0, 0>
		rotate x*90
		scale 0.16
		rotate x*-5
		translate <0, 0.28, -0.47>
	}
	text {
		ttf "arial.ttf", "anything", 1, 0
		translate <-1.9, 0, 0>
		rotate x*90
		scale 0.16
		rotate x*-5
		translate <0, 0.27, -0.63>
	}
	rotate y*-25
	translate <0, -1, 0>
	pigment { color <0.9, 0.9, 0.8> }
}

text {								//	Floating letters
	ttf "arialblk.ttf", "E", 0.2, 0
	texture {
		T_Wood34
		scale 1.4
		rotate x*89
		translate <-1, 0, 0.1>
		finish {	Shiny	}
	}
	rotate x*95
	rotate z*-2
	rotate y*-9
	translate <-1.4, 3.42, 0.7>
}
text {
	ttf "arialblk.ttf", "=", 0.25, 0
	texture {
		T_Wood34
		scale 1.4
		rotate x*87
		rotate y*-1
		translate <0, 4.5, -1>
		finish { Shiny }
	}
	scale 0.8
	rotate x*90
	rotate z*4
	rotate y*-3
	translate <-0.7, 3.42, 0.76>
}
text {
	ttf "arialblk.ttf", "m", 0.2, 0
	texture {
		T_Wood34
		scale 1.4
		rotate x*92
		rotate z*-2
		translate <3, 0.5, -0.8>
		finish { Shiny }
	}
	rotate x*88
	rotate z*3
	rotate y*6
	translate <-0.15, 3.4, 0.68>
}
text {
	ttf "arialblk.ttf", "c", 0.2, 0
	texture {
		T_Wood34
		scale 1.4
		rotate x*95
		rotate z*2
		translate <0.4, -0.3, 2.8>
		finish { Shiny }
	}
	rotate x*91
	rotate z*1
	rotate y*3
	translate <0.8, 3.42, 0.74>
}
text {
	ttf "arialblk.ttf", "2", 0.4, 0
	texture {
		T_Wood34
		scale 1.4
		rotate x*91
		rotate y*3
		translate <1.3, -0.5, 0.9>
		finish { Shiny }
	}
	scale 0.5
	rotate x*93
	rotate z*-3
	rotate y*-3
	translate <1.5, 3.42, 0.92>
}

difference {						//	Einstein saying shadowbox
	union {
		box {
			<-4, 0, -4>, <4, -0.001, 4>
		}
		box {
			<-4, 0, -4>, <-4, 20, 4.001>
		}
		box {
			<-4, 0, -4>, <4, 20, -4.001>
		}
		box {
			<4, 0, 4>, <-4, 20, 4.001>
		}
		box {
			<4, 0, 4>, <4, 20, -4.001>
		}
		box {
			<-4, 20, -4>, <4, 20.001, 4>
		}
	}
	text {
		ttf "lucidasn.ttf", "\"If I had my life", 3, 0
		rotate x*90
		scale 0.1
		translate <-0.36, 0.2, 0.21>
	}
	text {
		ttf "lucidasn.ttf", "to live over again,", 3, 0
		rotate x*90
		scale 0.1
		translate <-0.4, 0.2, 0.08>
	}
	text {
		ttf "lucidasn.ttf", "I'd be a plumber.\"", 3, 0
		rotate x*90
		scale 0.1
		translate <-0.4, 0.2, -0.05>
	}
	text {
		ttf "lucidahw.ttf", "A. Einstein", 3, 0
		rotate x*90
		scale 0.075
		translate <-0.08, 0.2, -0.17>
	}
   texture {
		pigment {
			image_map {
      		gif "einstein.gif"
				map_type 0
			}
			scale <5, 5, 5>
		}
	}
	texture {
		pigment {
			bozo
			turbulence 0.65
			octaves 6
			omega 0.7
			lambda 2
			color_map {
				[0.0 0.15 color rgb <1, 1, 1> color rgbt <0.7, 0.7, 0.8, 0.2>]
				[0.15 0.5 color rgb <0.7, 0.7, 0.8> color rgbt <0.7, 0.8, 1.0, 0.7>]
				[0.5 1.0 color rgbt <0.7, 0.8, 1, 0.7> color rgbt <0.8, 0.9, 1, 1>]
			}
			scale 20
		}
	}
	finish { ambient 1 }
	rotate x*-45
	translate <0, 22.4, -15>
}

union {								// My initials & Name
	blob {
		threshold 0.2
		cylinder {
			<-0.76, 0, -0.5>, <0.76, 0, -0.5>, 0.4, 0.7
		}
		cylinder {
			<-0.76, 0, -0.5>, <0.76, 0, -0.5>, 0.4, 0.7
			rotate y*120
		}
		cylinder {
			<-0.76, 0, -0.5>, <0.76, 0, -0.5>, 0.4, 0.7
			rotate y*240
		}
		texture {
			T_Silver_3C
			rotate y*97
			rotate x*-7
			translate <0.5, 0.3, -0.2>
			scale 0.8
		}
		scale <1, 0.5, 1>
	}
	intersection {
		text {
			ttf "comicbd.ttf", "B", 1, 0
			rotate x*90
			scale 0.5
			translate <0, 0.25, -0.2>
			rotate y*-90
			translate <0, 0, -0.61>
			scale <2, 1, 1>
		}
		cylinder {
			<-0.86602, 0, -0.5>, <0.86602, 0, -0.5>, 0.21
		}
		texture {
			T_Copper_3C
			rotate y*90
		}
		rotate y*120
	}
	intersection {
		text {
			ttf "comicbd.ttf", "H", 1, 0
			rotate x*90
			scale 0.5
			translate <0, 0.25, -0.2>
			rotate y*-90
			translate <0, 0, -0.69>
			scale <2, 1, 1>
		}
		cylinder {
			<-0.86602, 0, -0.5>, <0.86602, 0, -0.5>, 0.21
		}
		texture {
			T_Copper_3C
			rotate y*90
		}
		rotate y*240
	}
	intersection {
		union {
			text {
				ttf "comicbd.ttf", "Blaine", 8, 0
				rotate x*90
				scale 0.22
				translate <-0.35, 0.25, -0.2>
				translate <0, 0, -0.32>
			}
			text {
				ttf "comicbd.ttf", "Holmes", 8, 0
				rotate x*90
				scale 0.22
				translate <-0.2, 0.25, -0.2>
				translate <0, 0, -0.53>
			}
		}
		cylinder {
			<-0.86602, 0, -0.51>, <0.86602, 0, -0.51>, 0.235
		}
		texture {
			T_Copper_3C
			rotate y*90
		}
	}
	rotate x*-5
	scale 0.25
	translate <2.2, 10, -5.45>
}
