// Persistence of Vision Ray Tracer Scene Description File
// File: bs-esa.pov
// Title:  Elementary Spectral Analysis
// Vers: 1
// Desc: Flashlight Through a Prism.  For the Internet RayTracing Competition May-June '97
//       (Theme: Math & Physics)
// Date: 6/30/97
// Auth: Bob Sewell

// ==== Standard POV-Ray Includes ====
#include "colors.inc"
#include "textures.inc"

// ==== Additional Includes ====
#include "glass.inc"
#include "metals.inc"
#include "woods.inc"

#declare wall = object {
  polygon
  {
    5,
    <0, -7.5>, <0, 0>, <10, 0>, <10, -7.5>, <0, -7.5>
  }
  texture { pigment { White } finish { Phong_Glossy }  }
  rotate <90, 0, 0>
}

#declare thefloor = object {
polygon {
  5, // number of points
  <0, -7.5>, <0, 0>, <10, 0>, <10, -7.5>, <0, -7.5>
}
  texture { pigment { White } finish { Phong_Glossy } }
}

#declare WallPrismLights = union {
light_source {
   <-2.0, 3.0, 1>
   color Red
   spotlight
   point_at <-2.0, 10, 3>
   tightness 100
   radius 10
   falloff 11
   fade_power 1
   fade_distance 2
}
light_source {
   <-2.0, 3.0, 1>
   color Orange
   spotlight
   point_at <-2.0, 10, 3.5>
   tightness 100
   radius 10
   falloff 11
   fade_power 1
   fade_distance 2
}
light_source {
   <-2.0, 3.0, 1>
   color Yellow
   spotlight
   point_at <-2.0, 10, 4>
   tightness 100
   radius 10
   falloff 11
   fade_power 1
   fade_distance 2
}
light_source {
   <-2.0, 3.0, 1>
   color Green
   spotlight
   point_at <-2.0, 10, 4.5>
   tightness 100
   radius 10
   falloff 11
   fade_power 1
   fade_distance 2
}
light_source {
   <-2.0, 3.0, 1>  // -1, 7, 3
   color Blue
   spotlight
   point_at <-2.0, 10, 5>
   tightness 100
   radius 10
   falloff 11
   fade_power 1
   fade_distance 2
}
light_source {
   <-2.0, 3.0, 1>
   color Violet
   spotlight
   point_at <-2.0, 10, 5.5>
   tightness 100
   radius 10  // 15
   falloff 11
   fade_power 1
   fade_distance 2
}
}

#declare MyPrism = difference {
  box { < 0, 0, 0 >, < 5, 3, 3 >
    rotate < 45, 0, 0 >
    translate < -3, 0, 0 > }
  box { < -1, -3, -1 >, < 6, 3, 2.1 >
    translate < -3, 0, 0 > }
  hollow
}

#declare parab = intersection {
  sphere { < 0, 0, 0 > 2 }
  box { < 0, -3, -3 > < 3, 3, 3 > }
}

#declare flashlighttexture = texture { T_Brass_5A }

#declare fswitch = union {
  box { < 2, -0.5, 1 > < 3.5, 0.5, 1.5 > texture { flashlighttexture } }
  cylinder { < 2.075, -0.5, 1.550 > < 2.075, 0.5, 1.550 > 0.065 texture { T_Chrome_5A } }
  cylinder { < 2.150, -0.5, 1.540 > < 2.150, 0.5, 1.540 > 0.065 texture { T_Chrome_5A } }
  cylinder { < 2.225, -0.5, 1.530 > < 2.225, 0.5, 1.530 > 0.065 texture { T_Chrome_5A } }
  cylinder { < 2.300, -0.5, 1.520 > < 2.300, 0.5, 1.520 > 0.065 texture { T_Chrome_5A } }
  cylinder { < 2.375, -0.5, 1.510 > < 2.375, 0.5, 1.510 > 0.065 texture { T_Chrome_5A } }
  cylinder { < 2.450, -0.5, 1.500 > < 2.450, 0.5, 1.500 > 0.065 texture { T_Chrome_5A } }
  cylinder { < 2.525, -0.5, 1.490 > < 2.525, 0.5, 1.490 > 0.065 texture { T_Chrome_5A } }
  cylinder { < 2.600, -0.5, 1.485 > < 2.600, 0.5, 1.485 > 0.065 texture { T_Chrome_5A } }
  cylinder { < 2.675, -0.5, 1.480 > < 2.675, 0.5, 1.480 > 0.065 texture { T_Chrome_5A } }
  cylinder { < 2.750, -0.5, 1.480 > < 2.750, 0.5, 1.480 > 0.065 texture { T_Chrome_5A } }
  cylinder { < 2.825, -0.5, 1.480 > < 2.825, 0.5, 1.480 > 0.065 texture { T_Chrome_5A } }
  cylinder { < 2.900, -0.5, 1.485 > < 2.900, 0.5, 1.485 > 0.065 texture { T_Chrome_5A } }
  cylinder { < 2.975, -0.5, 1.490 > < 2.975, 0.5, 1.490 > 0.065 texture { T_Chrome_5A } }
  cylinder { < 3.050, -0.5, 1.500 > < 3.050, 0.5, 1.500 > 0.065 texture { T_Chrome_5A } }
  cylinder { < 3.125, -0.5, 1.510 > < 3.125, 0.5, 1.510 > 0.065 texture { T_Chrome_5A } }
  cylinder { < 3.200, -0.5, 1.520 > < 3.200, 0.5, 1.520 > 0.065 texture { T_Chrome_5A } }
  cylinder { < 3.275, -0.5, 1.530 > < 3.275, 0.5, 1.530 > 0.065 texture { T_Chrome_5A } }
  cylinder { < 3.350, -0.5, 1.540 > < 3.350, 0.5, 1.540 > 0.065 texture { T_Chrome_5A } }
  cylinder { < 3.425, -0.5, 1.550 > < 3.425, 0.5, 1.550 > 0.065 texture { T_Chrome_5A } }
}

#declare flashlight = union {
  difference {
    object {
      parab
      texture { flashlighttexture }
    }
    object {
      parab
      scale 0.9
      translate < -0.5, 0, 0 >
      texture {
        T_Chrome_5F
      }
    }
  }
  cylinder { < 1.5, 0, 0 > < 6, 0, 0 > 1.35 open texture { flashlighttexture } }
  object { fswitch }
  scale <1, 0.5, 0.5 >
}

// *******  L I G H T S  -  C A M E R A  *******

camera {
  location  <10.0,    -5.0,  6.0>  // 10, -5, 6
  direction < 0.0,     0.0,  1.0>  //  0, 0, 1
  sky       < 0.0,     0.0,  1.0>
  up        < 0.0,     0.0,  1.0>
  right     < 1.3333,  0.0,  0.0>
  look_at   < 0.0,     2.0,  3.0>  //  0, 3, 3
}

//background { White }

light_source {                 // Indoor Light
  <20.00, -25.00, 20.00>
  color rgb <0.25, 0.25, 0.25>
  shadowless
}

light_source
{
  < -2.35, -1.7, 3.6 >    // light's position (translated below)
  color rgb <1,1,1>       // light's color
  spotlight               // this kind of light source
  point_at <-1.0, 1, 1>   // direction of spotlight
  radius 75                // hotspot (inner, in degrees)
  tightness 25            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 90               // intensity falloff radius (outer, in degrees)
}

light_source
{
  < -2.35, -1.7, 3.6 >            // light's position (translated below)
  color rgb < 0.5, 0.5, 0.5 >               // light's color
  spotlight                       // this kind of light source
  point_at < -2.35, -1.8, 3.7 >   // direction of spotlight
  radius 75                       // hotspot (inner, in degrees)
  tightness 25                    // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 90                      // intensity falloff radius (outer, in degrees)
}

// ********  A C T I O N !  **********

object { // three guesses
  thefloor
  scale <2, 20, 1>
  translate <-9, 15, 0>
}

object { // right wall
  wall
  scale <10, 1, 15>
  translate <-9, 10, 28>
}

object { // left wall
  wall
  scale <10, 1, 15>
  rotate <0, 0, -90>
  translate <-6, 20, 28>
}

object {
  WallPrismLights
  translate <0, 0, 0>
}

object { MyPrism texture { T_Glass5 } scale < 2, 1, 1 > translate < -1, 3, -2 > }

object {
  flashlight
  rotate < -45, -40, -90 >
  translate < -2.55, -2, 4 >
  scale 0.9
}

atmosphere {
  type 5
  samples 20
  distance 5000
  scattering 0.025
  aa_level 8
  aa_threshold 0.1
  jitter 0.1
}
