
// Persistence of Vision Ray Tracer Scene Description File
// File: books.inc
// Vers: 1.00
// Desc: A couple of textbooks. One is "Fundamentals of Physics (Extended 3rd edition)
//       by Halliday and Resnick, and the other is "Advanced Engineering Mathematics"
//       by Kreyszig. These books kept me company through my university Physics and
//       Maths courses.
//       Created for the May-June round of the IRTC.
// Date: May 25th, 1997
// Auth: Chris Hernandez


/* ------------------------------------- NOTE ----------------------------------------
   Due to time constraints, not all faces of the books are detailed. I only made image
   maps for the faces of the books that are seen in the scene I needed them for.
			   - For Halliday and Resnick, only the front cover is detailed.
			   - For Kreyszig, only the spine and back cover are detailed.
   ----------------------------------------------------------------------------------- */


// ==== Standard POV-Ray Includes ====
#include "colors.inc"   // Standard Color definitions


#declare TempTexture = texture {
	pigment { color rgb < 0.5, 0.5, 0.7 > }
	finish {
	   ambient 0.4
	   diffuse 0.25
	   specular 0.35
	   roughness 0.1
	}
}


#declare Book_EdgeTexture3 = texture {
   pigment {
	  gradient y sine_wave
	  color_map {
		 [ 0.00 color rgb 0.80 ]
		 [ 0.40 color rgb 0.80 ]
		 [ 0.41 color rgb 0.77 ]
		 [ 0.60 color rgb 0.77 ]
		 [ 0.61 color rgb 0.80 ]
		 [ 1.00 color rgb 0.80 ]
	  }
   }
   normal  {
	  gradient y sine_wave
	  slope_map {
		 [0.00 <0.0, 0.0>]
		 [0.50 <0.5, 0.0>]
		 [1.00 <0.0, 0.0>]

	  }
   }
   finish  { ambient 0.35 diffuse 0.35 crand 0.03 }
   scale 0.06
}

#declare Book_BasicTexture1 = texture {
	pigment { color rgb < 0.26, 0.56, 0.50 > }
	finish {
	   ambient 0.25
	   diffuse 0.3
	   specular 0.35
	   roughness 0.1
	}
}

#declare Book1 = object {
   union {
	  box { <-4.5, -1, -3> <4.5, -0.95, 3> texture { Book_BasicTexture1 } }
	  box { <-4.5,  1, -3> <4.5,  0.95, 3>
		 texture { Book_BasicTexture1 }
		 texture {
			pigment {
			   image_map {
				  gif "book1.gif"
				  map_type 0
				  interpolate 2
				  once
				  transmit 1, 1.0
			   }
			}
			normal {
			   bump_map {
				  gif "book1.gif"
				  map_type 0
				  interpolate 2
				  bump_size 0.15
			   }
			}
			finish {
			   ambient 0.7
			   diffuse 0.15
			   specular 0.35
			   roughness 0.01
			   reflection 0.03
			}
			translate <-0.5, -0.5, 0>
			rotate x*90
			rotate y*90
			scale <9,1,6>
		 }
	  }
	  difference {
		 cylinder { -4.5*x, 4.5*x, 1 }
		 cylinder { -4.6*x, 4.6*x, 0.95 }
		 clipped_by { plane { -z, 0 } }
		 texture { Book_BasicTexture1 }
		 scale <1,1,0.3>
		 translate <0,0,3>
	  }
	  union {
		 difference{
			box { <-4.4, -0.95, -2.9> <4.4, 0.95, 3> }
			cylinder { -4.5*x, 4.5*x, 0.95 scale <1,1,0.2> translate <0,0,-3> }
		 }
		 cylinder { -4.4*x, 4.4*x, 0.95 scale <1,1,0.18> translate <0,0,3> }
		 texture { Book_EdgeTexture3 }
	  }
	  //scale <1,0.9,1>
   }
}


#declare Book_BasicTexture2 = texture {
	pigment { color rgb < 0.3, 0.0, 0.4 > }
	finish {
	   ambient 0.4
	   diffuse 0.25
	   specular 0.35
	   roughness 0.1
	}
}

#declare Book2 = object {
   union {
	  box { <-4.5, -1, -3> <4.5, -0.95, 3> texture { Book_BasicTexture2 } }
	  box { <-4.5,  1, -3> <4.5,  0.95, 3>
		 texture { Book_BasicTexture2 }
		 texture {
			pigment {
			   image_map {
				  gif "book2a.gif"
				  map_type 0
				  interpolate 2
				  once
				  transmit 15, 1.0
			   }
			}
			normal {
			   bump_map {
				  gif "book2a.gif"
				  map_type 0
				  interpolate 2
				  bump_size 0.15
			   }
			}
			finish {
			   ambient 0.7
			   diffuse 0.15
			   specular 0.35
			   roughness 0.01
			   reflection 0.05
			}
			translate <-0.5, -0.5, 0>
			rotate x*90
			rotate -y*90
			scale <9,1,6>
		 }
	  }
	  difference {
		 cylinder { -4.5*x, 4.5*x, 1 }
		 cylinder { -4.6*x, 4.6*x, 0.95 }
		 clipped_by { plane { -z, 0 } }
		 texture { Book_BasicTexture2 }
		 texture {
			pigment {
			   image_map {
				  gif "book2b.gif"
				  map_type 0
				  interpolate 2
				  once
				  transmit 1, 1.0
			   }
			}
			normal {
			   bump_map {
				  gif "book2b.gif"
				  map_type 0
				  interpolate 2
				  bump_size 0.15
			   }
			}
			finish {
			   ambient 0.7
			   diffuse 0.15
			   specular 0.35
			   roughness 0.01
			   reflection 0.04
			}
			translate <-0.5, -0.5, 0>
			rotate -z*90
			rotate -y*180
			scale <9,2,1>
		 }
		 scale <1,1,0.3>
		 translate <0,0,3>
	  }
	  union {
		 difference{
			box { <-4.4, -0.95, -2.9> <4.4, 0.95, 3> }
			cylinder { -4.5*x, 4.5*x, 0.95 scale <1,1,0.2> translate <0,0,-3> }
		 }
		 cylinder { -4.4*x, 4.4*x, 0.95 scale <1,1,0.18> translate <0,0,3> }
		 texture { Book_EdgeTexture3 }
	  }
	  scale <0.8,1.3,1>
   }
}
