
// Persistence of Vision Ray Tracer Scene Description File
// File: clock.pov
// Vers: 1.00
// Desc: A small pink and white "Lorus" desk clock, modelled from the one I have at
//       my computer desk. Created for the May-June round of the IRTC
// Date: 19th June 1997.
// Auth: Chris Hernandez



// -------------------------------------------------------------------------------------
//                                 Declare some useful globals
// -------------------------------------------------------------------------------------

#declare Clock_Texture = texture {   // --- Texture of main body; smooth pink plastic.
    pigment { color rgb < 0.95, 0.74, 0.81 > }
    finish {
       ambient 0.45
       diffuse 0.4
       specular 0.35
       roughness 0.0075
    }
}

/*  ----------------------------------- Some Constants  -----------------------------  */
#declare CB_Width = 1.4             // .... Width/height of clock (clock is square)
#declare CB_HWidth = CB_Width/2     // .... Half Width
#declare CB_Depth = 0.6             // .... Z depth of clock
#declare CB_MinRad = 0.1            // .... Minor radius of curved edges
#declare CB_MajRad = 0.3            // .... Major radius of curved edges

#declare CMagicNo = CB_HWidth-CB_MajRad-CB_MinRad  // Magic Numbers!
#declare CMagicNo2 = CB_HWidth-CB_MinRad           // ...These seem to occur a lot.



// -------------------------------------------------------------------------------------
//                                     Clock components
// -------------------------------------------------------------------------------------

// ----------------------------------------* Main body of clock
#declare Clock_Body = object {
   union {
      difference {  // --------- Main body. Scoop out corners...
         box { <-CB_HWidth, -CB_HWidth, 0> <CB_HWidth, CB_HWidth, CB_Depth> }
         box { <-1, 0, -1> < 0, 1, 1>  translate <-CMagicNo,  CMagicNo, 0> }
         box { <-1,-1, -1> < 0, 0, 1>  translate <-CMagicNo, -CMagicNo, 0> }
         box { < 0, 0, -1> < 1, 1, 1>  translate < CMagicNo,  CMagicNo, 0> }
         box { < 0, 0, -1> < 1,-1, 1>  translate < CMagicNo, -CMagicNo, 0> }
      }

      // ..... and make them rounded.
      cylinder { 0*z, CB_Depth*z, CB_MajRad+CB_MinRad translate <-CMagicNo,  CMagicNo, 0> }
      cylinder { 0*z, CB_Depth*z, CB_MajRad+CB_MinRad translate <-CMagicNo, -CMagicNo, 0> }
      cylinder { 0*z, CB_Depth*z, CB_MajRad+CB_MinRad translate < CMagicNo,  CMagicNo, 0> }
      cylinder { 0*z, CB_Depth*z, CB_MajRad+CB_MinRad translate < CMagicNo, -CMagicNo, 0> }

      // Add button on top of clock.
      box {
         <-0.25, -0.1, CB_Depth> <0.25, 0.05, 0.1>
         texture { Clock_Texture normal { gradient z scallop_wave } scale <1, 1, 0.05> }
         translate y*CB_HWidth
      }
      texture { Clock_Texture }
   }
}


// ----------------------------------------* Front (curvy) part of clock
#declare ClockFront_Bevel = object {
   union {
      // --------------------------- Torii for corners
      torus {
         CB_MajRad, CB_MinRad
         rotate x*90
         clipped_by{plane{-y,0} plane{x,0}}
         translate <-CMagicNo,  CMagicNo, 0>
      }
      torus {
         CB_MajRad, CB_MinRad
         rotate x*90
         clipped_by{plane{y,0} plane{x,0}}
         translate <-CMagicNo, -CMagicNo, 0>
      }
      torus {
         CB_MajRad, CB_MinRad
         rotate x*90
         clipped_by{plane{-y,0} plane{-x,0}}
         translate < CMagicNo,  CMagicNo, 0>
      }
      torus {
         CB_MajRad, CB_MinRad
         rotate x*90
         clipped_by{plane{y,0} plane{-x,0}}
         translate < CMagicNo, -CMagicNo, 0>
      }
      // --------------------------- Cylinders for edges
      cylinder { -x*CMagicNo, x*CMagicNo, CB_MinRad translate -y*(CMagicNo2) }
      cylinder { -x*CMagicNo, x*CMagicNo, CB_MinRad translate  y*(CMagicNo2) }
      cylinder { -y*CMagicNo, y*CMagicNo, CB_MinRad translate -x*(CMagicNo2) }
      cylinder { -y*CMagicNo, y*CMagicNo, CB_MinRad translate  x*(CMagicNo2) }
   }
   texture {
      pigment { color rgb < 0.95, 0.95, 0.95 > }
      finish {
         ambient 0.45
         diffuse 0.4
         specular 0.35
         roughness 0.0075
      }
   }
}


// ----------------------------------------* Front of clock - bevel, face and glass.
#declare Clock_Face = object {
   union {
      // --------------------------- Clock face - gif file mapped onto box
      box {
         <-(CMagicNo2-0.05), -(CMagicNo2-0.05), 0> <(CMagicNo2-0.05), (CMagicNo2-0.05), 0.01>
         texture {
            pigment { image_map { gif "clock.gif" map_type 0 interpolate 2 once } }
            finish  { ambient 0.75 diffuse 0.25 }
            translate <-0.5, -0.5, 0>
            scale (2*CMagicNo2-0.2)
         }
         translate -z*0.03
      }
      object { ClockFront_Bevel scale <1,1,2.5> }
      // --------------------------- Front glass bit
      box {
         <-(CMagicNo2-0.05), -(CMagicNo2-0.05), 0> <(CMagicNo2-0.05), (CMagicNo2-0.05), 0.01>
         texture {
            pigment { color rgbf < 0.96, 0.96, 0.96, 0.97 > }
            finish  {
               ambient 0.15 diffuse 0.125 specular 0.2 roughness 0.003
               reflection 0.1 refraction on ior 1.45
            }
         }
         translate -z*0.2
      }
   }
}


// -------------------------------------------------------------------------------------
//                                    Main Clock Object
// -------------------------------------------------------------------------------------

#declare Clock = object {
   union {
      object { Clock_Body }
      object { Clock_Face }
   }
   translate y*CB_HWidth
}

