
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc:
// Date:
// Auth: Chris Hernandez



#declare MugTexture = texture {
    pigment { color rgb <0.5,0.6,0.5> /*< 0.6, 0.8, 0.6 >*/ }
    finish {
       ambient 0.3
       diffuse 0.4 //0.3
       specular 0.1
       roughness 0.05
       reflection 0.075
    }
}

#declare Logo_Type = 2    //  1=UNSW logo only  2=Logo plus "UNSW" text

#if ( Logo_Type = 1 )

#declare UNSW_Logo = texture {
   pigment {
      image_map {
         gif "unsw2.gif"
         map_type 0
         interpolate 2
         transmit 12, 1.0
         once
      }
      scale <1.1, 1.5, 1>
      translate < -0.525, 0.25, 0 >
   }
   finish {
      ambient 0.5
      diffuse 0.4
      //reflection 0.1
      specular 0.1
      roughness 0.05
   }
}

#else

#declare UNSW_Logo = texture {
   pigment {
      image_map {
         gif "unsw3.gif"
         map_type 0
         interpolate 2
         transmit 12, 1.0
         once
      }
      scale <1.0, 1.6, 1>
      translate < -0.4, 0.2, 0 >
   }
   finish {
      ambient 0.5
      diffuse 0.4
      //reflection 0.1
      specular 0.1
      roughness 0.05
   }
}

#end

#declare Coffee = texture {
   pigment { color rgb 0.03 /*< 0.5, 0.4, 0.2 >*/ }
   finish {
      ambient 0.6
      diffuse 0.4
      specular 1.0
      roughness 0.005 //0.013
      reflection 0.1
      irid {
         0.15
         thickness 0.3
         turbulence 0.75
      }
      crand 0.03
   }
   normal { ripples 0.45 scale 0.075 }
}


#declare UNSW_Mug = object {
   union {
      // ----- Body of mug ----------------------
      difference {
         cylinder { 0*y,  2*y,  1 }
         cylinder { 0.05*y,  5*y,  0.84 }
         texture { MugTexture }
         texture { UNSW_Logo  }
      }

      // ----- Rounded Top ----------------------
      torus {
         0.92, 0.08
         scale <1, 1.5, 1>
         translate 2*y
         texture { MugTexture }
      }

      // ----- Mug Handle -----------------------
      torus {
         0.425, 0.075
         scale <1.2, 3, 1.5>
         rotate x*90
         translate <1.2, 1.1, 0>
         texture { MugTexture }
      }

      // ----- Mug Contents (coffee) ------------
      disc { <0, 1.85, 0>,  y,  1.0  texture { Coffee } }
   }
}

