// Persistence of Vision Ray Tracer Scene Description File

// File: lamp.pov
// Vers: 1.00
// Desc: Blue desk lamp. Created as part of a scene for May-June round of IRTC.
// Date: May 1997
// Auth: Chris Hernandez


global_settings { assumed_gamma 2.5 }

#include "colors.inc"
#include "mug.inc"
#include "lamp.inc"

background { color rgb 0.7 }


light_source { 0*x  color rgb 0.65 translate <-20, 40, -20> shadowless }
light_source { 0*x  color rgb 0.99 translate < 20, 40, -20> }
light_source { 0*x  color rgb 0.65 translate <-20,-40, -20> shadowless }
light_source { 0*x  color rgb 0.65 translate <  0,  0, -20> shadowless }
light_source { 0*x  color rgb 0.20 translate <  0, 20,  20> shadowless }

camera
{
  //location  <0 , 9 , -35> look_at   <-2 , 4.5 , 0>
  location  <0 , 25 , -35> look_at   <-2 , 2.5 , 4>
  //location  <0 , 35 , 0> look_at   <-2 , 4.5 , 0>
  //look_at   <-2 , 4.5 , 4>
  angle 30
}

object { Lamp rotate -y*35 }
object { UNSW_Mug rotate -y*30 translate <-6, 0, -4> }

/*
plane { y, 0
   texture {
      pigment { color rgb <0.5,0.9,0.7> }
      finish {ambient 0.35 diffuse 0.3 specular 0.25 roughness 0.01}
   }
}
*/
