plane { //the floor of the museum (reflections)
	y, -6
	texture {
		checker
		texture {	White_Marble scale .1}
		texture { Black_Marble scale .1}
		scale 5
	}

}

box{ //the ceiling of the museum (reflections)
	<-1000,90,-200>,<1000,91,200>
	texture { Sandstone }
}


#declare FarWall =
difference {

	plane { //inner wall
		z, -100
	}
	plane { //outer wall
		z, -101
	}

	texture { White_Marble }
}

difference { //the Far Wall minus an archway
	object { FarWall }
	box { //the main door
		<40, -6, -99>, <50, -1, -102>
	}
	cylinder { //the arch
		<45, -1, -99>, <45, -1, -102>, 5
	}
	texture { White_Marble } //lotta White_Marble 'round here
}

#declare Planter =

union {
	sor {
		6,
	    <0,0>, <.8381, 0>, <1.5533, 1.3175>, <.7259, 2.4675>,
	    <1.1606, 2.8882>, <2.2264, 2.8180>
		open
		texture { Bronze }
		translate <0, -6, -95>
	}

	#declare Loop = 0

	#while ( Loop < 12 )

		bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
     		<-1.574834, 0.024479, -0.859846>, <-0.470938, 0.024479, -1.124414>, <0.529062, 0.024479, -1.124414>, <1.529062, 0.024479, -0.859846>,
	     	<-1.591370, 1.742016, 0.264568>, <-0.487474, 1.742016, 0.000000>, <0.512526, 1.742016, 0.000000>, <1.408630, 1.742016, 0.264568>,
	     	<-1.616996, 3.972079, 0.264568>, <-0.513100, 3.972079, 0.000000>, <0.486900, 3.972079, 0.000000>, <1.383004, 3.972079, 0.264568>,
			<-0.031085, 6.054022, -2.362237>, <-0.044519, 6.046587, -2.362237>, <-0.035647, 6.052054, -2.362237>, <-0.039677, 6.033958, -2.362237>

		scale <0.3, 0.5, 1.0>
		translate  <0.0, 0.4, 3.8>
		/*RHC -> LHC conversion*/ rotate -90*x  scale <1,1,-1>
		/*Which leaf? */
		rotate <0, Loop*30, 0>
		translate <0, Loop*.01 - 6, -95>

		pigment { rgb<0,1,0> }
		finish { phong .75 }
		}

		#declare Loop = Loop + 1
	#end
} //end planeter union


object { Planter translate <3,0,0> }
object { Planter translate <35,0,0> }

#declare BenchLeg =
union { //the legs
	difference { //the fluted column of the leg
		cylinder {
			<0,-5.75,0>, <0,-4,0>, 2
		}
		#declare Loop=0
		#while ( Loop < 15 )
			cylinder {
				<2,-5.75,0>, <2,-4,0>, 2/16
				rotate <0,Loop*24,0>
			}
			#declare  Loop = Loop + 1
		#end
	}

	box { //the base of the leg
		<-3,-6,-3>, <3,-5.75,3>
	}

	texture { White_Marble }
}

//The complete bench
object { BenchLeg translate <8,0,-95> }
object { BenchLeg translate <22,0,-95> }
box { //the seat
	<6,-4, -99>, <24,-4.5,-91>
	texture { White_Marble }
}
