
// Definition of a mousetrap
// All units are in centimeters
// Origin is in lower left corner
// Trap lies in x-z plane

// 0 = Set
// 1 = Tripped
// #declare MouseTrapState = 1.0

// Make sure we are in a valid range
#if (MouseTrapState < 0.0)
#declare MouseTrapState = 0.0
#end
#if (MouseTrapState > 1.0)
#declare MouseTrapState = 1.0
#end

#ifndef (MouseTrapParts)

// All the pieces of the mousetrap which do not depend on MouseTrapState
// This only needs to be included once

#declare MouseTrapParts = version

// Texture stuff
#declare BaseFinish = finish {
   diffuse 0.6
   ambient 0.4
}

#declare BaseWoodMap = color_map {
   [0.26 rgb<0.918, 0.733, 0.510>]
   [0.31 rgb<0.831, 0.663, 0.463>]
   [0.37 rgb<0.831, 0.663, 0.463>]
   [0.45 rgb<0.843, 0.627, 0.208>]
   [0.67 rgb<0.918, 0.733, 0.510>]
   [0.78 rgb<0.843, 0.698, 0.408>]
   [0.82 rgb<0.918, 0.733, 0.510>]
}

// Color map for the top layer of wood. Same as BaseWoodMap,
// except for transparency
#declare TopWoodMap = color_map {
   [0.26 rgbt<0.918, 0.733, 0.510, 1.0>]
   [0.31 rgbt<0.831, 0.663, 0.463, 1.0>]
   [0.37 rgbt<0.831, 0.663, 0.463, 0.9>]
   [0.45 rgbt<0.843, 0.627, 0.208, 0.35>]
   [0.67 rgbt<0.918, 0.733, 0.510, 0.81>]
   [0.78 rgbt<0.843, 0.698, 0.408, 1.0>]
   [0.82 rgbt<0.918, 0.733, 0.510, 1.0>]
}

#declare MouseTrapWoodGrain = pigment {
   wood
   turbulence 0.0435
   scale <0.7, 0.6, 1.7>
}

#declare MouseTrapWoodPores = pigment {
      bozo
      turbulence 0.1
      scale <0.05, 0.02, 1.0>
      color_map {
         [0.01 rgbt<0.25, 0.25, 0.25, 0.2>]
         [0.01 rgbt<0.25, 0.25, 0.25, 1.0>]
      }
}

#declare MouseTrapLogo =  texture {
   pigment {
      image_map {
         gif "mouslogo.gif"
         once
         map_type 0
         transmit 0, 1.0
         interpolate 2
      }
      rotate 90 * x
      scale <4.6, 1, 9.9>
   }
   finish {
      diffuse 0.6
      ambient 0.4
   }
}

#declare SawMarks = texture {
   pigment {
      bozo
      scale <0.12, 10, 10>
      rotate 57 * z
      color_map {
         [0.20 rgbt<0.641, 0.425, 0.175, 0.4>]
         [0.22 rgbt<0.641, 0.425, 0.175, 1.0>]
      }
   }
}

#declare CopperWire = texture {
   pigment {rgb<0.5, 0.35, 0.25>}
   finish {
      diffuse 0.6
      ambient 0.4
      specular 0.8
      brilliance 3
      metallic
      roughness 0.1
      reflection 0.2
   }
}

#declare SpringWire = texture {
   pigment {rgb<0.5, 0.5, 0.53>}
   finish {
      diffuse 0.6
      ambient 0.4
      specular 0.55
      brilliance 3
      metallic
      roughness 0.04
   }
}

#declare BaitHookMetal = texture {
   pigment {
      bozo
      scale 0.4
      color_map {
         [0.1 rgb<0.6, 0.6, 0.6>]
         [0.4 rgb<0.7, 0.7, 0.73>]
      }
   }
   finish {
      diffuse 0.6
      ambient 0.4
      specular 0.7
      brilliance 3
      metallic
      roughness 0.04
      reflection 0.2
   }
}

#declare BaseR = seed(162)


#declare StapleWireRadius = 0.05
#declare StapleBendRadius = 0.275

#declare TorusMajorRadius = StapleBendRadius
#declare TorusMinorRadius = StapleWireRadius
#include "torus4.inc"

#declare HalfStaple = union {
   object {
      QuarterTorus
      translate 0.875 * y
   }
   cylinder {
      <StapleBendRadius, -0.001, 0.0>
      <StapleBendRadius, 0.875, 0.0>
      StapleWireRadius
   }
}

// Lies in XY plane
#declare MouseTrapStaple = union
{
   object {HalfStaple}
   object {
      HalfStaple
      rotate 180 * y
   }
   texture {CopperWire}
}

#declare MouseTrapBaitStaple = union
{
   object {
      HalfStaple
      translate 0.425 * x
   }
   object {
      HalfStaple
      rotate 180 * y
      translate -0.425 * x
   }
   cylinder {
      <-0.425, 0.875 + StapleBendRadius, 0.0>
      <0.425, 0.875 + StapleBendRadius, 0.0>
      StapleWireRadius
   }
   texture {CopperWire}
}

#declare TrapBarWireRadius = 0.065
#declare TrapBarBendRadius = 0.15
#declare TrapBarCrimpRadius = 0.13

#declare TorusMajorRadius = TrapBarBendRadius
#declare TorusMinorRadius = TrapBarWireRadius
#include "torus4.inc"

#declare TorusMajorRadius = TrapBarCrimpRadius
#declare TorusFraction = 0.6
#include "torusx.inc"

// Origin is at center point of bar which is between the staples. This
// makes it easy to animate the bar by simply rotating around the X axis.
#declare MouseTrapBarShape = union {
   difference {
      union {
         cylinder {
            <2.3, 0.0, 0.0>
            <-1.9 + TrapBarBendRadius, 0.0, 0.0>
            TrapBarWireRadius
         }
         sphere {
            <1.94 + TrapBarWireRadius, 0.0, 0.0>, 1.3 * TrapBarWireRadius
         }
      }
      union {
         box {
            <0.0, 0.0, -2 * TrapBarWireRadius>
            <2 * TrapBarWireRadius, 2 * TrapBarWireRadius, 2 * TrapBarWireRadius>
            rotate -15 * z
            translate <1.93, TrapBarWireRadius, 0.0>
         }
         box {
            <0.0, -2 * TrapBarWireRadius, -2 * TrapBarWireRadius>
            <2 * TrapBarWireRadius, 0.0, 2 * TrapBarWireRadius>
            rotate 15 * z
            translate <1.93, -TrapBarWireRadius, 0.0>
         }
      }
   }
   object {
      QuarterTorus
      rotate 180 * z
      translate <-1.9 + TrapBarBendRadius, TrapBarBendRadius, 0>
   }
   cylinder {
      <-1.9, TrapBarBendRadius, 0.0>
      <-1.9, 4.4 - TrapBarBendRadius, 0.0>
      TrapBarWireRadius
   }
   object {
      QuarterTorus
      rotate 90 * z
      translate <-1.9 + TrapBarBendRadius, 4.4 - TrapBarBendRadius, 0>
   }
   cylinder {
      <-1.9 + TrapBarBendRadius, 4.4, 0.0>
      <1.9 - TrapBarBendRadius, 4.4, 0.0>
      TrapBarWireRadius
   }
   // The following objects are rotated slightly
   union {
      object {
         QuarterTorus
         translate <1.9 - TrapBarBendRadius, -TrapBarBendRadius, 0.0>
      }
      cylinder {
         <1.9, -TrapBarBendRadius, 0.0>
         <1.9, -4.4 - 2 * TrapBarWireRadius + TrapBarCrimpRadius, 0.0>
         TrapBarWireRadius
      }
      union {

         object {
            FractionTorus
         }
         cylinder {
            <TrapBarCrimpRadius, 0.0, 0.0>
            <TrapBarCrimpRadius, 0.2, 0.0>
            TrapBarWireRadius
            rotate TorusFraction * 360 * z
         }
         rotate -90 * y
         rotate 180 * z
         translate <1.9 , -4.4 - 2 * TrapBarWireRadius + TrapBarCrimpRadius, -TrapBarCrimpRadius>
      }
      rotate -degrees(atan2(TrapBarCrimpRadius, 4.4)) * x
      translate <0.0, 4.4, 0.0>
   }
}

#declare MouseTrapBar = object {
   MouseTrapBarShape
   texture {CopperWire}
}


#declare TriggerWireRadius = StapleWireRadius
#declare TriggerBendRadius = 0.175

#declare TorusMajorRadius = TriggerBendRadius
#declare TorusMinorRadius = TriggerWireRadius
#include "torus2.inc"
#include "torus4.inc"

#declare MouseTrapTrigger = union {
   cylinder {
      <TriggerBendRadius, 0.4, 0.0>
      <TriggerBendRadius, TriggerBendRadius - TriggerWireRadius - StapleWireRadius, 0.0>
      TriggerWireRadius
   }
   object {
      HalfTorus
      rotate 180 * z
      translate <0.0, TriggerBendRadius - TriggerWireRadius - StapleWireRadius, 0.0>
   }
   cylinder {
      <-TriggerBendRadius, 0.3, 0.0>
      <-TriggerBendRadius, TriggerBendRadius - TriggerWireRadius - StapleWireRadius, 0.0>
      TriggerWireRadius
   }
   object {
      QuarterTorus
      rotate 90 * z
      translate <0.0, 0.3, 0.0>
   }
   cylinder {
      <0.0, 0.3 + TriggerBendRadius, 0.0>
      <5.0, 0.3 + TriggerBendRadius, 0.0>
      TriggerWireRadius
   }
   union {
#declare TorusFraction = 30/360
#include "torusx.inc"
      object {
         FractionTorus
      }
      cylinder {
         <TriggerBendRadius, 0.0, 0.0>
         <TriggerBendRadius, -0.3, 0.0>
         TriggerWireRadius
      }
      union {
#declare TorusFraction = 45/360
#include "torusx.inc"
         object {
            FractionTorus
         }
         cylinder {
            <TriggerBendRadius, 0.0, 0.0>
            <TriggerBendRadius, -0.7, 0.0>
            TriggerWireRadius
         }
         rotate 180 * y
         rotate 45 * z
         translate <2 * TriggerBendRadius, -0.3, 0.0>
      }
      rotate 60 * z
      translate <5.0, 0.3, 0.0>
   }
   rotate -90 * y
   texture {CopperWire}
}


#declare MetalThickness = 0.03
#declare D = 0.1 * tan((pi - atan2(0.75, 0.25)) / 2)

#declare StampShape = union {
   prism {
      linear_sweep
      linear_spline
      -0.01, MetalThickness + 0.3, 9
      <0.0, 0.0>
      <0.65, 0.0>
      <0.65, 0.1>
      <0.75, 0.1>
      <0.75, 0.8 - D>
      <0.65, 0.8 - D>
      <0.65 + sqrt(0.001), 0.8 - D + 3 * sqrt(0.001)>
      <0.0, 1.05>
      <0.0, 0.0>
   }
   cylinder {
      <0.65, -0.01, 0.1>
      <0.65, MetalThickness + 0.3, 0.1>
      0.1
   }
   cylinder {
      <0.65, -0.01, 0.8 - D>
      <0.65, MetalThickness + 0.3, 0.8 - D>
      0.1
   }
}

#declare MouseTrapBaitHook = union {
   difference {
      cylinder {
         <-0.55, 0.275, 1.7>
         <0.55, 0.275, 1.7>
         0.275
      }
      union {
         cylinder {
            <-0.6, 0.275, 1.7>
            <0.6, 0.275, 1.7>
            0.275 - MetalThickness
         }
         box {
            <-0.6,-0.01, 1.3>
            <0.6, 0.275, 1.7>
         }
         sphere { <0.0, 0.55, 1.7> .15 }
         union {     // The teeth
            box { <0.0, 0.0, 0.0> <0.2, 0.2, 0.1> }
            box { <0.0, 0.0, 0.0> <0.2, 0.2, 0.1> translate <0.2, 0.2, 0.0> }
            box { <0.0, 0.0, 0.0> <0.2, 0.2, 0.1> translate <0.4, 0.4, 0.0> }
            box { <0.0, 0.0, 0.0> <0.2, 0.2, 0.1> translate <0.6, 0.6, 0.0> }
            rotate -45 * z
            translate <-0.4 * sqrt(2), 0.275, 1.42>
         }
      }
   }
   difference {
      union {
         box {
            <-0.55, 0.0, 0.0>
            <0.55, MetalThickness, 1.7>
         }
         intersection {
            difference {
               cylinder {
                  <-0.55, 0.275, 0.0>
                  <0.55, 0.275, 0.0>
                  0.275
               }
               cylinder {
                  <-0.6, 0.275, 0.0>
                  <0.6, 0.275, 0.0>
                  0.275 - MetalThickness
               }
            }
            box {
               <-0.6, -0.01, -0.275>
               <0.6, 0.275, 0.0>
            }
            box {
               <-0.6, -0.01, 0.0>
               <0.6, 0.275, 0.275>
               translate -0.275 * y
               rotate 20 * x
               translate 0.275 * y
            }
         }
         box {
            <-0.55, 0.0, -0.65>
            <0.55, MetalThickness, 0.0>
            translate -0.275 * y
            rotate 20 * x
            translate 0.275 * y
         }
      }
      object {
         StampShape
         translate <-0.4, 0.0, -0.5>
      }
   }
   union {
      intersection {
         difference {
            object {StampShape}
            union {
               box {
                  <-0.01, -0.1, -0.1>
                  <0.19, MetalThickness + 0.1, 0.44>
                  rotate -10 * y
               }
               cylinder {
                  <0.09, -0.1, 0.4>
                  <0.09, MetalThickness + 0.1, 0.44>
                  0.1
               }
               cylinder {
                  <0.575, -0.1, 0.2>
                  <0.575, MetalThickness + 0.1, 0.2>
                  0.075
               }
               cylinder {
                  <0.575, -0.1, 0.55>
                  <0.575, MetalThickness + 0.1, 0.55>
                  0.075
               }
               box {
                  <0.5, -0.1, 0.2>
                  <0.8, MetalThickness + 0.1, 0.55>
               }
            }
         }
         box {
            <-0.1, 0.0, -0.1>
            <0.85, MetalThickness, 1.15>
         }
      }
      intersection {
         difference {
            cylinder {
               <0.65, 0.175 / sqrt(3), 0.375>
               <0.75, 0.175 / sqrt(3), 0.375>
               0.35 / sqrt(3)
            }
            cylinder {
               <0.6, 0.175 / sqrt(3), 0.375>
               <0.8, 0.175 / sqrt(3), 0.375>
               (0.35 / sqrt(3)) - MetalThickness
            }
         }
         box {
            <0.5, -0.5, 0.2>
            <0.8, MetalThickness, 0.55>
         }
      }
      rotate 80 * z
      translate <-0.4, 0.0, -0.5>
   }
   translate <0.0, -MetalThickness - StapleWireRadius, 0.05>
   texture {BaitHookMetal}
}

#declare MouseTrapPriceSticker = box
{
   <0, 0, 0>
   <1.85, 0.001, 1.5>
   pigment {
      image_map {
         gif "price.gif"
         map_type 0
         interpolate 2
      }
      rotate 90 * x
      scale <1.85, 1.0, 1.5>
   }
   finish {
      diffuse 0.6
      ambient 0.4
   }
}


#declare MouseTrapStatic = union {
   object {
      MouseTrapStaple
      translate <2.3, 0, 0.55>
   }
   object {
      MouseTrapStaple
      rotate 90*y
      translate <0.5, 0, 5.4>
   }
   object {
      MouseTrapStaple
      rotate 90*y
      translate <4.6 - 0.5, 0, 5.4>
   }
   object {
      MouseTrapBaitStaple
      translate <2.3, 0, 6.6>
   }
   object {
      MouseTrapPriceSticker
      rotate 180 * z
      rotate 5 * y
      translate <3, 0.0, 7>
   }
}

// Location of Ping Pong balls on set trap
#declare BallOffset1A = transform {translate <0.786, 3.022, 4.48>}
#declare BallOffset1B = transform {translate <3.445, 3.208, 1.915>}
#declare BallOffset2A = transform {translate <3.477, 3.015 , 4.465>}
#declare BallOffset2B = transform {translate <0.962, 3.274, 1.764>}

// Apply this transform to a mouse tap to flip it face down
#declare FlipOver = transform {
      rotate 6 * z
      rotate -175 * x
      translate 1.27 * y
}

#end   // MouseTrapParts



#declare MouseTrapTextureTransform = transform {
   translate <6 * (rand(BaseR) - 0.5), 4 + 2 * rand(BaseR), 5 * rand(BaseR)>
   rotate 10 * (rand(BaseR) - 0.5) * x
   rotate 4 * (rand(BaseR) - 0.5) * y
}

#declare MouseTrapPoreTexture = texture {
   pigment {
      MouseTrapWoodPores
   }
   transform MouseTrapTextureTransform
   finish {BaseFinish}
}

#declare MouseTrapBaseWood = texture {
   pigment {
      MouseTrapWoodGrain
      color_map {BaseWoodMap}
   }
   transform MouseTrapTextureTransform
   finish {BaseFinish}
}

#declare MouseTrapTopWood = texture {
   pigment {
      MouseTrapWoodGrain
      color_map {TopWoodMap}
   }
   transform MouseTrapTextureTransform
   finish {BaseFinish}
}


// Rather than declaring the base as a simple box, it is declared as an intersection
// of planes so we can apply a different texture to each face.

#declare MouseTrapBase = intersection {
   difference {    // Create groove in top where bar slams into it
      plane {
         y, 0.55
      }
      object {
         MouseTrapBarShape
         rotate 95.8 * x   // Angle at MouseTrapState = 1
         translate <2.3, 0.875 + StapleBendRadius - StapleWireRadius - TrapBarWireRadius, 5.4>
      }
      texture {MouseTrapBaseWood}
      texture {MouseTrapLogo}
      texture {MouseTrapTopWood}
      texture {MouseTrapPoreTexture}
   }
   plane {-y, 0 texture {MouseTrapBaseWood} texture {MouseTrapPoreTexture}}
   plane {x, 4.6 texture {MouseTrapBaseWood} texture {MouseTrapPoreTexture}}
   plane {-x, 0 texture {MouseTrapBaseWood} texture {MouseTrapPoreTexture}}
   plane {z, 9.9 texture {MouseTrapBaseWood} texture {MouseTrapPoreTexture} texture {SawMarks}}
   plane {-z, 0 texture {MouseTrapBaseWood} texture {MouseTrapPoreTexture} texture {SawMarks}}

   // Manually bounding speeds up rendering
   bounded_by { box {<-0.1, -0.1, -0.1> <4.7, 0.65, 10.0>}}
}


#if (MouseTrapState < 0.8)
#declare BarPosition = pow(max(MouseTrapState, 0.05) - 0.05 , 2) / 0.8625
#else
#declare BarPosition = 1 + (MouseTrapState - 1) * 1.5 / 0.8625
#end

#declare SpringWireRadius = TrapBarWireRadius
#declare SpringLength = 3.05

#declare HelixWireRadius = SpringWireRadius

#declare HelixTurns = 20.5036 - 0.4987 * BarPosition

// #declare HelixTurns = 20.521   // This will depend on MouseTrapState
// Value of 20.521 corresponds to -90 degree rotation of bar
#declare HelixPitch = SpringLength / HelixTurns
#declare HelixMajorRadius = 0.275

#include "helix.inc"

#declare MouseTrapSpring = union {
   cylinder {
      HelixStartPoint
      HelixStartPoint + 1.8 * HelixStartVector
      SpringWireRadius
   }
   object {
      Helix
   }
   union {
      cylinder {
         vrotate(HelixEndPoint, -mod(HelixTurns, 1) * 360 * z)
         <HelixMajorRadius, 0.9, SpringLength>
         SpringWireRadius
      }
#declare TorusFraction = 0.07
#include "torusx.inc"

      union {
         cylinder {
            <HelixMajorRadius, 0.0, 0.0>
            <HelixMajorRadius, -0.7, 0.0>
            SpringWireRadius
         }
         object {
            FractionTorus
         }
         union {
            cylinder {
               <HelixMajorRadius, 0.0, 0.0>
               <HelixMajorRadius, -0.5, 0.0>
               SpringWireRadius
            }
            object {
               FractionTorus
            }
            rotate -TorusFraction * 360 * z
            rotate -90 * y
            translate <HelixMajorRadius, -0.7, -HelixMajorRadius>
         }
         rotate (180 - TorusFraction * 360) * z
         rotate -90 * y
         translate <HelixMajorRadius, 0.9, SpringLength + HelixMajorRadius>
      }
      rotate mod(HelixTurns, 1) * 360 * z
   }
   rotate -90 * y
   rotate 84.5 * x
   texture {SpringWire}
}


#declare MouseTrap = union {
   object {
      MouseTrapStatic
   }
   object {
      MouseTrapBase
   }
   object {
      MouseTrapBar
      // -83.75 corresponds to MouseTrapState = 0
      // 95.8 corresponds to MouseTrapState = 1 (Bar presses slightly into base)
      rotate ((BarPosition *  179.55) - 83.75) * x
      translate <2.3, 0.875 + StapleBendRadius - StapleWireRadius - TrapBarWireRadius, 5.4>
   }
   object {
      MouseTrapSpring
      translate <0.75 + SpringLength, 0.875 + StapleBendRadius - StapleWireRadius - TrapBarWireRadius, 5.4>
   }
   object {
      MouseTrapTrigger
      // -2.5 at MouseTrapState = 0
      rotate  -2.5 * y
      // -0.75 at MouseTrapState = 0
      rotate ((-155 * min(MouseTrapState, 0.8) / 0.8) - 0.75) * x
      translate StapleBendRadius * y
      rotate (103 * min(MouseTrapState, 0.8) / 0.8) * z
      translate <2.3, 0.875, 0.55>
   }
   object {
      MouseTrapBaitHook
      // -15 at MouseTrapState = 0
      // +17 at MouseTrapState = 1
      rotate (32 * (min(MouseTrapState, 0.15) / 0.15) - 15) * x
      translate <2.3 , 0.875 + StapleBendRadius, 6.6>
   }
}

