#include <iostream.h>
#include <math.h>

#define NCLOSE 6
#define BLASTHOLE 0.3
//#define HOLE
#define CONNECTIONS
#define SIMPLE_FRONTS

main(int argc, char* argv[])
{
    int n;
    cin >> n;

    double x[n],y[n],z[n];

    for (int i=0; i<n; i++)
	cin >> x[i] >> y[i] >> z[i];

    int closest_neighbor[n][NCLOSE];
    int furthest_neighbor[n];
    double radius[n];
    double mind=9999;
    double maxd=0;
#define degrees(r) ((r)*180/M_PI)
#define dist(i,j) ({\
		double dx = x[i] - x[j];\
		double dy = y[i] - y[j];\
		double dz = z[i] - z[j];\
		sqrt(dx*dx+dy*dy+dz*dz);})
#define distsq(i,j) ({\
		double dx = x[i] - x[j];\
		double dy = y[i] - y[j];\
		double dz = z[i] - z[j];\
		dx*dx+dy*dy+dz*dz;})
#define dist2(i,x2,y2,z2) ({\
		double dx = x[i] - x2;\
		double dy = y[i] - y2;\
		double dz = z[i] - z2;\
		sqrt(dx*dx+dy*dy+dz*dz);})

    for (int i=0; i<n; i++) {
	double minn[NCLOSE];
	for (int c=0; c<NCLOSE; c++) minn[c]=999999;
	double maxn=0;
	for (int j=0; j<n; j++) {
	    if (i != j) {
		double dsq = distsq(i,j);
		int c;
		for (c=0; c<NCLOSE && dsq<minn[c]; c++)
		    ;

		if (c) {
		    c--;
		    for (int cc=0; cc<c; cc++) {
			closest_neighbor[i][cc] = closest_neighbor[i][cc+1];
			minn[cc] = minn[cc+1];
		    }
		    minn[c] = dsq;
		    closest_neighbor[i][c] = j;
		}
		if (dsq > maxn) {
		    maxn = dsq;
		    furthest_neighbor[i] = j;
		}
	    }
	}
	radius[i] = sqrt(distsq(i,closest_neighbor[i][NCLOSE-1]))/2;

	if (minn[NCLOSE-1] < mind) mind = minn[NCLOSE-1];
	if (maxn > maxd) maxd = maxn;
    }

    for (int it=0; it<100; it++) {
	for (int i=0; i<n; i++) {
	    double r=9999.0;
	    for (int c=0; c<NCLOSE; c++) {
		int cn=closest_neighbor[i][c];
		double nr=dist(i,cn)-radius[cn];
		if (nr < r) r=nr;
	    }
	    radius[i]=r;
	}
    }

#ifdef POV_SHARES_OBJECTS
    const int ndo = 293;
    static char* suf[3] = { "", "F", "B" };
    int opt;
    for (opt=0; opt<3; opt++) {
	for (int i=0; i<ndo; i++) {
	    cout << "#declare SimpleFront=";
	    if (opt&1) cout << 1; else cout << 0;
	    cout << "#declare SimpleBack=";
	    if (opt&2) cout << 1; else cout << 0;
	    cout << "#declare N=" << (double)i/ndo << "\n"
		<< "#include \"dyson-object.inc\"\n"
		<< "#declare DO" << i << suf[opt] << " = object { DysonObject }\n";
	}
    }
#endif

    cout << "#declare DysonObjects= union {\n";
#define out(p) '<' << x[p] << ',' << y[p] << ',' << z[p] << '>'
    for (int i=0; i<n; i++) {
#ifdef HOLE
	if (dist2(i, 1,0,0) > 0.1) {
#endif
	    double zR=degrees(atan2(y[i],sqrt(x[i]*x[i]+z[i]*z[i])));
	    double yR=degrees(atan2(x[i],z[i]));
	    int cn=closest_neighbor[i][NCLOSE-1];
	    double zRn=degrees(atan2(y[cn],sqrt(x[cn]*x[cn]+z[cn]*z[cn])));
	    double yRn=degrees(atan2(x[cn],z[cn]));
	    int cnn=closest_neighbor[i][NCLOSE-2];
	    double zRnn=degrees(atan2(y[cnn],sqrt(x[cnn]*x[cnn]+z[cnn]*z[cnn])));
	    double yRnn=degrees(atan2(x[cnn],z[cnn]));

#ifdef BLASTHOLE
	    double trX = 1.0;
	    double trY = 0.0;
	    double trZ = 0.0;

	    double oyR = 0.0;
	    double ozR = 0.0;
	    bool blasted = false;

	    if ( x[i] > 0 ) {
		double dy = y[i] - 0;
		double dz = z[i] - 0;
		double d = sqrt(dy*dy+dz*dz);

		if (d < BLASTHOLE ) {
		    // Boom!

		    if ( d < 0.02 ) d += 0.01; // Tame extremes

		    double force = (1/(d/BLASTHOLE+0.05)-0.95)/20; // not REALLY "force"
		    trX += (BLASTHOLE-d)*1.2;
		    trY += dy/d*force;
		    trZ += dz/d*force;

		    // Spin!
		    oyR += float(rand()%360) * 20*force;
		    ozR += float(rand()%360) * 20*force;

		    blasted = true;
		}
	    }
#else
	    int trX = 1;
	    int trY = 0;
	    int trZ = 0;
#endif

#ifdef POV_SHARES_OBJECTS
	    if (x[i]>+0.2) opt=1;
	    else if (x[i]<-0.2) opt=2;
	    else opt=0;
	    int don = i%ndo;
#else

#ifdef SIMPLE_FRONTS
	    int opt=1;
#else
	    int opt=0;
#endif

	    if (x[i]>+0.2) opt|=1;
	    else if (x[i]<-0.2) opt|=2;
	    else opt=0;

#ifdef BLASTHOLE
	    if (blasted) opt = 0;
#endif

	    cout << "#declare SimpleFront=";
	    if (opt&1) cout << 1; else cout << 0;
	    cout << "#declare SimpleBack=";
	    if (opt&2) cout << 1; else cout << 0;

	    cout << "#declare N=" << (double)i/n << "\n"
		<< "#include \"dyson-object.inc\"\n";
#endif

#ifdef CONNECTIONS
	    cout << "union { ";
#endif

#ifdef POV_SHARES_OBJECTS
	    cout << "object { DO" << don << suf[opt];
#else
	    cout << "object { DysonObject";
#endif
	    cout << " scale " << radius[i];

#ifdef CONNECTIONS
	    cout << "}\n";
	    cout << " sphere {<0,0,0>,SphereR}";
	    if ( oyR || ozR ) {
		if (rand()%4 == 0) {
		    cout << " cylinder { <0,0,0> <0,"
			<< 0.01+((float)(rand() % 16))/800 << ",0>, TubeR "
			<< " rotate x*" << rand()%360 << "}\n";
		}
	    }
#endif

#ifdef BLASTHOLE
	    if ( oyR || ozR )
		cout << " rotate <0," << oyR << ',' << ozR << '>';
#endif
	    cout << " translate <" << trX << ',' << trY << ',' << trZ << '>'
		<< " rotate z*" << zR << " rotate y*" << yR
		<< "}\n";

#ifdef CONNECTIONS
#ifdef BLASTHOLE
	    if ( !oyR && !ozR ) {
#endif
	      cout << "cylinder {vrotate(vrotate(<" << trX << ',' << trY << ',' << trZ << ">,<0,0," << zR << ">),<0," << yR << ",0>),"
		<< "vrotate(vrotate(x,<0,0," << zRn << ">),<0," << yRn << ",0>),"
		<< "TubeR}\n";
	      cout << "cylinder {vrotate(vrotate(<" << trX << ',' << trY << ',' << trZ << ">,<0,0," << zR << ">),<0," << yR << ",0>),"
		<< "vrotate(vrotate(x,<0,0," << zRnn << ">),<0," << yRnn << ",0>),"
		<< "TubeR2}\n";
#ifdef BLASTHOLE
	    }
#endif
#endif

#ifdef HOLE
	}
#endif
    }
    cout << "}\n";
}
