#include "colors.inc"
#include "textures.inc"
#include "finish.inc"
#include "shapes.inc"
#include "shapes2.inc"

#declare SphereR = 0.02/5
#declare TubeR = 0.01/5
#declare TubeR2 = 0.01/2/5

#declare VERYSIMPLE = 0

#declare DysonObjectTexture =
    texture {
	pigment { rgb<1,1,1> }
	finish { Dull ambient 0 }
    }

#include "dyson.inc"

#include "fireball.inc"

union {
    object {
	DysonObjects
	texture { DysonObjectTexture }
    }

    union {
	object {
	    Fireball
	    no_shadow
	    scale 0.16
	}
	light_source {
	    <0,0,0>
	    color <1,1,0.8>
	    area_light x/8,y,8,1
	    adaptive 1
	    jitter
	}
	translate <1.4,0,0>
	rotate y*90
    }

    rotate x*+15
    rotate y*-33
}


camera {
    location <0.2,0,-2.2>
    look_at <0,0,0>
    direction z*0.8
    up y right x*800/600
}

// Starlight, star bright.
light_source {
    <1,1,-5>
    color rgb<1,1,1>/15
}

light_source {
    <0,0,0>
    color rgb<1,1,1>
    looks_like {
	sphere { <0,0,0>,0.02 pigment { rgb <2,2,0.8> } finish { Luminous } }
    }
}

#if (VERYSIMPLE)
//background { color rgb<0.2,0.2,0.2> }
#else

#include "starfield.inc"
sky_sphere {
    StarField
    rotate <123,06,48> // Pick a viewing direction
}

#end

