// Persistence of Vision Raytracer
// Theme "mathematics & physics" 05-06/97
// Sizes in cm
// Proportions pour cadrage classique 800x600

global_settings {
   max_trace_level 6
   adc_bailout 1/255
   assumed_gamma 1.9
   }

/******************************************************************************

        Gnralits

******************************************************************************/

#include "common.inc"

#declare INC_MAIN=1

#ifndef (INC_MURG)
   #include "mur_g.inc"
#end
#ifndef (INC_MRUD)
   #include "mur_d.inc"
#end
#ifndef (INC_QUADRANT)
   #include "quadrant.inc"
#end
#ifndef (INC_SOL)
   #include "sol.inc"
#end
#ifndef (INC_ARRIERE)
   #include "arriere.inc"
#end
#ifndef (INC_FOND)
   #include "fond.inc"
#end
#ifndef (INC_CAPTION)
   #include "caption.inc"
#end
#ifndef (INC_LUTRIN)
   #include "lutrin.inc"
#end

#render "Includes ok.\n"

#declare Vue=1
#declare WideLight = 1

#declare Vue_Test=camera {
   orthographic
   location -30 * z
   up        y*50
   right     -4/3 * x*50
   direction z // Vue globale
   rotate 180 * y
   }

#declare Vue_1=camera {
   perspective
   location  <150, 150, 400>
   up        y*50
   right     -4/3 * x*50
   look_at   <150, 150, 0>
   angle 65 //Attention: angle  la base et non sur la diagonale!
   translate 40*y
   }

#declare Lampes=union{
   object{light_source {<-2000, 1370, -2950>*10 color White*0.7}}
   object{light_source{<200, 370, 295> color White*0.7 shadowless}}
   }

#declare Lampes_E=union{
   object {
      light_source {
         <-2000-200/2, 1370-200/2, -2950>*10 // light's position
         color White*0.7
         area_light
         <200, 0, 0> <0, 200, 0> // lights spread out across this distance (x * y)
         4, 4
         adaptive 0
         jitter
         }
      }
   object{light_source{<200, 370, 295> color White*0.7 shadowless}}
   }

/******************************************************************************

        Scne complte

******************************************************************************/
#declare Test = union {
   object {Caption scale .45 rotate 60*y translate <0, 6, -5>}
   }

#declare Scene1=union{
   object {Murd translate <0, 0, 0>}
   object {Murg translate <0, 0, 0>}
   object {Quadrant translate <0, 0, 0>}
   object {Sol translate <0, 0, 0>}
   object {Fond translate <0, 0, 0>}
   object {Lutrin rotate 30*y translate <50, 0, 30>}
   object {Arriere translate <320, -300, -1400>}
   object {Caption no_shadow scale .6 translate <50, 330, 0>}
   translate <0, 0, 0> rotate 0*x
   }

#switch (Vue)
   #case (0)
      camera {Vue_Test}
      object {Test rotate 0*y scale 1}
      //sky_sphere { Decor_Ciel }
      #break
   #case (1)
      camera {Vue_1}
      //sky_sphere { Decor_Ciel }
      object {Scene1 rotate 0*y translate -50*z}
   #break
#end

#ifdef (WideLight)
   object {Lampes_E}
   #debug "Lumieres etendues\n"
#else
   object {Lampes}
   #debug "Lumieres ponctuelles\n"
#end
