// Persistence of Vision Raytracer
// Fond

#include "common.inc"
/******************************************************************************
   A faire:
******************************************************************************/

#declare INC_FOND=1
#include "common.inc"

/******************************************************************************

        textures

******************************************************************************/

#declare Fond_CBlanc=color rgb<.7, .7, .9>*1
#declare Fond_PCloud2 =
pigment {
    wrinkles
    turbulence 0.65
    octaves 6
    omega 0.7
    lambda 2
    color_map {
        [0.0, 0.1   color red 0.85 green 0.85 blue 0.85
                    color red 0.75 green 0.75 blue 0.75]
        [0.1, 0.5   color red 0.75 green 0.75 blue 0.75
                    color rgb <0.258, 0.258, 0.435>  ]
        [0.5, 1.001 color rgb <0.258, 0.258, 0.435>
                    color rgb <0.258, 0.258, 0.435> ]
    }
    scale <6, 1, 6>
}
#declare Fond_PCloud3 =
pigment {
    bozo
    color_map {
        [0.0, 0.1   color red 0.85 green 0.85 blue 0.85
                    color red 0.55 green 0.60 blue 0.65]
        [0.1, 0.5   color red 0.55 green 0.60 blue 0.65
                    color rgb <0.184, 0.184, 0.309> ]
        [0.5, 1.001 color rgb <0.184, 0.184, 0.309>
                    color rgb <0.1, 0.1, 0.2>]
    }
    turbulence 0.65
    octaves 6
    omega 0.707
    lambda 2
    scale <6, 4, 6>
}

/******************************************************************************

        objets

******************************************************************************/

#declare Fond1=object{
   sphere {0, 1 hollow}
   texture{
      pigment {
        gradient y
        pigment_map {
           [0.01 rgb <0.847, 0.749, 0.747> ] // horizon
           [0.25 Fond_PCloud2 scale 0.25 rotate z*5]
           [0.60 Fond_PCloud3 scale <0.25, 0.15, 0.25> rotate z*10]
           }
        }
      finish {ambient 1 diffuse 0}
      }
   scale 100000
   }

#declare Fond2=object{
   height_field {gif "fract003.gif"}
   texture {
      pigment{
         bozo color_map{
            [0 color Green*0.8]
            [1 color rgb <.5 1 .5>*.8]
            }
         scale .1
         }
      normal {bumps 5 bump_size 1 scale 300}
      finish {crand 0.05}
      }
   //rotate 20*x rotate 20*z
   translate <-.3, -.3, -2.5>
   scale <3000, 350, 1000>
   no_shadow
   }

#declare Fond_Fog=fog{
   fog_type 2 //ground_fog
   distance 2000
   color Gray
   turbulence 1.5
   turb_depth 10
// omega OMEGA
// lambda LAMBDA
// octaves OCTAVES
   fog_offset 50
   fog_alt 50
   }


#declare Fond=union{
   object {Fond1}
   //object {Fond2}
   }
//fog {Fond_Fog}

#ifndef (INC_MAIN)
   #include "Tycho.pov"
#end
