// Persistence of Vision Raytracer
// Quadrant

/******************************************************************************
   A faire:
   forme idale pour la nappe: un cylindre cras au milieu

                  (x2/a2)+(z2/b2/y2)=1
      soit:
                (b2/a2)x2y2 + z2 - b2y2 = 0
      Cette quation ajoute la droite y=x=0 (deux fois), d'o le degr 4...


******************************************************************************/

#declare INC_QUADRANT=1
#include "common.inc"

/******************************************************************************

        textures

******************************************************************************/

#declare Quadrant_CBlanc=color rgb<.9, .9, .1>*1

/******************************************************************************

        objets

******************************************************************************/

#declare Quadrant_Rayon =object{
   cylinder{0*x, x, 1 hollow}
   texture {
      pigment { color Clear }
      finish { ambient 0 diffuse 0 }
      halo{
         emitting cylindrical_mapping
         poly exponent 2 max_value 1
         color_map{
            [0.0 color rgbt<.1, .1, .1, 1>]
            [0.2 color rgbt<1, 1, 1, .8>]
            [1.0 color rgbt<1, 1, 1, 1>]
            }
         samples 10 jitter 0.3
         rotate 90*z
         }
      }
   scale <1000, 5, 15>
   }


#declare Quadrant1=object{
   difference{
      intersection{
         cylinder {<0, 300, 190> <0, 300, 240> 305}
         box {<0, -10, 200> <310, 300, 230>}
         }
      cone  {<0, 300, 190> 290 <0, 300, 240> 305}
      }
   texture {T_Brass_5A scale 10}
   texture{
      pigment{
         image_map{
            png "regle.png"
            map_type 0
            interpolate 2
            filter 1 1
            once
            }
         scale <20, 400, 1>
         rotate -90*y
         rotate -35*z
         translate <15, 15, 205>
         }
      }
   }

#declare Quadrant2=object{
   difference{
      box {<0, -10, 200> <310, 300, 230>}
      cylinder {<0, 300, 190> <0, 300, 240> 305}
      }
   texture {T_Stone2 scale 10}
   }

#declare Quadrant_Table_Pli=intersection{
quartic{
<
// x^4,        x^3y,       x^3z,       x^3,        x^2y^2,
   0,          0,          0,          0,          1,
// x^2yz,      x^2y,       x^2z^2,     x^2z,       x^2,
   0,          0,          0,          0,          0,
// xy^3,       xy^2z,      xy^2,       xyz^2,      xyz,
   0,          0,          0,          0,          0,
// xy,         xz^3,       xz^2,       xz,         x,
   0,          0,          0,          0,          0,
// y^4,        y^3z,       y^3,        y^2z^2,     y^2z,
   0,          0,          0,          0,          0,
// y^2,        yz^3,       yz^2,       yz,         y,
   -1,          0,          0,          0,          0,
// z^4,        z^3,        z^2,        z,          C
   0,          0,          1,          0,          0
>
  sturm // optional, slower but reduces speckles
}
   box {<-1, -1, -1> <1, 0, 1>}
   bounded_by{box {<-1, -1, -1> <1, 0, 1>}}
   }

#declare Quadrant_Table_Nappe=object{
   union{
      box{< -99, 31, -60> <-1, 79,  0>}
      box{< -99, 30, -59> <-1, 80, -1>}
      box{<-100, 31, -59> <0,  79, -1>}
      sphere{<-99, 79, -59>, 1}
      sphere{< -1, 79, -59>, 1}
      sphere{<-99, 79,  -1>, 1}
      sphere{< -1, 79,  -1>, 1}
      cylinder{<-99, 79, -59> < -1, 79, -59> 1}
      cylinder{<-99, 79,  -1> < -1, 79,  -1> 1}
      cylinder{<-99, 79, -59> <-99, 79,  -1> 1}
      cylinder{< -1, 79, -59> < -1, 79,  -1> 1}
      cone {-50*y, 5, -1*y, 1 rotate -6*x rotate  -45*y translate <-99, 80,  -1>}
      cone {-50*y, 5, -1*y, 1 rotate -7*x rotate -135*y translate <-99, 80, -59>}
      object {Quadrant_Table_Pli scale <5, 50, 5> translate <-88, 79, 0>}
      object {Quadrant_Table_Pli scale <4, 50, 5> translate <-75, 79, 0>}
      object {Quadrant_Table_Pli scale <3, 50, 5> translate <-65, 79, 0>}
      object {Quadrant_Table_Pli scale <5, 50, 5> translate <-52, 79, 0>}
      object {Quadrant_Table_Pli scale <6, 50, 5> translate <-40, 79, 0>}
      object {Quadrant_Table_Pli scale <6, 50, 5> rotate 90*y translate <-100, 79, -50>}
      object {Quadrant_Table_Pli scale <5, 50, 5> rotate 90*y translate <-100, 79, -35>}
      object {Quadrant_Table_Pli scale <6, 50, 5> rotate 90*y translate <-100, 79, -10>}
      }
   texture{
      pigment {White}
      normal  {bumps 0.2 scale 10}
      finish  {ambient 0.3 diffuse 0.6 specular 0 reflection 0}
      }
   }

#declare Quadrant_Equerre=object{
   difference{
      box {<0, 0, 0> <12, .5, 18>}
      box {<2, -.5, 2> <13, 1, 19>}
      }
   texture {T_Chrome_3B scale 10}
   }

#declare Quadrant_Compas=object{
   intersection{
      box {<-10, -.25, -10> <20, .25, 20>}
      union {
         cone {0, .4, 15*x, 0 translate 1*x rotate  10*y}
         cone {0, .4, 15*x, 0 translate 1*x rotate -10*y}
         cylinder {-3*x, -1*x, .25}
         difference{
            cylinder{-y, y, 1}
            cylinder{-y, y, .95}
            }
         }
      }
   texture {T_Chrome_5C scale 10}
   translate .25*y
   }

#declare Quadrant_Parchemin=object{
   box {<0, 0, 0> <20, .1, 30>}
   pigment{rgb <1, .95, .9>*.95}
   texture{
      pigment{
         image_map {
            png "ptolematic_universe.png"
            map_type 0
            interpolate 2
            filter 1 1
            once
            }
         rotate 90*x scale <20, 1, 20> translate <0, 0, 5>
         }
      //normal{ crackle 0.5 turbulence 0.5 bump_size 10.0}
      }
   translate <-10, 0, -15>
   }

#declare Quadrant_Table=union{
   object{Quadrant_Table_Nappe}
   object{Quadrant_Equerre rotate 65*y translate <-80, 80, -20>}
   object{Quadrant_Compas rotate -125*y translate <-40, 80, -40>}
   object{Quadrant_Parchemin rotate 25*y translate <-60, 80, -30>}
   }

#declare Quadrant=union{
   object {Quadrant1}
   object {Quadrant2}
   object {Quadrant_Rayon rotate -20*z translate <0, 300, 220>}
   object {Quadrant_Table scale 1.2 translate <290, 0, 150>}
   }

#ifndef (INC_MAIN)
   #include "Tycho.pov"
#end
