// The Fractal Temple
// (c) Andreas Kahler 1997

#include "colors.inc"
#include "my_tex.inc"

#version 3

#declare TotalLevel=4
#declare final=1

#render concat("\nTotalLevel is ",str(TotalLevel,0,0),".\n")
#render concat("Final is ",str(final,0,0),".\n")

global_settings
{
  assumed_gamma 1.0
}

camera {
  ultra_wide_angle
  location  <-0.63, 0.42, -2.4>
  direction 0.41*z
//  direction 2.9*z
  right     4/3*x
  look_at   <0.1, 1.0,  0.0>
//  look_at   <-0.7,0.8,0.7>
}

#declare FlashLight=light_source {
  <0,0,0> color <0.5,0.5,0.7>
  fade_distance 2.5
  fade_power 3
#if (final>1)
  area_light <0.1, 0, 0>, <0, 0, 0.1>, 2, 2
  adaptive 1
  jitter
#end
}

object { FlashLight translate  <0.148,3.305,0.105> }

#if (final)
object { FlashLight translate  <0.199,3.022,0.090> }
object { FlashLight translate  <0.164,2.826,0.075> }
object { FlashLight translate  <0.225,2.687,0.060> }
object { FlashLight translate  <0.147,2.299,0.045> }
object { FlashLight translate <-0.011,1.960,0.030> }
object { FlashLight translate  <0.030,1.635,0.015> }
object { FlashLight translate <-0.070,1.450,0.000> }
object { FlashLight translate < 0.000,0.640,0.000> }
object { FlashLight translate  <0.910,9.305,0.905> }
light_source { <4,2,-5> color <0.5,0.5,0.5>
  fade_distance 3.0
  fade_power 3
}
light_source { <6,6,-5> color <0.5,0.5,0.5>
  fade_distance 3.0
  fade_power 3
  shadowless
}
#end

// the sky
plane { y, 1000 inverse
  rotate x*10
  texture {
    pigment {
      color rgb SkyColor
    }
    finish { diffuse 0 ambient 0.6 }
  }
  #if (final)
    texture { MyClouds scale 300 translate <600,0,-100> }
  #end
  texture {
    pigment {
      gradient y
      color_map {
        [0.0  rgb SkyColorFar filter 0.00 ]
        [0.2  rgb SkyColorFar filter 0.00 ]
        [0.5  rgb SkyColorFar filter 0.09 ]
        [1.0  rgb SkyColor    filter 0.30 ]
      }
    }
    finish { diffuse 0 ambient 0.2 }
    scale <1,1000,1>
  }
}


// the ground
plane { y, 0.01
  texture {
    pigment {
      bozo
      color_map {
         [0 rgb <0.7,0.5,0.3> ]
         [1 rgb <0.4,0.3,0.2> ]
      }
      turbulence 0.5
      scale 0.005
    }
    finish { ambient 0.02 diffuse 0.3 }
  }
  texture {
    pigment {
      gradient z
      color_map {
        [0.00  rgb <0.7,0.5,0.3> filter 0.95]
        [0.02  rgb <0.7,0.5,0.3> filter 0.95]
        [0.04  rgb <0.3,0.2,0.2> filter 0.95]
        [0.09  rgb GroundColorFar filter 0.0]
        [1.00  rgb GroundColorFar filter 0.0]
      }
      scale 300
      translate -10*z
    }
    finish { ambient 0.05 diffuse 0.5 }
  }
  //rotate x*0.1
}


// the glass sphere
#if (final)
difference {
sphere {
  <0, 1.0, 0> 0.45
  texture {
    pigment {
      image_map { gif "flash.gif" map_type 2 interpolate 2 once
                  transmit 00, 1.00
                  transmit 01, 1.00
                  transmit 02, 0.95
                  transmit 03, 0.93
                  transmit 04, 0.50
                  transmit 05, 0.40
                  transmit 06, 0.15
                  transmit 07, 0.10
                  transmit 08, 0.07
                  transmit 09, 0.06
                  transmit 10, 0.05
      }
      rotate 5*y
      translate <0,-0.5,0>
      scale <1,0.95,1>
      translate <0,1,0>
    }
    finish { ambient 0.95 diffuse 0 }
  }
  texture {MyGlass}

}
sphere { <0, 1.0, 0> 0.40
  texture {
    pigment { color rgbt 1 }
    finish { reflection 0.1 }
  }
}
}
#end

// the templar
difference {
  height_field {
    gif "ganjin_h.gif"
    #if (final>1) smooth #end
    translate <-0.5,-0.5,-0.5>
    rotate x*-90
    scale <0.6,0.7,0.6>
  }
  plane {-z,0 rotate <45, 40,0> translate 0.5*z}
  plane {-z,0 rotate <45,-40,0> translate 0.5*z}
  plane {-z,0  translate 0.2*z}

  pigment {
      image_map { gif "ganjin.gif" map_type 0 interpolate 2 once }
      translate <-0.5,-0.5,-0.5>
      scale <0.6,0.7,0.6>
  }
  finish { ambient 0.3 diffuse 0.3 }
  translate y*1.0
  bounded_by { sphere { <0,1,0>, 0.4 } }
}

// the flash
#declare FBlobMin = 0.01
#declare FBlobMax = 0.99
#declare FBlobRadius = 0.4
#declare FHaloRadius = 0.4*0.65
#declare FBlobStrength = 1

#declare FlashTex = texture {
  pigment { color rgbt <1, 1, 1, 1> }
  finish { ambient 0 diffuse 0 }
  halo {
    emitting
    cylindrical_mapping
    linear
    turbulence 0.08
    octaves 6
    lambda 1.6
    omega 1.3
    color_map {
      [ 0    color rgbt < 0, 0, 0.2, 1   > ]
      [ 0.2  color rgbt < 0, 0, 0.3, 0.4 > ]
      [ 0.6  color rgbt < 0, 0, 0.5, 0.2 > ]
      [ 0.78 color rgbt < 0, 0, 1  , 0.1 > ]
      [ 0.84 color rgbt < 1, 1, 1  ,-10  > ]
      [ 1    color rgbt < 1, 1, 1  ,-10  > ]
    }
    samples 10
    scale <FHaloRadius,1,FHaloRadius>
  }
}

//#declare FlashTex = texture {pigment { color rgb 1 }}

#if (final)
#render "\nadding flash...\n"
#include "flash.inc"
difference {
  object { MyFlash translate <-0.07,1.45,0> }
  sphere {  <0, 1.0, 0> 0.451 pigment { color Clear }}
}
difference {
  object { MyFlash2 }
  sphere {  <0, 1.0, 0> 0.451 pigment { color Clear }}
}
#end

// the dome with arcs
#render "\nadding dome...\n"
#include "arc.inc"
union {
  object { dome_arc rotate y*0   translate <-1,0.5, 1>}
  object { dome_arc rotate y*90  translate < 1,0.5, 1>}
  object { dome_arc rotate y*180 translate < 1,0.5,-1>}
  object { dome_arc rotate y*270 translate <-1,0.5,-1>}
  texture {MyGold}
}

#include "dome.inc"
object { dome
   scale <2,0.5,2>
   translate <-1,1.5,-1>
}


// the corner columns
#render "\nadding corners...\n"
#include "corner.inc"
object { corner translate <-1,0.06,-1> }
object { corner translate < 1,0.06,-1> }
object { corner translate <-1,0.06, 1> }
object { corner translate < 1,0.06, 1> }

// the steps
union {
  box { <-1.21,0.00,-1.21> <1.21,0.06,1.21> }
  box { <-1.06,0.06,-0.91> <1.06,0.12,0.91> }
  box { <-0.91,0.06,-1.06> <0.91,0.12,1.06> }
  box { <-0.91,0.12,-0.91> <0.91,0.17,0.91> }

  cylinder { <-1.21,0.05,-1.21> <+1.21,0.05,-1.21> 0.01 }
  cylinder { <-0.91,0.11,-1.06> <+0.91,0.11,-1.06> 0.01 }
  cylinder { <-0.91,0.17,-0.91> <+0.91,0.17,-0.91> 0.01 }

  cylinder { <-1.21,0.05,+1.21> <+1.21,0.05,+1.21> 0.01 }
  cylinder { <-0.91,0.11,+1.06> <+0.91,0.11,+1.06> 0.01 }
  cylinder { <-0.91,0.17,+0.91> <+0.91,0.17,+0.91> 0.01 }

  cylinder { <-1.21,0.05,-1.21> <-1.21,0.05,+1.21> 0.01 }
  cylinder { <-0.91,0.11,-1.06> <-0.91,0.11,+1.06> 0.01 }
  cylinder { <-0.91,0.17,-0.91> <-0.91,0.17,+0.91> 0.01 }

  cylinder { <+1.21,0.05,-1.21> <+1.21,0.05,+1.21> 0.01 }
  cylinder { <+0.91,0.11,-1.06> <+0.91,0.11,+1.06> 0.01 }
  cylinder { <+0.91,0.17,-0.91> <+0.91,0.17,+0.91> 0.01 }

  texture { MyMarble }
}


// the floor
box {
  <-0.91,0.17,-0.91> <0.91,0.18,0.91>
  texture { MyMarble }
  texture {
    pigment {
      image_map {
        gif "square.gif"
        map_type 0 interpolate 2 once
        filter 0 1
      }
    }
    finish { reflection 0.1 }
    translate <-0.5,-0.5,0>
    rotate x*90
    scale 1.82
  }
}


// the chrome pyramid
#render "\nadding pyramid...\n"
#declare Pyramid = union {
  triangle { <-1, 0, -1>, <+1, 0, -1>, <0, 1, 0>  }
  triangle { <+1, 0, -1>, <+1, 0, +1>, <0, 1, 0>  }
  triangle { <-1, 0, +1>, <+1, 0, +1>, <0, 1, 0>  }
  triangle { <-1, 0, +1>, <-1, 0, -1>, <0, 1, 0>  }
  triangle { <-1, 0, -1>, <-1, 0, +1>, <1, 0, +1>  }
  triangle { <-1, 0, -1>, <+1, 0, -1>, <1, 0, +1>  }
  scale <1, 2, 1>
}
union {
  #declare pyr_size = 0.15
  #declare level = TotalLevel

  #declare x_pos = 0
  #declare y_pos = 0.17
  #declare z_pos = 0

  #include "pyramid.inc"

  texture { Chrome }
  scale <1.6,1.1,1.6>
}

// the 3D hilbert block
#render "\nadding hilbert block...\n"
#include "hilbert.inc"
object {
  hilbert3d
  pigment { color <1.0,0,0.2> }
  finish {
    ambient 0.1
    diffuse 0.7
    metallic on
    reflection <0.1,0.02,0.05>
    phong 0.8
    phong_size 120
  }
  scale 0.27
  rotate <-30,0,30>
  translate <0.7,0.7,-0.7>
}

// the Escher Knot
#render "\nadding escher knot...\n"
#declare r1=1.0
#declare A=0.04
#declare B=0.01
#declare C=0.03
#declare D=0.06
#declare E=1.0
#declare MaxCount=314
#declare Count=0
blob {
  #while (Count<=MaxCount)
    #declare X=r1*(sin(A*Count)+E*sin(C*Count)*sin(B*Count))
    #declare Y=r1*(cos(A*Count)+E*sin(C*Count)*cos(B*Count))
    #declare Z=r1*cos(D*Count)*0.7
    sphere { <X,Y,Z>, 0.5, 1
      #declare colbias=abs((Count-MaxCount/2)/MaxCount)*2.5
      pigment { color rgb <colbias, 0.1, 0.9-colbias*0.6> }
      finish {
         ambient 0.2
         diffuse 0.6
         phong 0.6
         phong_size 60
         brilliance 1
         reflection 0.05
      }
    }
    #declare Count=Count+1
  #end
  pigment { color rgb 1}
  scale 0.09
  rotate <0,0,90>
  translate <-0.7,0.4,-0.7>
}


// the 3D snowflake
#render "\nadding 3D snowflake...\n"

#declare Tetra = intersection {
   plane {-y,1}
   plane {-z,1 rotate <19.47,    0, 0>}
   plane {-z,1 rotate <19.47, -120, 0>}
   plane {-z,1 rotate <19.47,  120, 0>}
   bounded_by { sphere { <0,0,0>, 3.0 }}
}

#declare level=TotalLevel - 1
union {
  object {
    Tetra
    rotate 180*x
    pigment {color rgb <0.1,0,0.7>}
    finish { ambient 0.1 diffuse 0.5 brilliance 1 phong 0.6 phong_size 60 }
  }
  #include "snowflak.inc"
  pigment {color rgb <0.9,0,0.1>}
  finish { ambient 0.1 diffuse 0.6 brilliance 1 phong 0.6 phong_size 60 reflection 0.1}
  scale 0.1
  rotate <90,30,0>
  translate <-0.7,0.9,0.7>
}


// 3D Julia Fractal
#render "\nadding 3D Julia Fractal...\n"
julia_fractal {
  <-0.8, 0.39, 0.15, 0.15>
  precision 1000
  max_iteration 12
  texture {
    pigment { color rgb <0.8,0.55,1.0>  }
    finish {
      ambient 0.2
      diffuse 0.6
      phong 0.7
      phong_size 20
    }
  }
  rotate <30,50,10>
  scale <0.6,0.9,0.5>
  scale 0.5
  translate <0.7,0.4,0.7>
}

// mountains
#render "\nadding mountains...\n"
height_field {
    gif "fracmnts.gif"
    water_level 0.00001
    #if (final) smooth #end
    translate <-0.5,-0.1,-0.5>
    texture {
      pigment {
        gradient y
        color_map {
          [0.0  rgb GroundColorFar ]
          [1.0  rgb <0.1,0.1,0.9> ]
        }
      }
      finish { ambient 0.05 diffuse 0.5 }
    }
    scale <800,30,20>
    translate <20,0,200>
}
light_source { <400,80,180> color rgb 1
  fade_distance 1000
  fade_power 4
  shadowless
}


#render "\nparsing complete.\n"
