#version 3.0

#include "colors.inc"

// Boy surface en Fil de Fer

#declare txSphere = texture {
   pigment {
     color rgb<0.710, 0.650, 0.260>
   }
   finish {
     diffuse 0.700
     ambient 0.200
     phong 0.750
     phong_size 80.000
     reflection 0.250
     brilliance 6.000
   }
}

#declare txCyl = texture {
   pigment {
     color rgb<0.659, 0.659, 0.659>
   }
   finish {
     diffuse 0.700
     ambient 0.300
     reflection 0.150
     specular 0.800
     roughness 0.1000
     brilliance 8.000
   }

}

//******** MERIDIENS *********
#declare SphRay=0.5
#declare maxcntmu=20
#declare maxcntte=40
#declare cntmu = 0

#while (cntmu<maxcntmu)
  #declare mu=cntmu*pi/maxcntmu
  #declare myD=10+1.41*sin(6*mu-pi/3)
  #declare myE=1.98*sin(3*mu-pi/6)
  #declare myA=myD+myE
  #declare myB=myD-myE
  #declare myAL=(pi/8)*sin(3*mu)
  #declare myC1=myA*myA-myB*myB
  #declare myC2=sqrt(myA*myA+myB*myB)
  #declare myCM=cos(mu)
  #declare mySM=sin(mu)

  #declare cntte=0
  #while  (cntte<maxcntte)
   #declare te=cntte*2*pi/maxcntte
   #declare myX1=myC1/myC2+myA*cos(te)-myB*sin(te)
   #declare myZ1=myC2+myA*cos(te)+myB*sin(te)
   #declare myX=myX1*myCM-myZ1*sin(myAL)*mySM
   #declare myY=myX1*mySM+myZ1*sin(myAL)*myCM
   #declare myZ=myZ1*cos(myAL)
   #declare cntte=cntte+1

   #declare te=cntte*2*pi/maxcntte
   #declare myX1=myC1/myC2+myA*cos(te)-myB*sin(te)
   #declare myZ1=myC2+myA*cos(te)+myB*sin(te)
   #declare myXa=myX1*myCM-myZ1*sin(myAL)*mySM
   #declare myYa=myX1*mySM+myZ1*sin(myAL)*myCM
   #declare myZa=myZ1*cos(myAL)


    cylinder
    {
     <myX,myY,myZ>,<myXa,myYa,myZa>,SphRay*0.75
     texture { txCyl }
    }
    sphere
   {
     <myX,myY,myZ>,SphRay
     texture {txSphere }
   }

  #end
  #declare cntmu=cntmu+1
#end

//******** PARALELLES **********
#declare SphRay=0.5
#declare maxcntmu=40
#declare maxcntte=20
#declare cntte = 0

#while (cntte<maxcntte)
  #declare cntmu=0
  #while  (cntmu<maxcntmu)

  #declare mu=cntmu*pi/maxcntmu
  #declare myD=10+1.41*sin(6*mu-pi/3)
  #declare myE=1.98*sin(3*mu-pi/6)
  #declare myA=myD+myE
  #declare myB=myD-myE
  #declare myAL=(pi/8)*sin(3*mu)
  #declare myC1=myA*myA-myB*myB
  #declare myC2=sqrt(myA*myA+myB*myB)
  #declare myCM=cos(mu)
  #declare mySM=sin(mu)
   #declare te=cntte*2*pi/maxcntte
   #declare myX1=myC1/myC2+myA*cos(te)-myB*sin(te)
   #declare myZ1=myC2+myA*cos(te)+myB*sin(te)
   #declare myX=myX1*myCM-myZ1*sin(myAL)*mySM
   #declare myY=myX1*mySM+myZ1*sin(myAL)*myCM
   #declare myZ=myZ1*cos(myAL)

   #declare cntmu=cntmu+1

  #declare mu=cntmu*pi/maxcntmu
  #declare myD=10+1.41*sin(6*mu-pi/3)
  #declare myE=1.98*sin(3*mu-pi/6)
  #declare myA=myD+myE
  #declare myB=myD-myE
  #declare myAL=(pi/8)*sin(3*mu)
  #declare myC1=myA*myA-myB*myB
  #declare myC2=sqrt(myA*myA+myB*myB)
  #declare myCM=cos(mu)
  #declare mySM=sin(mu)
   #declare te=cntte*2*pi/maxcntte
   #declare myX1=myC1/myC2+myA*cos(te)-myB*sin(te)
   #declare myZ1=myC2+myA*cos(te)+myB*sin(te)
   #declare myXa=myX1*myCM-myZ1*sin(myAL)*mySM
   #declare myYa=myX1*mySM+myZ1*sin(myAL)*myCM
   #declare myZa=myZ1*cos(myAL)


cylinder
{
  <myX,myY,myZ>,<myXa,myYa,myZa>,SphRay*0.75
  texture { txCyl }
}
   sphere
   {
     <myX,myY,myZ>,SphRay
     texture {txSphere }
   }

  #end
  #declare cntte=cntte+1
#end

