//
//  Mesh4.pov
//+
//	2D mesh
//-
//  rev 05/12/97 gls continue
//  rev 05/11/97 gls
//


#include "colors.inc"
#include "textures.inc"

#declare ScaleXYZ= 0.01

#declare Default = texture { pigment{ White } }

#declare fDebugPlanes = 0
#declare fDebugXYZ = 0


camera
      {
      location  <125, 125, -200>      // x, y, z
///      location  <125, 125, -125>      // x, y, z
      direction <0, 0,  1>
      up        <0, 1,  0>
      right     <3/3, 0, 0>
//      right     <4/3, 0, 0>
     look_at   <125, 125, 0>
 //     look_at   <0, 0, 0>
      }

// //////////////////////////////////////////////////

//
//  Describe the light sources to project the shadows
//
light_source
    {
    <125, 125, -125> color White
    }

// //////////////////////////////////////////////////

//
//  X axis
//
#declare objLineX =
        cylinder
                {
                <0,0,0>,       // Center of one end
                <1000,0,0>,       // Center of other end
                1.5            // Radius
                open           // Remove end caps
                pigment {color Green}
                finish {Shiny}
                }
//
//  Y axis
//
#declare objLineY =
        cylinder
                {
                <0,0,0>,       // Center of one end
                <0,1000,0>,       // Center of other end
                1.5            // Radius
                open           // Remove end caps
                pigment {color Green }
                finish {Shiny}
                }

#declare Xinc=25
#declare Yinc=25

#declare cX=0
#while (cX < 25)
        object{ objLineX translate <0, Yinc*cX, 0 >}
#declare cX =cX +1
#end

#declare cY=0
#while (cY< 25)
        object{ objLineY translate <Xinc*cY, 0, 0 >}
#declare cY=cY+1
#end



// //////////////////////////////////////////////////
#if (fDebugPlanes)
plane
     {
     y, -50                     // axis, distance from origin
     pigment { color Green }
///     pigment { color Aquamarine   }
     }

plane
     {
     x, -50                     // axis, distance from origin
     pigment { color Red }
///     pigment { color White }
     }

plane
     {
     z, 50                     // axis, distance from origin
     pigment { color Blue }
     }
#end

// //////////////////////////////////////////////////
//
//  Now, a sphere for demo purposes
//

sphere
      {
      <5, 5, -5> 2
      pigment {
              color Silver
              }
      finish  {
              Shiny
              }

      }
// //////////////////////////////////////////////////

// //////////////////////////////////////////////////
#if (fDebugXYZ)
//
//  Now, the X axis
//
cylinder
        {
        <1,0,0>,       // Center of one end
        <1000,0,0>,       // Center of other end
        2.5            // Radius
        open           // Remove end caps
        pigment {color Red }
        finish {Shiny}
        }

//
//  Y axis
//
cylinder
        {
        <0,1,0>,       // Center of one end
        <0,1000,0>,       // Center of other end
        2.5            // Radius
        open           // Remove end caps
        pigment {color Green }
        finish {Shiny}
        }


//
//  Z axis
//
cylinder
        {
        <0,0,-1>,       // Center of one end
        <0,0,-1000>,       // Center of other end
        2.5            // Radius
        open           // Remove end caps
        pigment {color Blue }
        finish {Shiny}
        }
#end

// //////////////////////////////////////////////////
// //////////////////////////////////////////////////
// //////////////////////////////////////////////////

