//
//	Pi.pov
//+
//	PI in the sky
//-
//	rev 06/17/97 gls continue
//	rev 06/13/97 gls continue
//	rev 06/11/97 gls
//


#include "colors.inc"
#include "glass.inc"
#include "metals.inc"
#include "golds.inc"
#include "woods.inc"
#include "skies.inc"
#include "stones.inc"
#include "textures.inc"



//
//  Global parameters
//
global_settings { ambient_light rgb <1, 1, 1> }
global_settings { radiosity { brightness 1.0 } }
//global_settings { assumed_gamma 1.5 }

camera
      {
//      panoramic
#if (0)
    [ perspective | orthographic | fisheye |
      ultra_wide_angle | omnimax | panoramic |
      cylinder FLOAT ]

#end

#declare ScaleLoc=6

      location  <0, 0, -150/ScaleLoc>      // x, y, z
//      location  <150/ScaleLoc, 50/ScaleLoc, -150/ScaleLoc>      // x, y, z
//      location  <150, 50, -150>      // x, y, z
///      location  <15*1+5, 20*1, -75*1-10>      // x, y, z
//      location  <30*1, 30*1, -70*1>      // x, y, z
//      location  <40*1, 40*1, -70*1>      // x, y, z
//      location  <25, 25, -60>      // x, y, z
      direction <0, 0,  1>
      up        <0, 1,  0>
      right     <4/3, 0, 0>
      look_at   <0, 0, 0>
      }




// //////////////////////////////////////////////////


light_source { <-20, 120, -250> color White }
//light_source { <120, 120, -250> color White }

//light_source { < 50, 50, 5> color White  shadowless }
//light_source { < 50, 50, 50> color White  shadowless }



// //////////////////////////////////////////////////

//
//  Now, the object that is displayed at the color points...
//
//

//
//	Include the placement objects
//
#include "pi.inc"      // include the text objects


// //////////////////////////////////////////////////


// create a sphere shape
#if(0)
sphere
{
  <0, 0, 0> // center of sphere <X Y Z>
  2.0       // radius of sphere
    texture { T_Gold_5E finish { phong 0.9 phong_size 60 } }
  // scale <1,2,1> // <= Note: Spheres can become ellipses by uneven scaling
}
#end

#declare PiScale=1.5

#if(0)
text {
    ttf             // font type (only TrueType format for now)
    "symbol.ttf",   // Microsoft Windows-format TrueType font file name
    "p",          // the string to create
    0.5,            // the extrusion depth
    0               // offset

    texture { pigment{ Blue_Agate } finish { phong 0.9 phong_size 60 } }
//    texture { T_Stone21 }
//    texture { T_Gold_5E finish { phong 0.9 phong_size 60 } }
    scale 10.0 * PiScale
    translate < -3.0 * PiScale, -2 * PiScale, 30 >
}
#end


// //////////////////////////////////////////////////

//
//  Now, the signature (Using a TrueType font)...
//
text {
    ttf             // font type (only TrueType format for now)
    "timrom.ttf",   // Microsoft Windows-format TrueType font file name
    "GLS",          // the string to create
    0.25,            // the extrusion depth
    0               // offset

    texture { T_Gold_5E finish { phong 0.9 phong_size 60 } }
    scale 2.0
    translate < -15, -10, 00>
}




// //////////////////////////////////////////////////
//
//  Now, some reference lines...
//

// Capped Cylinder, closed [or open ended]
// cylinder { <END1>, <END2>, RADIUS [open] }
//  END1 = coord of one end of cylinder
//  END2 = coord of other end
// RADIUS = size of cylinder
// open = if present, cylinder is hollow, else capped
#if (0)
cylinder {
     0*x, 200*x,  0.1
     pigment { color Red }
     finish { phong 0.3 }
     }

cylinder {
     0*y, 200*y,  0.1
     pigment { color Green }
     finish { phong 0.3 }
     }

cylinder {
     0*z, -200*z,  0.1
     pigment { color Blue}
     finish { phong 0.3 }
     }
#end

// //////////////////////////////////////////////////
//
//      Now, some type of background to project on
//

#if(1)

sky_sphere { S_Cloud2 }


#else
// The sky
#declare MyStarField =
    pigment {
        granite
            color_map {
                [ 0.00  0.72 color Black  color Black ]  // No Stars in this area
                [ 0.72  0.75 color Gray20 color Gray40 ] // Very Very Faint Stars
                [ 0.75  0.78 color Gray40 color Gray60 ] // Very Faint Stars
                [ 0.78  0.81 color Gray60 color Gray80 ] // Faint Stars
                [ 0.81  0.85 color Gray80 color Gray95 ] // Medium White Stars
                [ 0.85  0.91 color Gray95 color White  ] // White Stars
                [ 0.91  1.00 color Black  color Black ]  // No Stars in this area
            }
         scale .015
     }

#declare MyApocalypse =
pigment {
    bozo
    color_map {
        [0.0, 0.3 color rgbt <0.8, 0.0, 0.0, 0.0 >
                  color rgbt <0.4, 0.0, 0.4, 0.3 >]
        [0.3, 0.6 color rgbt <0.4, 0.0, 0.4, 0.3 >
                  color rgbt <0.0, 0.0, 0.2, 0.85 >]
        [0.6, 1.0 color rgbt <0.0, 0.0, 0.2, 0.85 >
                  color rgbt <0.0, 0.0, 0.0, 1.0 >]
    }
}
#declare MyLightning =
pigment {
    marble
    color_map {
        [0.0, 0.01          color rgbt <1.0, 1.0, 1.0, 0.0 >
                            color rgbt <0.94, 0.81, 0.99, 0.65 >]
        [0.01, 0.010001     color rgbt <0.94, 0.81, 0.99, 0.65 >
                            color rgbt <1.0, 1.0, 1.0, 1.00 >]
        [0.010001, 1.0      color rgbt <1.0, 1.0, 1.0, 1.00 >
                            color rgbt <1.0, 1.0, 1.0, 1.00 >]
    }
}


sky_sphere {
    pigment {
//        MyStarField
        P_Cloud1
    }
    pigment {
            MyApocalypse
            turbulence 1.5
            scale .30
            rotate < -45, 0, 0 >
    }
    pigment {
            MyLightning
            turbulence 0.5
            scale .5
    }
    pigment {
            MyLightning
            turbulence 0.4
            scale .7
            rotate < 0, -5, 135 >
    }
    pigment {
            MyLightning
            turbulence 0.45
            scale .6
            rotate < 0, 4, -140 >
    }
    pigment {
            MyLightning
            turbulence 0.45
            scale .4
            rotate < -40, 4, -90 >
    }
}
#end


// //////////////////////////////////////////////////

#if ( 0          )
plane
     {
     x, -25                     // axis, distance from origin
     pigment { color White }
     }

plane
     {
     y, -25                     // axis, distance from origin
     pigment { color White }
//     pigment { checker color White color Black }
     }

plane
     {
     z, 25              // axis, distance from origin
     pigment { color White }
     }
#end


// //////////////////////////////////////////////////
// //////////////////////////////////////////////////
// //////////////////////////////////////////////////

