#
#	spiral.awk
#+
#	Generate a spiral object to infinity
#-
#	rev 06/17/97 gls change to fade to (0,0,0) 
#	rev 06/16/97 gls fix bug in dropping last char in record
#	rev 06/13/97 gls continue
#	rev 06/12/97 gls
#
# //////////////////////////////////////////////////
function PlaceObj( iObj )
{

dX = 10.0;
dX = 10.0 * exp( -0.0005 * iObj);	## asymtopically to zero
dY = 0.0;
dZ = 0.20 * iObj;


dRotX = dRotY = 0.0;
dRotZ = 7.0 * iObj;

printf( "object{ " );
printf( "\tobjSpiral%d\n", iObj );

printf( "\trotate <0.0, 0.0, -90.0>\n" );

printf( "\ttranslate <%.2f, %.2f, %.2f>\n", dX, dY, dZ );
printf( "\trotate <%.2f, %.2f, %.2f>\n", dRotX, dRotY, 90+45 - dRotZ );
printf( "\t}\n" );


}

# //////////////////////////////////////////////////
function GenObj( iObj, nCH )
{

printf( "#declare objSpiral%d=\n", iObj );
printf( "\tobject {\n" );

	printf( "\t\t" );
	printf( "text { " );
	printf( "ttf " ); 	##  font type (only TrueType format for now)
	printf( "\"timrom.ttf\", " );   ## Windows TrueType font file name
	printf( "\"%c\", ", nCH );	## the string to create
	printf( "0.5, " );            ## the extrusion depth
	printf( "0 " );             ## offset
	printf( "}\n" );
##	printf( "\t\ttexture { T_Gold_5E finish { phong 0.9 phong_size 60 } }\n" );
	printf( "\t\ttexture { %s }\n",
		"T_Gold_5E finish { phong 0.9 phong_size 60 }" );
	printf( "\t\tscale 2.0\n" );

printf( "\t\t}\n" );

##    texture { T_Vicksbottle_Glass}
##      texture { T_Gold_5E finish { phong 0.9 phong_size 60 } }
##    pigment { BrightGold }
}
# //////////////////////////////////////////////////
BEGIN{
printf( "//\n" );
printf( "//\tGenerated with spiral.awk\n" );
printf( "//\n" );
nObj=0
}

# //////////////////////////////////////////////////
{
	printf( "// %s\n", $0 );

	cCH = length( $0 );

##	for(iCH=1; iCH<cCH; iCH++)
	for(iCH=1; iCH<(cCH+1); iCH++)
		{
		CH = substr( $0, iCH, 1 );

		GenObj( nObj, CH );
		PlaceObj( nObj );

		nObj++;
		}



}

# //////////////////////////////////////////////////
END{

printf( "// //////////////////////////////////////////////////\n" );
printf( "// //////////////////////////////////////////////////\n" );
printf( "// //////////////////////////////////////////////////\n" );
}


# //////////////////////////////////////////////////
# //////////////////////////////////////////////////
# //////////////////////////////////////////////////
