// Fichero de POVRAY 3 por:
// POVRAY 3 file by:
//  Guillermo S. Romero

// E-mail:     famrom@ran.es
// Snail-mail: P.O.Box 35099-28080 Madrid (Espaa)

// Este fichero contiene:
//  Un experimento laser.
//--
// This file contains:
//  A laser experiment.

// ** IMPORTANT ** Wrong use can cause errors, I decline ALL responsability.
// INCLUDE FLAGS
//
// For multiple "include"s of this file use multiple flags, think about this
//  condition as arguments required by functions.


#declare AmbientLight = <1, 1, 1> * .3

global_settings {
    assumed_gamma 2.4
    max_trace_level 16
    ambient_light AmbientLight
}


#include "colors.inc"
#include "finish.inc"
#include "woods.inc"
//#include "glass.inc"
#include "metals.inc"
#include "stones1.inc"
#include "orngwood.map"

/* No time avaliable means no radiosity, sorry =:( */
//#include "consts.inc"
//#declare Rad_Quality = 3 // From 1 to 5
//#include "rad_def.inc"


// --- Select a color (red, green or blue are ok)
#declare LaserColor = rgb <0, 1, 0>
#declare LaserWhite = rgb <.9, 1, .9>


// --- Textures
#declare T_LaserBeam =
    texture {
        pigment { rgbt 1 }
        halo {
            emitting
            /*cubic spherical_mapping By error, but the result is funny */
            cubic cylindrical_mapping
            samples 20
            color_map {
                [ 0 rgbt <0, 0, 0, 1> ]
                [ 1 LaserColor transmit -1 ]
            }
           turbulence .025
           rotate -90*z
        }
    }

#declare T_LaserPoint =
    texture {
        pigment { rgbt 1 }
        halo {
            emitting
            cubic spherical_mapping
            samples 20
            color_map {
                [ 0 rgbt <0, 0, 0, 1> ]
                [ .8 LaserColor transmit -1 ]
                [ 1 LaserWhite transmit -1 ]
            }
           turbulence .025
        }
    }

#declare T_Glass =
    texture {
        pigment { color rgbf <1, 1, 1, .7> }
        finish {
            specular 1
            roughness 0.001
            ambient 0
            diffuse 0
            refraction 1   
            reflection 0.1
            ior 1.5
        }
    }

#declare T_DemiMirror =
    texture {
        pigment { color rgbf <1, 1, 1, .7> }
        finish {
            specular 1
            roughness 0.001
            ambient 0
            diffuse 0
            refraction 1   
            reflection 0.5
            ior 1.5
        }
    }


// --- Beams
#declare Beam1 =
    cylinder {
        <0, 0, 0>, <1.15, 0, 0>, 1
        texture { T_LaserBeam }
        hollow
    }

#declare Light1 =
    light_source {
        <0, 0, 0> LaserColor*.3
        area_light <0, .1, 0>, <1.05, 0, 0>, 1, 11
        adaptive 2 jitter
        fade_distance .1 fade_power 2
    }

#declare Beam2 =
    cylinder {
        <0, 0, 0>, <0, 0, .7>, 1
        texture { T_LaserBeam rotate 90*y }
        hollow
    }

#declare Light2 =
    light_source {
        <0, 0, 0> LaserColor*.3
        area_light <0, .1, 0>, <0, 0, .7>, 1, 7
        adaptive 2 jitter
        fade_distance .1 fade_power 2
    }

#declare Beam3 =
    cylinder {
        <0, 0, 0>, <.75, 0, 0>, 1
        texture { T_LaserBeam }
        hollow
    }

#declare Light3 =
    light_source {
        <0, 0, 0> LaserColor*.3
        area_light <0, .1, 0>, <.75, 0, 0>, 1, 8
        adaptive 2 jitter
        fade_distance .1 fade_power 2
    }

#declare BeamPoint =
    light_source {
        <0, 0, 0> LaserColor*.5
        fade_distance .1 fade_power 2
        looks_like {
            sphere {
                0, 1
                texture { T_LaserPoint }
                hollow
            }
        }
    }


// --- The Laser?
#declare LaserCannon =
    intersection {
        union {
            box { <-.25, .055, -.05>, <.25, .145, .05> }
            box { <-.25, .05, -.045>, <.25, .15, .045> }
            cylinder { <-.25, .055, .045>, <.25, .055, .045>, .005 }
            cylinder { <-.25, .055, -.045>, <.25, .055, -.045>, .005 }
            cylinder { <-.25, .145, .045>, <.25, .145, .045>, .005 }
            cylinder { <-.25, .145, -.045>, <.25, .145, -.045>, .005 }
        }
        box { // Front
            <.24, .06, -.04>, <.26, .14, .04>
            inverse
        }
        cylinder { // Hole
            <0, .1, 0>, <.26, .1, 0>, .01
            inverse
        }
        texture {
            pigment { Gray75 }
            normal { bumps .1 scale .005 }
            finish {
                specular .5
                roughness .01
                reflection .05
            }
        }
    }

#declare LaserFoot =
    intersection {
        box { <-.025, 0, -.1>, <.025, .1, .1> }
        cylinder {
            <-.026, 0, 0>, <.026, 0, 0>, .1
            scale <1, .8, 1.2>
        }
        cylinder {
            <-.026, 0, 0>, <.026, 0, 0>, .05
            scale <1, .5, 1.1>
            inverse
        }
    }

#declare Laser =
    union {
        object { LaserCannon }
        object { LaserFoot translate -.175*x }
        object { LaserFoot translate .175*x }
        texture { // Black lack
            pigment { Gray10 }
            finish {
                specular .5
                roughness .01
                reflection .1
            }
        }
    }


// --- What's this? =;]
#declare NutR = .0085 // NutRadius
#declare Deg60 = radians (60)
#declare Deg120 = radians (120)
#declare Deg240 = radians (240)
#declare Deg300 = radians (300)
#declare Nut =
    intersection {
        prism {
            linear_sweep linear_spline
            0, 1,
            7,
            <NutR, 0>,
            <NutR * cos (Deg60), NutR * sin (Deg60)>,
            <NutR * cos (Deg120), NutR * sin (Deg120)>,
            <-NutR, 0>,
            <NutR * cos (Deg240), NutR * sin (Deg240)>,
            <NutR * cos (Deg300), NutR * sin (Deg300)>,
            <NutR, 0>
            scale <1, .01, 1>
        }
        cylinder {
            <0, -.001, 0>, <0, .011, 0>, .005
            inverse
        }
        texture {
            T_Chrome_2B
            normal { wrinkles .25 scale .001 }
        }
    }


// --- Optics
#declare GenericBase =
    union {
        intersection {
            box { <-.05, 0, -.05>, <.05, .025, .05> }
            cylinder { <0, -.001, 0>, <0, .026, 0>, .06 }
            texture {
                pigment { Gray20 }
                normal { bumps -.1 scale .001 }
                finish {
                    phong 1
                    phong_size 30
                }
            }
        }
        cylinder {
            <0, 0, 0>, <0, .05, 0>, .005
            texture {
                T_Chrome_3D
                normal { bumps .125 scale .001 }
            }
        }
        object { Nut translate .04*y }
    }

#declare LensGlass =
    intersection {
        sphere { <-.055, 0, 0>, .07 }
        sphere { <.055, 0, 0>, .07 }
        cylinder { <-.02, 0, 0>, <.02, 0, 0>, .04 }
        translate <0, .1, 0>
        texture { T_Glass }
        hollow
    }

#declare Lens =
    union {
        object { GenericBase }
        object { LensGlass }
        intersection {
            box { <-.005, -.05, -.05>, <.005, .05, .05> }
            box { <-.0051, -.05, -.05>, <.0051, .05, .05> rotate 45*x }
            cylinder { <-.01, 0, 0>, <.01, 0, 0>, .04 inverse }
            translate .1*y
            texture {
                T_Chrome_4A
                normal { bumps -.1 scale .002 * <1, 5, 1> }
            }
        }
    }

#declare DemiMirrorGlass =
    cylinder {
        <-.003, 0, 0>, <.003, 0, 0>, .04
        translate <0, .1, 0>
        texture { T_DemiMirror }
        hollow
    }

#declare DemiMirror =
    union {
        object { GenericBase }
        object { DemiMirrorGlass }
        intersection {
            box { <-.005, -.05, -.05>, <.005, .05, .05> }
            box { <-.0051, -.05, -.05>, <.0051, .05, .05> rotate 45*x }
            cylinder { <-.01, 0, 0>, <.01, 0, 0>, .04 inverse }
            translate .1*y
            texture {
                T_Chrome_4A
                normal { bumps -.1 scale .002 * <1, 5, 1> }
            }
        }
    }

#declare MirrorGlass =
    box {
        <-.001, -.05, -.05>, <.001, .05, .05>
        translate <0, .1, 0>
        texture {
            pigment { White }
            finish { Mirror }
        }
    }

#declare MirrorPlank =
    union {
        object { GenericBase }
        object { MirrorGlass }
        sphere {
            0, .01
            scale <.5, 1, 3>
            translate .05*y
            texture {
                pigment { Gray15 }
                normal { granite .1 scale .001 }
                finish { Phong_Glossy }
            }
        }
    }


// --- No comments
#declare Desk =
    union {
        box { <-.95, 0, -.45>, <.95, .015, .45> }
        box { <-1, 0, -.4975>, <1, .02, -.4025> }
        box { <-1, 0, -.4975>, <1, .02, -.4025> translate 1*.1*z }
        box { <-1, 0, -.4975>, <1, .02, -.4025> translate 2*.1*z }
        box { <-1, 0, -.4975>, <1, .02, -.4025> translate 3*.1*z }
        box { <-1, 0, -.4975>, <1, .02, -.4025> translate 4*.1*z }
        box { <-1, 0, -.4975>, <1, .02, -.4025> translate 5*.1*z }
        box { <-1, 0, -.4975>, <1, .02, -.4025> translate 6*.1*z }
        box { <-1, 0, -.4975>, <1, .02, -.4025> translate 7*.1*z }
        box { <-1, 0, -.4975>, <1, .02, -.4025> translate 8*.1*z }
        box { <-1, 0, -.4975>, <1, .02, -.4025> translate 9*.1*z }
        texture {
            pigment {
                P_WoodGrain14A
                color_map { M_Wood14A }
                scale .05
                rotate 90*y
                warp { repeat .1*z offset .03*y }
            }
            normal {
                bumps .1
                scale <.01, 1, .001>
            }
        } 
        texture {
            pigment {
                P_WoodGrain14B
                color_map { M_Wood14B }
                scale .05
                rotate 90*y
                warp { repeat .1*z offset .03*y }
            }
            normal {
                bumps .1
                scale <.01, 1, .001>
            }
            finish { Glossy }
        }
    }

#declare Shelf =
    union {
        box { <-.475, 0, -.2>, <.475, .015, -.45> }
        box { <-.5, 0, -.4975>, <.5, .02, -.4025> }
        box { <-.5, 0, -.4975>, <.5, .02, -.4025> translate 1*.1*z }
        box { <-.5, 0, -.4975>, <.5, .02, -.4025> translate 2*.1*z }
        union { // Supports
            box { <.4, -.02, -.2>, <.42, 0, -.45> }
            box { <-.42, -.02, -.2>, <-.4, 0, -.45> }
            texture { pigment {Gray50} }
        }
        texture {
            pigment {
                P_WoodGrain14A
                color_map { M_Wood14A }
                scale .05
                rotate 90*y
                warp { repeat .1*z offset .03*y }
            }
            normal {
                bumps .1
                scale <.01, 1, .001>
            }
        } 
        texture {
            pigment {
                P_WoodGrain14B
                color_map { M_Wood14B }
                scale .05
                rotate 90*y
                warp { repeat .1*z offset .03*y }
            }
            normal {
                bumps .1
                scale <.01, 1, .001>
            }
            finish { Glossy }
        }
    }

#declare CorkBoard =
    box {
        <-.5, .1, .49>, <.5, .6, .5>
        texture { // Cork from textures.v2
            pigment {
                granite
                color_map { M_Orangewood }
                /*color_map {
                    [0.00, 0.60 color rgb <0.81, 0.59, 0.42>
                                /*color rgb <0.93, 0.71, 0.532>*/
                                color rgb <0.74, 0.58, 0.43>]
                                /*color rgb <0.98, 0.81, 0.60>]*/
                    [0.60, 0.65 color rgb <0.50, 0.30, 0.20>
                                color rgb <0.50, 0.30, 0.20>]
                    [0.65, 1.00 color rgb <0.69, 0.46, 0.36>
                                /*color rgb <0.80, 0.53, 0.46>*/
                                color rgb <0.65, 0.50, 0.26>]
                                /*color rgb <0.85, 0.75, 0.35>]*/
                }*/
            }
            normal { granite .1 }
            finish {
                specular 0.1
                roughness 0.5
            }
            scale 0.25
            scale <.1, .05, .1>
        }
    }

#declare CorkPin =
    union {
        cone {
            <0, 0, -.015>, .0005, <0, 0, .005>, .0005
            texture { T_Chrome_3B }
        }
        sphere {
            <0, 0, -.015>, .005
            texture {
                pigment { DarkGreen }
                finish {
                    specular 1
                    roughness .05
                    reflection .125
                }
            }
        }
    }

#declare ShuttlePoster =
    box {
        <0, 0, -.0001>, <1, 1, 0>
        texture {
            pigment {
                image_map {
                    png "shuttle.png"
                }
            }
        }
        translate <-.5, -.5, 0>
        scale <.75, .575, 1>
    }


// ----- Place all!!! -----
// --- Laser System
object {
    Laser
    translate <-.45, .02, -.35>
}

object {
    DemiMirror
    rotate 45*y
    translate <.1, .02, -.35>
}

object {
    MirrorPlank
    rotate 45*y
    translate <.1, .02, .35>
}


// --- Beams
object {
    Beam1
    scale <1, .005, .005>
    translate <-.4, .12, -.35>
}

object {
    Light1
    translate <.325, .12, -.35>
}

object {
    Beam2
    scale <.005, .005, 1>
    translate <.1, .12, -.35>
}

object {
    Light2
    translate <.1, .12, 0>
}

object {
    Beam3
    scale <1, .005, .005>
    translate <.1, .12, .35>
}

object {
    Light3
    translate <.475, .12, .35>
}

object {
    BeamPoint
    scale .02
    translate <.1, .12, .35>
}

object {
    BeamPoint
    scale .02
    translate <.1, .12, -.35>
}

object {
    BeamPoint
    scale .02
    translate <-.2, .12, -.35>
}


// --- General
object { Desk }

object {
    Shelf
    rotate -90*y
    translate <-1.2, .3, 0>
}

object {
    Lens
    rotate -5*y
    translate <-.9, .32, .41>
}

object {
    Lens
    rotate 18*y
    translate <-.8, .32, .39>
}

object {
    MirrorPlank
    rotate 32*y
    translate <-.92, .32, .25>
}

object {
    MirrorPlank
    rotate -15*y
    translate <-.79, .32, .24>
}

object {
    DemiMirror
    rotate 16*y
    translate <-.86, .32, .11>
}

object {
    Laser
    rotate 90*y
    translate <-.81, .32, -.20>
}

object {
    GenericBase
    rotate 48*y
    translate <-.91, .02, .4>
}

object {
    GenericBase
    rotate 56*y
    translate <-.8, .02, .31>
}

object {
    GenericBase
    rotate 18*y
    translate <-.69, .02, .38>
}

// Some nuts, to add reality
#declare XMax = -.2
#declare YMax = .02
#declare ZMax = .3
#declare XMin = -.6
#declare YMin = .02
#declare ZMin = -.1
#declare MaxRadius = 1 // Max scale (same amount in all axis)
#declare MinRadius = 1 // Min scale (same amount in all axis)
#declare NumberOfParticles = 20
#declare CurrentSeed = 800 // Number to pass to seed(), optional
#declare Particle = object { Nut } // Optional
#declare GlobalTransf = transform { scale 1 }
#include "randdust.inc"


// --- Board and Pins
object { CorkBoard }

union {
    object { CorkPin rotate <2, 1, 0> translate <.02, .015, 0> }
    object { CorkPin rotate <0, 4, 0> translate <-.03, .04, 0> }
    object { CorkPin rotate <-2, 0, 1> translate <.01, -.01, 0> }
    object { CorkPin rotate <1, 0, 0> translate <0, .02, 0> }
    object { CorkPin rotate <0, 1, -3> translate <-.025, -.03, 0> }
    translate <-.45, .15, .49>
}

object {
    ShuttlePoster
    translate <-.05, .42, .485>
}


// --- The room
box { // Walls
    <-1, -.8, -2.5>, <2, 1.5, .5>
    texture {
        pigment { White }
        normal { bumps .1 scale .01 }
    }
    no_shadow
    hollow
}

box { // Floor
    <-1, -.8, -2.5>, <2, -.75, .5>
    texture {
        checker texture { T_Stone15 }, texture { T_Stone16 }
        scale .25
    }
}


// --- Lights for testing only
/*
light_source { <0, 1.5, -1> White*.6*.1 }
light_source {
    <1, .5, 0-.35> White
    spotlight
    point_at <.15, .025, -.35>
    radius 60
    falloff 45
    tightness 50 // From 1 to 100
}
*/


// --- Camera? ;)
camera {
    location <.25, .2, -.65>
    right <16/9, 0, 0>
    up <0, 1, 0>
    look_at <0, 0, 0>
    angle 80
/*  // Focal blur seems to be incompatible with lensflare
    focal_point <.15, .09, -.35>
    aperture .001 // Must be tested, I don't have time :(
    blur_samples 7 // 37
    //confidence 0.975           // default is 0.9
    //variance 1/255             // default is 1/128 (0.0078125)
*/
}


// --- Lensflare (thanks to Nathan Kopp)
#declare cam_loc = <.25, .2, -.65>
#declare lookat = <0, 0, 0>
#declare sky_vect = <0, 1, 0>
#declare flare_type = "35mm"

#declare flare_scale_factor = .8
#declare flare_amount = .45
#declare show_flare_source = yes
#declare light_loc = <.1, .12, .35>
#include "lnsflare.inc"

#declare flare_scale_factor = .85
#declare flare_amount = .5
#declare show_flare_source = yes
#declare light_loc = <.1, .12, -.35>
#include "lnsflare.inc"

#declare flare_scale_factor = .85
#declare flare_amount = .5
#declare show_flare_source = yes
#declare light_loc = <-.2, .12, -.35>
#include "lnsflare.inc"


background { Gray80 }


// --- Logo
height_field {
    gif "by-gsr.gif"
    water_level .001
    texture {
        pigment {
            bozo // gradient z+x
            color_map {
                [ 0 color rgb <.25, 1, 1> ]
                [ 1 color rgb <.1, .1, 1> ]
            }
            sine_wave
            scale .25
        }
        finish {
            ambient .2
            diffuse .4
        }
    }
    texture {
        pigment {
            crackle
            color_map {
                [ .05 Black ]
                [ .05 Clear ]
            }
            scale .2
            translate <.5, 0, .5> // To fix big black spots
        }
        finish {
            ambient .1
            diffuse .5
        }
    }
    translate <-.5, 0, -.5>
    scale <.12, .00001, .05>
    rotate -90*x rotate 70*z
    translate <.45, .3, .489>
}


// (C) Guillermo Sanz Romero
// Todos los derechos reservados.
// Si deseas utilizar la totalidad o parte de este fichero puedes hacerlo
//  mientras no sea con fines lucrativos.
// En caso de usarlo para publicidad, recopilaciones de software, inclusin
//  en revistas o alguna otra actividad que suponga una transaccin
//  remunerada (con cualquier tipo de bien, por lo que los trueques y los
//  premios de los concursos tambin quedan incluidos), debes ponerte en
//  contacto utilizando las direcciones de la cabezera para poder acordar las
//  condiciones que te permitan hacer dicho uso de los datos contenidos en
//  este fichero o los generados a partir de l, tanto descripciones de
//  imagenes como las imagenes en si, en cualquier formato y/o medio de
//  almacenamiento.
//--
// All rights reserved.
// If you want to use this file in is enterity or only parts of it you can do
//  it while it is a non-profitable purpose.
// In case of using it for advertisment, software recopilations, bunddling it
//  with magazines or another profitable transaction (any sort of profit, so
//  exchange and prizes won in contests are included), you must get in touch
//  with me through the addresses given above to reach an agreement about the
//  conditions to use the data here contained (this file) or build from it,
//  both new image descriptions and images, whatever the format and/or the
//  storage way.

// No dudes en escribirme si tienes alguna pregunta, tanto sobre la clusula
//  arriba expuesta como sobre el fichero de datos que describe las imgenes
//  y las imgenes en si.
// P.D.: los precios son razonables y el dinero esta destinado bsicamente
//  a mejorar mi ordenador y poder seguir creando ms imagenes.
//--
// Do not doubt to write me if you has any question, about the clausule 
//  written above or the descriptions and the images.
// P.S.: prices are reasonable and money is basically to improve my computer
//  so I can keep making more pictures.

// NOTA IMPORTANTE
//  Este es un extracto de la licencia completa (LICENSE.GSR), lee dicho
//  fichero para conocer todas las condiciones y clusulas.
//--
// IMPORTANT NOTE
//  This is an extract of the complete license (LICENSE.GSR), read that file
//  to know all the conditions and clausules.
