#include "colors.inc"
#include "textures.inc"
#include "golds.inc"

#declare SUN_TEX =
texture {
pigment { color rgbt <1, 1, 1, 1> }
    halo {
      emitting
      spherical_mapping
      linear
      color_map {
           [ 0 color rgbt <0.49, 0.49, 0, 1> ]
           [ 0.5 color rgbt <0.89, 0.89, 0.15, .8> ]
           [ 1 color rgbt <1, 1, 1, -3.5> ]
      }
      samples 10
     }
    }
#declare TITAN_TEX =
texture {
    pigment { color rgbt <1, 1, 1, 1> }
    halo {
      emitting
      spherical_mapping
      linear
      color_map {
        [ 0 color rgbt <1, 1, 1, .33> ]
        [ 0.02 color rgbt <.5, .5, 1, .25> ]
        [ 0.04 color rgbt <0, 0, .8, .15> ]
        [ 0.06 color rgbt <0, 0, 0, 0> ]
        [ 0.08 color rgbt <1, 1, 0, -1> ]
        [ 0.1 color rgbt <1, .33, 0, -1> ]
        [ 0.12 color rgbt <1, 0, 0, -1> ]
        [ 0.14 color rgbt <0, 0, 0, -1> ]
        [ 0.16 color rgbt <0, 0, 0, -10> ]
        [ 0.2 color rgbt <0, 0, 0, -50> ]
        [ 1 color rgbt <0, 0, 0, -100> ]
      }
      samples 50
    }
}

#declare SATURN_TEX =
     texture {pigment {gradient y
      turbulence .05
      color_map {
      [0.00 color rgb<0.980,0.721,0.392>]
      [0.02 color rgb<0.988,0.713,0.400>]
      [0.04 color rgb<1.000,0.729,0.392>]
      [0.06 color rgb<0.996,0.737,0.384>]
      [0.08 color rgb<0.996,0.729,0.384>]
      [0.10 color rgb<0.996,0.737,0.384>]
      [0.12 color rgb<0.996,0.784,0.384>]
      [0.14 color rgb<0.996,0.800,0.392>]
      [0.16 color rgb<0.988,0.784,0.384>]
      [0.18 color rgb<1.000,0.776,0.392>]
      [0.20 color rgb<0.996,0.792,0.384>]
      [0.22 color rgb<0.996,0.800,0.384>]
      [0.24 color rgb<0.996,0.862,0.384>]
      [0.26 color rgb<1.000,0.878,0.392>]
      [0.28 color rgb<0.996,0.886,0.392>]
      [0.30 color rgb<0.996,0.886,0.392>]
      [0.32 color rgb<0.996,0.870,0.384>]
      [0.34 color rgb<0.988,0.792,0.384>]
      [0.36 color rgb<1.000,0.752,0.384>]
      [0.38 color rgb<0.996,0.784,0.384>]
      [0.40 color rgb<0.996,0.823,0.384>]
      [0.42 color rgb<0.996,0.862,0.392>]
      [0.44 color rgb<0.996,0.854,0.392>]
      [0.46 color rgb<0.996,0.839,0.384>]
      [0.48 color rgb<0.996,0.862,0.376>]
      [0.50 color rgb<0.996,0.886,0.384>]
      [0.52 color rgb<0.996,0.847,0.384>]
      [0.54 color rgb<0.996,0.854,0.384>]
      [0.56 color rgb<0.996,0.854,0.384>]
      [0.58 color rgb<0.996,0.854,0.384>]
      [0.60 color rgb<0.996,0.823,0.384>]
      [0.62 color rgb<1.000,0.768,0.384>]
      [0.64 color rgb<0.996,0.776,0.384>]
      [0.66 color rgb<0.996,0.878,0.400>]
      [0.68 color rgb<0.996,0.886,0.400>]
      [0.70 color rgb<0.996,0.886,0.392>]
      [0.72 color rgb<0.996,0.886,0.384>]
      [0.74 color rgb<1.000,0.823,0.384>]
      [0.76 color rgb<0.996,0.800,0.384>]
      [0.78 color rgb<0.996,0.784,0.384>]
      [0.80 color rgb<0.996,0.768,0.384>]
      [0.82 color rgb<0.996,0.776,0.384>]
      [0.84 color rgb<1.000,0.768,0.392>]
      [0.86 color rgb<0.996,0.745,0.384>]
      [0.88 color rgb<0.996,0.737,0.392>]
      [0.90 color rgb<0.996,0.729,0.384>]
      [0.92 color rgb<1.000,0.721,0.384>]
      [0.94 color rgb<0.964,0.729,0.400>]
      [0.96 color rgb<0.980,0.729,0.400>]
      [0.98 color rgb<0.996,0.737,0.392>]}}
        finish { diffuse 1
                 ambient .12
                 phong .4
                 phong_size 5}}

#declare SAT_RING_G =
 texture{pigment
          {color rgbt<0.8,0.737,0.4,0.5>}
            finish{diffuse 1
                   ambient .1
                   phong 1
                   phong_size 15
                   specular 1
                   roughness 1}
}

#declare SAT_RING_F =
    texture{pigment
           {color rgb<0.749,0.69,0.373>}
             finish{diffuse 1
                    ambient .17
                    phong 1
                    phong_size 15
                    specular 1
                    roughness 1}}

#declare SAT_RING_A =
    texture{pigment {gradient z
                 color_map {[0.00 color rgb<0.58,0.533,0.29>]
                            [0.1 color rgb<0.239,0.443,0.239>]
                            [0.2 color rgb<0.450,0.411,0.223>]
                            [0.8 color rgb<0.4,0.368,0.2>]
                            [0.9 color rgb<0.478,0.443,0.239>]
                            [1.0 color rgb<0.65,0.6,0.325>]}}
               finish{diffuse 1
                      ambient .17
                      phong 1
                      phong_size 15
                      specular 1
                      roughness 1}}

#declare SATURN_RING_BC =
    texture{
       pigment {gradient z
           color_map {[0.00 color rgb<0.85,0.784,0.423>]
                      [0.1 color rgb<0.952,0.874,0.474>]
                      [0.2 color rgb<0.8,0.737,0.4>]
                      [0.75 color rgb<0.4,0.368,0.2>]
                      [0.9 color rgb<0.78,0.717,0.388>]
                      [1.0 color rgb<0.4,0.368,0.2>]}}
               finish{diffuse 1
                      ambient .17
                      phong 1
                      phong_size 15
                      specular 1
                      roughness 1}}

#declare SATURN_RING_D =
    texture{
      pigment{rgbt<.192,.603,.996,0.5>}
        finish{diffuse 1
               ambient .1
               phong 1
               specular 1
               roughness 1}}

#declare SATURN_MOONS =
    texture {
       pigment {image_map {tga "rhea.tga"}
       scale <1,3,1>
       rotate <0,0,40>}
           finish { diffuse 1
                    ambient .15
                    phong .4
                    phong_size 5}}

#declare GOLD = texture {
 finish {
    brilliance 1
    diffuse D_GoldE
    ambient A_GoldE
    reflection R_GoldE
    metallic M
    specular 0.80
    roughness 1/120
}
    pigment { rgb <1.00, 0.875, 0.575> }
}


#declare SILVER = texture {
    finish {
        ambient 0.10
        diffuse 0.90
        phong 1.00
        phong_size 52.5
        reflection 0.250
    }
    pigment { rgb <0.678, 0.643, 0.604> }
}

#declare BLACK_MATTE = texture {
    finish {
        ambient 0.10
        diffuse 0.90
        phong 0.12
        phong_size 3.5
    }
    pigment { rgb <0.098, 0.098, 0.098> }
}

#declare MILKY_WAY_TEX =
  texture{
   pigment { color rgbt <1, 1, 1, 1> }
    halo {
      emitting
      planar_mapping
      linear
      turbulence .9
      color_map {
        [ 0 color rgbt <0, 0, 0, .85> ]
        [ 0.5 color rgbt <0.09, 0.445, .495,.6 > ]
        [ 1 color rgbt <0.18, 0.851, 0.951, .85> ]
      }
      frequency 1.5
      samples 50
      scale .5
    }
}
#declare HUYGENS_HALO_TEX =
  texture {
    pigment { color rgbt <1, 1, 1, 1> }
    halo {
      emitting
      spherical_mapping
      linear
      max_value 1
      turbulence 1
      color_map {
        [ 0 color rgbt <1, 0, 0, 1> ]
        [ 1 color rgbt <1, 1, 0, -0.8> ]
      }
      samples 30
      rotate <0,0,-85>
      rotate <75,0,0>
      rotate <0,-30,0>
      }
}

