// File: moor.pov
// Vers: 3
// Desc: Geometric 2
// Date: 27 June 97
// Auth: SjG libelle@webbwerks.com

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "woods.inc"


#declare StdCam = camera
	{
	location  <0.0, 3.0, -6.0>
	direction z 
	up        y
	right     4/3*x
	look_at   <0.20, 3.0,  0.0>
	}

#declare mainLight = light_source
{
  0*x
  color red 1.0  green 1.0  blue 1.0
  translate <-50,50,-50>
}

#declare secondaryLight = light_source
{
  0*x
  color red 0.3  green 0.3  blue 0.3
  translate <50,20,-50>
  shadowless
}

#declare tertiaryLight = light_source
{
  0*x
  color red 0.8  green 0.8  blue 0.8
  translate <-40,40,-50>
  shadowless
}


// Needs to lie in the XZ plane
#declare moorBaseTriangle = union {
	cylinder{<0.5,0,0>,<0.5,0,2>,0.02}
	cylinder{<0.8,0,0>,<0.8,0,2>,0.04}
	cylinder{<0.8,0,0>,<0.8,0,2>,0.04}
}
#declare moorRosetteOrder = 4
#declare moorRosette = union{
	#include "moor.inc"
	texture{T_Wood11}
	}



// Needs to lie in the XZ plane
#declare moorBaseTriangle = union {

	cylinder{<0.5,0,0>,<0.5,0,2>,0.02
		texture{T_Wood11}}
	cylinder{<0.8,0,0>,<0.8,0,2>,0.04
		texture{T_Wood11}}

	intersection {
		torus{1,0.1}
		plane{-x,0}
		rotate <90,0,0> translate <0,0,0.6>
		texture{T_Wood19}
		}
	intersection {
		torus{1.2,0.1}
		plane{-x,0}
		rotate <90,0,0> translate <0,0,0.45>
		texture{T_Wood1}
		}
	intersection {
		torus{1.5,0.1}
		plane{-x,0}
		rotate <90,0,0> translate <0,0,0.3>
		texture{T_Wood2}
		}
}

#declare moorRosetteOrder = 3
#declare moorRosette2 = union{
	#include "moor.inc"
	}


// straight outta the docs.	
#declare theSky = sky_sphere
	{
	pigment
		{
		gradient y
		color_map
			{
			[ 0.5  color CornflowerBlue ]
			[ 1.0  color MidnightBlue ]
			}
		scale 2
		translate -1
		}
	}

	
// Actual scene gets put together here...
camera{StdCam}
object{mainLight}
object{secondaryLight}
object{tertiaryLight}
sky_sphere{theSky}
//object{groundPlane}

object {moorRosette rotate <-90,0,0> translate <2,3,12>}
object {moorRosette2 rotate <-60,0,0> translate <2,3,0>}

