
'------------------------------------------------------------------------------
' generates a sphere consisting of smaller spheres. ( e.g. atomic nucleus made
' up of protons and neutrons ). radius of each nucleon is 1 ( defined as
' AtomRadius ) while size of whole atom is determined by the condition:
'     IF (x1 ^ 2 + y1 ^ 2 + z1 ^ 2) ^ .5 < 6 THEN
' where in this case 6 is the radius.
'------------------------------------------------------------------------------
' code piece comes from the book "ANIMATION HOW-TO CD" by Jeff Bowermaster
'------------------------------------------------------------------------------


cel = 8
n = 0

OPEN "atom.inc" FOR OUTPUT AS #1

FOR z = -cel TO cel
        z1 = z * 1.632993 + 0       'sqrt(8/3)z
        alt1 = 1
        IF z MOD 2 = 0 THEN alt1 = 0

        FOR y = -cel TO cel
                y1 = y * 1.732051 - 1.154701 * alt1
                alt2 = 1
                IF y MOD 2 = 0 THEN alt2 = 0
                FOR x = -cel TO cel
                        x1 = x * 2 + 1 * alt2
                        IF (x1 ^ 2 + y1 ^ 2 + z1 ^ 2) ^ .5 < 6 THEN
                                PRINT #1, "sphere {"
                                PRINT #1, USING "       <###.#####,###.#####,###.#####>, AtomRadius"; x1; y1; z1
                                PRINT #1, "       texture { AtomicRed }"
                                PRINT #1, "}"
                                PRINT #1, ""
                                n = n + 1
                                PRINT n
                        END IF
                NEXT x
        NEXT y
NEXT z

CLOSE #1

'------------------------------------------------------------------------------

