//-----------------------------------------------------------------------------
//  Include file for MPHY184.POV
//  Image: "Realms of Physics"
//  June 1997
//-----------------------------------------------------------------------------


#declare Eps = 0.0001


#declare ResistorTex =
texture {
    pigment { PaleGreen * 0.8 + Green * 0.2 }
    finish {
        ambient .2
        diffuse .6
        specular .1
        roughness .02
    }
}


#declare ResistorTex2 =
texture {
	pigment { Gray60 }
    finish {
        ambient .2
        diffuse .6
        specular .1
        roughness .02
    }
}


#declare R1 = 0.17                  // semi-length of resistor tube
#declare R2 = 0.055                 // tube diameter
#declare R3 = 0.32                  // length of horizontal connection
#declare R4 = 0.16                  // height of resistor above board base
#declare R5 = 0.055                 // paint strip separation


#declare ResistorBase =
union {
    cylinder {
        <-R1,R4,0>, <R1,R4,0>, R2
        texture { ResistorTex }
    }
    sphere {
        <-R1,R4,0>, R2 * 1.2
        texture { ResistorTex }
    }
    sphere {
        <R1,R4,0>, R2 * 1.2
        texture { ResistorTex }
    }
    cylinder {
        <-R3,R4,0>, <R3,R4,0>, 0.015
        texture { Soft_Silver }
    }
    sphere {
        <-R3,R4,0>, 0.015
        texture { Soft_Silver }
    }
    sphere {
        <R3,R4,0>, 0.015
        texture { Soft_Silver }
    }
    cylinder {
        <-R3,R4,0>, <-R3,-Eps,0>, 0.015
        texture { Soft_Silver }
    }
    cylinder {
        <R3,R4,0>, <R3,-Eps,0>, 0.015
        texture { Soft_Silver }
    }
}


#declare ResistorBase2 =
union {
    cylinder {
        <-R1,R4,0>, <R1,R4,0>, R2
		texture { ResistorTex2 }
    }
    sphere {
        <-R1,R4,0>, R2 * 1.2
		texture { ResistorTex2 }
    }
    sphere {
        <R1,R4,0>, R2 * 1.2
		texture { ResistorTex2 }
    }
    cylinder {
        <-R3,R4,0>, <R3,R4,0>, 0.015
        texture { Soft_Silver }
    }
    sphere {
        <-R3,R4,0>, 0.015
        texture { Soft_Silver }
    }
    sphere {
        <R3,R4,0>, 0.015
        texture { Soft_Silver }
    }
    cylinder {
        <-R3,R4,0>, <-R3,-Eps,0>, 0.015
        texture { Soft_Silver }
    }
    cylinder {
        <R3,R4,0>, <R3,-Eps,0>, 0.015
        texture { Soft_Silver }
    }
}


#declare R1Strip =
cylinder {
    <0.03,R4,0>, <0.05,R4,0>, R2+Eps
    open
    translate <-2*R5,0,0>
}

#declare R2Strip =
cylinder {
    <0.03,R4,0>, <0.05,R4,0>, R2+Eps
    open
    translate <-R5,0,0>
}

#declare R3Strip =
cylinder {
    <0.03,R4,0>, <0.05,R4,0>, R2+Eps
    open
}

#declare R4Strip =
cylinder {
    <0.04,R4,0>, <0.06,R4,0>, R2+Eps
    open
    translate <R5,0,0>
}


#declare Resistor1 =
union {
    object {  ResistorBase  }
    object {
        R1Strip
        pigment { White }
    }
    object {
        R2Strip
        pigment { Yellow }
    }
    object {
        R3Strip
        pigment { Red }
    }
    object {
        R4Strip
        pigment { Gold }
    }
}


#declare Resistor2 =
union {
	object {  ResistorBase2  }
    object {
        R1Strip
		pigment { Blue }
    }
    object {
        R2Strip
        pigment { Yellow }
    }
    object {
        R3Strip
		pigment { White }
    }
    object {
        R4Strip
		pigment { Silver }
    }
}


//------------------------------ resistors -----------------------------------

object {
    Resistor1
    translate <2.3,0,-8.8>
}

object {
    Resistor1
    rotate <0,90,0>
    translate <2.6,0,-5.5>
}

object {
    Resistor1
    rotate <0,270,0>
    translate <4.8,0,-2.4>
}

object {
    Resistor2
    translate <4,0,-4>
}

object {
    Resistor2
    translate <4.5,0,-4.2>
}

object {
    Resistor1
    translate <6,0,-5>
}

object {
    Resistor1
    translate <1.8,0,-2>
}

object {
    Resistor1
    translate <2.8,0,-3>
}

object {
    Resistor2
    translate <4.8,0,-8>
}

object {
    Resistor2
    rotate <0,270,0>
    translate <4.5,0,-3>
}

object {
    Resistor2
    rotate <0,90,0>
    translate <0.6,0,-7.8>
}

object {
    Resistor1
    rotate <0,90,0>
    translate <0.8,0,-7.7>
}

object {
    Resistor1
    rotate <0,90,0>
    translate <1,0,-7.6>
}

object {
    Resistor2
    translate <5.5,0,-6.2>
}

object {
    Resistor1
    rotate <0,90,0>
    translate <3.5,0,-8.5>
}

object {
    Resistor1
    rotate <0,180,0>
    translate <3.5,0,-6>
}



