
#include "metals.inc"
/*
background{ color rgb <.9,.95,1>}

light_source {<-1000,800,-1000>*4
color rgb <1,1,1>}

camera{
// location<200,10000,200>
location<-220,25,-290>*10
// location<500,300,-4000>*3
// location<-5000,300,500>*3
angle 24
// look_at <0,200,0>}
// look_at <500,200,0>}
// look_at <0,200,500>}
look_at <0,-40,0>}
*/

#declare C1TEX =
texture{
   finish{
      ambient <.8,.9,1>*.4
      diffuse .9
      phong 0
   }
   normal{wrinkles .55 scale 7}
   pigment{color rgb <.95,.85,.75>}
}

#declare ASFTEX01=
texture{
    finish{
      ambient .3
      diffuse 0.8
      reflection 0.15
      phong 0.1
      phong_size 10
      crand 0.15
      }
   normal{ bumps .1 scale .5}
   pigment {
      hexagon pigment { color rgb <.9,.85,.8>},
              pigment { color rgb <.9,.85,.8>*.8},
              pigment { color rgb <.9,.85,.8>*.9} scale 25}
}

#declare ASFTEX02=
texture{
    finish{
      ambient .3
      diffuse 0.8
      phong 0.1
      phong_size 10
      crand 0.1
      }
   normal{ bumps .1 scale .5}
   pigment{ color rgb <.9,.85,.8>}
}

#declare C2_TEX =
texture{
   finish{
   diffuse .4
      ambient <1,.85,.7>*.8
      phong 0.2
      phong_size 20
   }
   pigment{color rgb <1,.7,.6>}
}
#declare C3_TEX =
texture{
   finish{
   diffuse .4
      ambient <1,.85,.7>*.8
      phong 0.2
      phong_size 20
   }
   pigment{color rgb <1,.7,.6>}
}

#declare C21_TEX =
texture{
   finish{
   diffuse .9
      ambient <.8,.9,1>*.55
      phong 0.2
      phong_size 20
   }
   normal {bumps .1 scale .2}
   pigment{color rgb <1,.8,.7>}
}


#declare C3TEX =
texture{
   finish{
      ambient <.8,.7,.6>*.6
      diffuse .9
      phong 0.3
      phong_size 200
   }
   pigment{color rgb <.8,.7,.6>}
}

#declare D1TEX =
texture{
   finish{
      ambient <.9,.9,.9>*.3
      reflection 0.2
      metallic
      specular 0.8
   }
   pigment{
      color rgb <.9,.9,.9>}
}
#declare WIN_TEX=
texture{
   finish {
      ambient 0.30
      brilliance 3
      diffuse 0.4
      metallic
      specular 0.70
      roughness 1/60
      reflection 0.25
   }
   normal{bumps .05 scale <50,80,50>}
   pigment{
      color rgb <0.39, 0.41, 0.43>}
}
#declare talo=
union{
#declare CAFE01=
union{
#declare SS01=.4
#declare SSUB01=
union{
   superellipsoid{<SS01,SS01> translate <1,1,1> scale <20,25,20>}
   superellipsoid{<SS01,SS01> translate <1,1,1> scale <20,25,20> translate <40,0,0>}
   superellipsoid{<SS01,SS01> translate <1,1,1> scale <20,25,20> translate <80,0,0>}
   superellipsoid{<SS01,SS01> translate <1,1,1> scale <20,25,20> translate <0,0,40>}
   superellipsoid{<SS01,SS01> translate <1,1,1> scale <20,25,20> translate <0,0,80>}
   superellipsoid{<SS01,SS01> translate <1,1,1> scale <30,15,30> translate <0,50,0>}
   superellipsoid{<SS01,SS01> translate <1,1,1> scale <30,15,30> translate <60,50,0>}
   superellipsoid{<SS01,SS01> translate <1,1,1> scale <30,15,30> translate <0,50,60>}
}
#declare NSS01=4
#declare SSUB02=
union{
   #while(NSS01>=0)
      object {SSUB01 translate <0,80*NSS01,0>}
      #declare NSS01=NSS01-1
   #end
texture {C1TEX}}

object {SSUB02 translate <0,40,0>}
object {SSUB02  rotate y*270 translate <480,40,0>}
object {SSUB02  rotate y*90 translate <0,40,480>}
box {<0,0,0><120,40,120>texture {C1TEX}}
box {<0,0,0><120,40,120> translate <360,0,0> texture {C1TEX}}
box {<0,0,0><120,40,120> translate <0,0,360> texture {C1TEX}}
box {<-10,0,-20><245,20,50> translate <120,0,0> texture {C1TEX}}
box {<-20,0,-10><50,20,245> translate <0,0,120> texture {C1TEX}}

#declare SSUB03=
union{
   superellipsoid{<SS01,SS01> translate <1,1,1> scale <20,25,20> translate <0,440,0>}
   superellipsoid{<SS01,SS01> translate <1,1,1> scale <20,25,20> translate <40,440,0>}
   superellipsoid{<SS01,SS01> translate <1,1,1> scale <40,25,20> translate <80,440,0>}
   superellipsoid{<SS01,SS01> translate <1,1,1> scale <20,25,20> translate <0,440,40>}
   superellipsoid{<SS01,SS01> translate <1,1,1> scale <20,25,40> translate <0,440,80>}
   superellipsoid{<SS01,SS01> translate <1,1,1> scale <30,15,30> translate <0,490,0>}
   superellipsoid{<SS01,SS01> translate <1,1,1> scale <30,15,30> translate <60,490,0>}
   superellipsoid{<SS01,SS01> translate <1,1,1> scale <30,15,30> translate <0,490,60>}
texture {C1TEX}}
object {SSUB03}
object {SSUB03  rotate y*270 translate <480,0,0>}
object {SSUB03  rotate y*90 translate <0,0,480>}

#declare SS02=.2
#declare SSUB04=
union{
   superellipsoid{<SS02,SS02> translate <1,1,1> scale <30,40,20> translate <210,440,0>}
   superellipsoid{<SS02,SS02> translate <1,1,1> scale <25,40,20> translate <160,440,0>}
   superellipsoid{<SS02,SS02> translate <1,1,1> scale <25,40,20> translate <270,440,0>}
   superellipsoid{<SS02,SS02> translate <1,1,1> scale <45,15,20> translate <120,490,0>}
   superellipsoid{<SS02,SS02> translate <1,1,1> scale <45,15,20> translate <270,490,0>}
texture {C1TEX}}
object {SSUB04 translate z*10}
object {SSUB04 rotate y*90 translate <10,0,480>}

#declare SSUB05=
union{
   superellipsoid{<SS01,SS01> translate <1,1,1> scale <20,25,20>}
   superellipsoid{<SS01,SS01> translate <1,1,1> scale <20,25,20> translate <40,0,0>}
   superellipsoid{<SS01,SS01> translate <1,1,1> scale <40,15,20> translate <0,50,0>}
}

#declare NSS01=4
#declare SSUB06=
union{
   #while(NSS01>=0)
      object {SSUB05 translate <0,80*NSS01,0>}
      #declare NSS01=NSS01-1
   #end
}

#declare NSS02=5
#declare NSD01=480
#declare SSUB061=
union{
   #while(NSS02>=1)
     object {SSUB06 translate <NSD01,40,20>}
     #declare NSD01=NSD01+80+200
     #declare NSS02=NSS02-1
   #end
}
object{SSUB061 texture {C1TEX}}

#declare NSS02=6
#declare NSD01=480
#declare SSUB062=
union{
   #while(NSS02>=1)
     object {SSUB06 rotate y*90 translate <20,40,NSD01+80>}
     #declare NSD01=NSD01+80+200
     #declare NSS02=NSS02-1
   #end
}
object{SSUB062 texture {C1TEX}}

#declare SSUB07=
union{
   superellipsoid{<SS01,SS01> translate <1,1,1> scale <20,25,20> translate <480,440,0>}
   superellipsoid{<SS01,SS01> translate <1,1,1> scale <35,25,20> translate <520,440,0>}
   superellipsoid{<SS01,SS01> translate <1,1,1> scale <35,15,30> translate <480,490,0>}
texture {C1TEX}}
object {SSUB07 translate z*10}

#declare SSUB07A=
union{
   superellipsoid{<SS01,SS01> translate <-1,1,1> scale <20,25,20> translate <-480,440,0>}
   superellipsoid{<SS01,SS01> translate <-1,1,1> scale <35,25,20> translate <-520,440,0>}
   superellipsoid{<SS01,SS01> translate <-1,1,1> scale <35,15,30> translate <-480,490,0>}
   rotate y*90
texture {C1TEX}}
object {SSUB07A translate x*10}

#declare SSUB07B=
union{
   superellipsoid{<SS01,SS01> translate <1,1,1> scale <20,25,20> translate <0,440,0>}
   superellipsoid{<SS01,SS01> translate <1,1,1> scale <35,25,20> translate <40,440,0>}
   superellipsoid{<SS01,SS01> translate <1,1,1> scale <35,15,30> translate <0,490,0>}
   rotate y*90
texture {C1TEX}}
object {SSUB07B translate <10,0,1960>}

#declare SSUB071=
union{
   superellipsoid{<SS01,SS01> translate <1,1,1> scale <35,25,20> translate <450,440,0>}
   superellipsoid{<SS01,SS01> translate <1,1,1> scale <35,25,20> translate <520,440,0>}
   superellipsoid{<SS01,SS01> translate <1,1,1> scale <30,15,30> translate <490,490,0>}
texture {C1TEX}}


#declare SS02=.2
#declare SSUB08=
union{
   superellipsoid{<SS02,SS02> translate <1,1,1> scale <30,40,20> translate <70,440,0>}
   superellipsoid{<SS02,SS02> translate <1,1,1> scale <20,40,20> translate <130,440,0>}
   superellipsoid{<SS02,SS02> translate <1,1,1> scale <20,40,20> translate <30,440,0>}
   superellipsoid{<SS02,SS02> translate <1,1,1> scale <40,15,20> translate <-10,490,0>}
   superellipsoid{<SS02,SS02> translate <1,1,1> scale <40,15,20> translate <130,490,0>}
texture {C1TEX}}

#declare NSS02=4
#declare NSD01=280
union{
   #while(NSS02>=1)
     object {SSUB071 translate <NSD01,0,10>}
     #declare NSD01=NSD01+280
     #declare NSS02=NSS02-1
   #end
}

#declare NSS02=4
#declare NSD01=280
union{
   #while(NSS02>=1)
     object {SSUB071 rotate y*90 translate <10,0,NSD01+260*4>}
     #declare NSD01=NSD01+280
     #declare NSS02=NSS02-1
   #end
}

#declare WINDOW01=
union{
     box{<0,20,1><200,440,0> texture {WIN_TEX}}
     box {<0,20,10><10,440,-10> texture {C3TEX}}
     box {<190,20,10><200,440,-10> texture {C3TEX}}
     box {<0,20,10><200,30,-10> texture {C3TEX}}
     box {<0,430,10><200,440,-10> texture {C3TEX}}
     difference{
         superellipsoid{<.2,.5> translate <1,1,1> scale <100,200,180>}
         superellipsoid{<.2,.5> scale .9 translate <1,1,1> scale <100,200,180>}
         box{<-5,-10,-200><245,240,400> rotate x*15}
         translate <0,40,-150> texture {C2_TEX}
     }
}

#declare NSS02=4
#declare NSD01=480
union{
   #while(NSS02>=1)
     object {SSUB08 translate <NSD01+80,0,20>}
     object {WINDOW01 translate <NSD01+80,0,54>}

     #declare NSD01=NSD01+280
     #declare NSS02=NSS02-1
   #end
}

#declare NSS02=5
#declare NSD01=480
union{
   #while(NSS02>=1)
     box{<0,0,80><-80,40,0> translate <NSD01+80,0,20>texture {C1TEX}}
     box{<0,520,150><-80,520+500,40> translate <NSD01+80,0,20>texture {C21_TEX}}
     #declare NSD01=NSD01+280
     #declare NSS02=NSS02-1
   #end
}

#declare NSS02=5
#declare NSD01=480
union{
   #while(NSS02>=1)
     object {WINDOW01 rotate y*90 translate <54,0,NSD01+80+200>}
     #declare NSD01=NSD01+280
     #declare NSS02=NSS02-1
   #end
}

#declare NSS02=6
#declare NSD01=480
union{
   #while(NSS02>=1)
     box{<40,520,-80><150,520+500,0> translate <20,0,NSD01+80>texture {C21_TEX}}
     box{<0,0,-80><80,40,0> translate <20,0,NSD01+80>texture {C1TEX}}
     #declare NSD01=NSD01+280
     #declare NSS02=NSS02-1
   #end
}

box{<1680,0,1960><25,20,25>texture {C1TEX}}
box{<1680,0,1960><55,520,55>texture {C1TEX}}
box{<1680,520,1960><80,520+500,80>texture {C21_TEX}}
box{<40,590,40><460,590+500,460>texture {C21_TEX}}
box{<20,590,20><120,590+500,120>texture {C21_TEX}}
box{<20,590,20><120,590+500,120>texture {C21_TEX} translate x*(480-20-120)}
box{<120,590,120><20,590+500,20>texture {C21_TEX} translate z*(480-20-120)}

#declare NSS02=5
#declare NSD01=480
union{
   #while(NSS02>=1)
     object {SSUB08 rotate y*90 translate <20,0,NSD01+280>}
     #declare NSD01=NSD01+280
     #declare NSS02=NSS02-1
   #end
}

#declare DOOR01=
union{
   box {<0,20,0><10,440,-10>}
   box {<0,20,0><-10,440,-10> translate <240,0,0>}
   box {<-5,20,0><5,300,-10> translate <120,0,0>}
   box {<0,300,0><240,310,-10>}
   box {<0,430,0><240,440,-10>}
texture {C3TEX}}

#declare DOOR02=
union{
   object {DOOR01}
   box {<0,20,0><240,50,-5>texture {C3TEX}}
   cylinder {<0,0,0><0,80,0>,2 translate <100,110,-15>texture {D1TEX}}
   cylinder {<0,0,0><0,80,0>,2 translate <140,110,-15>texture {D1TEX}}
   box {<0,20,0><240,440,-2>texture {WIN_TEX}}
   difference{
      superellipsoid{<.2,.5> translate <1,1,1> scale <120,200,180>}
      superellipsoid{<.2,.5> scale .9 translate <1,1,1> scale <120,200,180>}
      box{<-5,-10,-200><245,240,400> rotate x*15}
   translate <0,40,-150> texture {C2_TEX}}
}

object {DOOR02 translate <120,0,40>}
object {DOOR02 rotate y*90 translate <40,0,360>}

#declare CAP01=
   prism {
      linear_sweep
      cubic_spline
      -20,20,9,
      <20,10>,<10,10>,<-20,15>,<-20,0>,<-7,-7>,<0,-20>,<15,-20>,<10,10>,<10,20>
   translate <-10,0,-10> scale .4 rotate x*-90
}
#declare CAPN01=8
#declare CAPN02=CAPN01
#declare CAPD01=480/CAPN01
#declare CAPD02=CAPD01
#declare CAP02=
union{
#while (CAPN01>1)
   object {CAP01 scale<1.5,2,1> rotate y*-90 translate <CAPD01,0,5>}
   #declare CAPD01=CAPD01+CAPD02
   #declare CAPN01=CAPN01-1
   #end
}
union{
   box{<5,0,5><475,-30,475>}
   difference{
      box{<-16,0,-16><496,30,496>}
      cylinder {<-20,30,0><500,30,0>15 scale <1,1,2> translate z*-16}
      cylinder {<0,30,-20><0,30,500>15 scale <2,1,1> translate x*-16}
      cylinder {<-20,30,0><500,30,0>15 scale <1,1,2> translate z*496}
      cylinder {<0,30,-20><0,30,500>15 scale <2,1,1> translate x*496}
   }
   box{<-5,-30,-5><485,-40,485>}
   object {CAP01 scale<1.5,2,1> translate x*5 rotate y*-45}
   object {CAP01 scale<1.5,2,1> translate x*5 rotate y*-135 translate x*480}
   object {CAP01 scale<1.5,2,1> translate x*5 rotate y*45 translate z*480}
   object {CAP02}
   object {CAP02 rotate y*90 translate z*480}
   translate y*560
texture {C1TEX}}


#declare CAPN01=25
#declare CAPN02=CAPN01
#declare CAPD01=(1960-480)/CAPN01
#declare CAPD02=CAPD01
#declare CAP03=
union{
   #while (CAPN01>1)
      object {CAP01 scale<1.5,2,1> translate <5,0,CAPD01>}
      #declare CAPD01=CAPD01+CAPD02
      #declare CAPN01=CAPN01-1
   #end
}

#declare CAPN01=20
#declare CAPN02=CAPN01
#declare CAPD01=(1680-480)/CAPN01
#declare CAPD02=CAPD01
#declare CAP04=
union{
   #while (CAPN01>1)
      object {CAP01 scale<1.5,2,1> rotate  y*-90 translate <CAPD01,0,5>}
      #declare CAPD01=CAPD01+CAPD02
      #declare CAPN01=CAPN01-1
   #end
}

union{
   object {CAP03 translate <10,560,480>}
   object {CAP01 scale<1.5,2,1> translate x*5 rotate y*45 translate <10,560,1960>}
   box{<5,0,470><475,-30,1960> translate <10,560,0>}
   box{<-5,-30,(1960-480)*-1><485,-40,5> translate <10,560,1960>}
   difference{
      box{<-16,0,460><496,30,1960+16>}
      cylinder {<0,30,455><0,30,1960+20>15 scale <2,1,1> translate x*-16}
   translate <10,560,0>}

   object {CAP04 translate <480,560,10>}
   box{<470,0,5><1680,-30,475> translate <0,560,10>}
   box{<(1680-480)*-1,-30,-5><5,-40,485> translate <1680,560,10>}
   box{<(1680-480)*-1,-30,-5><-5,-40,485> translate <1680,560,10>}
   difference{
      box{<460,0,-16><1680+16,30,496>}
      cylinder {<455,30,0><1680+20,30,>15 scale <1,1,2> translate z*-16}
   translate <0,560,10>}
texture {C1TEX}}
}

object{CAFE01 translate <150,0,300>}

box{<60,0,1960><200,1000,1960+500> translate <150,0,300>
   texture {C1TEX}}

box{<-5250,0,0><5250,-20,7000> texture{ASFTEX01}}
box{<-5250,0,0><5250,-20,7000>rotate y*180 translate <0,0,-1650>texture{ASFTEX01}}
box{<-5250,-20,0><5250,-40,-7000>
   texture{ASFTEX01} pigment{color rgb <.9,.85,.8>*.75}}
/*
#include "cl001.pov"
object {CL001 scale 2.7 translate <-200,0,500>
texture{CL_TEX} normal {bumps 0.03 scale 10}}

object {CL001 scale 2.7  rotate y*30  translate <-150,0,1150>
texture{CL_TEX} normal {bumps 0.03 scale 10}}

object {CL001 scale 2.7 rotate y*42 translate <-560,0,500>
texture{CL_TEX} normal {bumps 0.03 scale 10}}

object{TAB01 scale 2.7 translate <-300,0,500>
texture{CL_TEX} normal {bumps 0.03 scale 10}}

object {CL001 scale 2.7 rotate y*-110 translate <-200,0,800>
texture{CL_TEX} normal {bumps 0.03 scale 10}
finish{ambient<1,.8,.7>*.3} pigment{color rgb <1,.8,.7>}}

object {CL001 scale 2.7 rotate y*130 translate <-330,0,930>
texture{CL_TEX} normal {bumps 0.03 scale 10}
finish{ambient<1,.8,.7>*.3} pigment{color rgb <1,.8,.7>}}

object{TAB01 scale 2.7 translate <-580,0,600>
texture{CL_TEX} normal {bumps 0.03 scale 10}
finish{ambient<1,.8,.7>*.3} pigment{color rgb <1,.8,.7>}}

object {CL001 scale 2.7 rotate y*160 translate <-420,0,450>
texture{CL_TEX} normal {bumps 0.03 scale 10}
finish{ambient<.7,1,.8>*.3} pigment{color rgb <.7,1,.8>}}

object {CL001 scale 2.7 rotate y*-80 translate <-300,0,1300>
texture{CL_TEX} normal {bumps 0.03 scale 10}
finish{ambient<.7,1,.8>*.3} pigment{color rgb <.7,1,.8>}}

object{TAB01 scale 2.7 translate <-220,0,1200>
texture{CL_TEX} normal {bumps 0.03 scale 10}
finish{ambient<.7,1,.8>*.3} pigment{color rgb <.7,1,.8>}}


//
object {CL001 scale 2.7 rotate y*-105 translate <-1400,0,-1900>
texture{CL_TEX} normal {bumps 0.03 scale 10}}

object{TAB01 scale 2.7 translate <-1240,0,-1950>
texture{CL_TEX} normal {bumps 0.03 scale 10}
finish{ambient<1,.8,.7>*.3} pigment{color rgb <1,.8,.7>}}

object {CL001 scale 2.7 rotate y*80 translate <-1330,0,-2150>
texture{CL_TEX} normal {bumps 0.03 scale 10}
finish{ambient<.7,1,.8>*.3} pigment{color rgb <.7,1,.8>}}

object{TAB01 scale 2.7 translate <-1900,0,-2420>
texture{CL_TEX} normal {bumps 0.03 scale 10}
finish{ambient<.7,1,.8>*.3} pigment{color rgb <.7,1,.8>}}

object {CL001 scale 2.7 rotate y*-140 translate <-1770,0,-2120>
texture{CL_TEX} normal {bumps 0.03 scale 10}
finish{ambient<.7,1,.8>*.3} pigment{color rgb <1,.8,.7>}}

*/
#declare STONE01=
union{
   cylinder {<0,0,0><1,0,0>1 scale <149.2,20.5,7>}
   box{<0,-20.5,0><149.2,20.5,7>}
   translate <0,-20,-7>texture{ASFTEX02}}

#declare STONE02=
union{
   #declare NofST=70
   #declare DbST=0
   #while (NofST>0)
      object{STONE01 translate x*DbST}
   #declare NofST=NofST-1
   #declare DbST=DbST+150
   #end
}

object{STONE02 translate x*70/2*-150}
object{STONE02 rotate y*180 translate <70/2*150,0,-1650>}

#declare LINEs01=
union{
   #declare NofLI1= 8
   #declare DbLI1=0
   #while (NofLI1>0)
      box {<0,0,-15><250,.2,15> translate x*DbLI1 texture{ASFTEX02} pigment{color rgb <1,1,1>}}
   #declare NofLI1=NofLI1-1
   #declare DbLI1=DbLI1+550
   #end
}

#declare LINEs02=
union{
   #declare NofLI2= 10
   #declare DbLI2=0
   #while (NofLI2>=0)
   #declare DbLI2=DbLI2+1650/12
      box {<0,0,-30><-500,.2,30> translate z*DbLI2*-1 texture{ASFTEX02} pigment{color rgb <1,1,1>}}
   #declare NofLI2=NofLI2-1
   #end
}

object{LINEs01 translate <200,-20,-1650/2>}
object{LINEs01 rotate y*180 translate <-700,-20,-1650/2>}
object{LINEs02 translate <0,-20,0>}

#include "f_37_01.inc"
object {CAR01 translate y*13 scale 3.6 rotate y*-10 translate <-700,-20,-650>}
/*
#include "fem01.pov"
object{FEM01 translate y*13.75  rotate y*-76 scale 6 translate <-1400,0,-2000>}

#include "sschgl.inc"
object {SSCHGL scale 6.5 translate <-1915,(TAB_H01+T_T01)*2.7,-2465>}
*/
}

#declare SMOKE01=
  sphere { 0, 1
    pigment { color rgbt <1, 1, 1, 1> }
    halo {
      attenuating
      spherical_mapping
      linear
      turbulence 1.8
      color_map {
        [ 0 color rgbt <.8,.9,1,1> ]
        [ 1 color rgbt <.8*.5,.9*.5,1*.5, -1> ]
      }
      samples 10
      scale 0.5
    }
    hollow
    scale <1.5, 0.75, 1>
    scale 180
    translate <-50,-20,-690>
  }
