
// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//
/*
#version 3

#include "colors.inc"

global_settings
{
  assumed_gamma 1.0
}

// ----------------------------------------
camera
{
  location  <20, 0, -5.0>
  direction 1.5*z
  right     4/3*x
  look_at   <0.0, 0.0,  0.0>
}

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <30, 30, -30>
}
*/
#declare Main=
merge{

#declare H1=1.9
#declare H2=-1
#declare H3=0.2
#declare Z1=-3.8
#declare Z2=-4.2
#declare Z3=-2.4
#declare R=1.1

blob{
  threshold .318//=(1-.66^2)^2
  cylinder{z*1,z*5,3,1}
  cylinder{0,z*-5,3,-1 scale<0.2,1,1> rotate y*18 translate x*-2.9}
  cylinder{0,z*-5,3,-1 scale<0.2,1,1> rotate y*-18 translate x*2.9}

  cylinder{z*1,z*2,3,-1 translate y*4} 
  cylinder{z*-2,z*2,3,-1  rotate x*20 translate y*-3.5}
  
  cylinder{z*2,z*-16,4.5,1 scale<1,0.3,.25> rotate x*20 translate y*.8}
  cylinder{<-1,0,0>,<-2.1,0,-3.8>,R,1 rotate x*20 translate y*.4}//bord paume


  cylinder{<.7,H1,Z1+.1>,<.7,H2,Z2>,R,1}
  cylinder{<2.1,H1,Z1>,<2.1,H2,Z2+.1>,R,1}
  cylinder{<-.7,H1,Z1>,<-.7,H2,Z2>,R,1}
  cylinder{<-2.1,H1,Z1+.1>,<-2.1,H2,Z2+.1>,R,1}

 
/*  
  sphere{<2.1,H2,Z2+.1>,R,-1}
  sphere{<2.1,H2,Z2>,R,-1}
  sphere{<-.7,H2,Z2>,R,-1}
  sphere{<-2.1,H2,Z2+.1>,R,-1}

  cylinder{<2.1,H2,Z2+.1>,<2.1,H2,Z2+2>,R,1}
  cylinder{<.7,H2,Z2>,<.7,H2,Z2+2>,R,1}
  cylinder{<-.7,H2,Z2>,<-.7,H2,Z2+2>,R,1}  
  cylinder{<-2.1,H2,Z2+.1>,<-2.1,H2,Z2+2>,R,1}
  
  cylinder{<-2.1,H2,Z2+2>,<-2.1,H3,Z3>,1,1}
  
  sphere{<-2.1,H2,Z2+2>,1,-1}
*/
}

#declare R=2*R/3  

/*
  cylinder{<.7,H1,Z1+.1>,<.7,H2,Z2>,R}
  cylinder{<2.1,H1,Z1>,<2.1,H2,Z2+.1>,R}
  cylinder{<-.7,H1,Z1>,<-.7,H2,Z2>,R}
  cylinder{<-2.1,H1,Z1+.1>,<-2.1,H2,Z2+.1>,R}

  sphere{<.7,H2,Z2>,R}
  sphere{<2.1,H2,Z2+.1>,R}
  sphere{<-.7,H2,Z2>,R}
  sphere{<-2.1,H2,Z2+.1>,R}
*/
  cylinder{<2.1,H2,Z2+.1>,<2.1,H2,Z2+2>,R}
  cylinder{<.7,H2,Z2>,<.7,H2,Z2+2>,R}
  cylinder{<-.7,H2,Z2>,<-.7,H2,Z2+2>,R}  
  cylinder{<-2.1,H2,Z2+.1>,<-2.1,H2,Z2+2>,R}
  
  sphere{<2.1,H2,Z2+2>,R}
  sphere{<.7,H2,Z2+2>,R}
  sphere{<-.7,H2,Z2+2>,R}  
  sphere{<-2.1,H2,Z2+2>,R}
  
  cone{<-2.1,H2,Z2+2>,R,<-2.1,H3,Z3>,R-.1}
  cone{<-.7,H2,Z2+2>,R,<-.7,H3,Z3>,R-.1}
  cone{<.7,H2,Z2+2>,R,<.7,H3,Z3>,R-.1}
  cone{<2.1,H2,Z2+2>,R,<2.1,H3,Z3>,R-.1}
  
  sphere{<-2.1,H3,Z3>,R-.1}
  sphere{<-.7,H3,Z3>,R-.1}
  sphere{<.7,H3,Z3>,R-.1}
  sphere{<2.1,H3,Z3>,R-.1}
  
  //POUCE
  cylinder{<1,0,1>,<3,0,-2.5>,.8}
  sphere{<3,0,-2.5>,.8}
  cylinder{<3,0,-2.5>,<3,0,-4>,.8}
  sphere{<3,0,-4>,.8}
  
 translate z*-5
 }

//  object{Main rotate z*180} 
