
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc:
// Date:30/06/97
// Auth:Gry Flament, address E mail :gerard_flament@compuserve.com
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "NewcoTex.inc"
//#include "metals.inc"
#include "skies.inc"
#include "genie.inc"
#include "tonneau.inc"
#include "cuve.inc"


global_settings { assumed_gamma 1.0 }

#declare Pivot=20*sin(.75*2*pi)
//--------------TEXTURES-----------
#declare C_Briques=color rgb<.3,0,0>//couleur de la brique
#declare C_Mortier=Gray30



#declare T_Pierre=
texture{
         brick
           texture{pigment{color Gray30}},
           texture{T_Grnt11   normal{granite}}
          brick_size<1.7,.81,.8>   // size of brick
          mortar 0.1       // width of mortar
          warp{
                       turbulence <0.03,0.03,0>
                       octaves 2
                       lambda 1.2
          }
          scale 10
 }



#declare P_Briques=
pigment{wood
          pigment_map{
          [0.95 C_Briques]
          [0.95 C_Mortier]
          }
          scale 1/20
          rotate x*-90
}

#declare P_Chaine=pigment{Gray}
#declare P_Lettre=pigment{Red}

#declare T_Mur=
texture{
               pigment{
                   brick color Gray30, color rgb<.3,0,0>
                   brick_size<1,.5,.5>   // size of brick
                   mortar 0.09       // width of mortar

                   warp{
                       turbulence <0.03,0.03,0>
                       octaves 2
                       lambda 1.2
                   }
                   scale 10
                   quick_color rgb<.3,0,0>
        }
}
#declare T_MurBout=
texture{
               pigment{
                   brick color Gray30, color rgb<.3,0,0>
                   brick_size<10,5,6>   // size of brick
                   mortar 1.6       // width of mortar
                }
translate x*1
}


//----------CAMERA
camera
{
  location  <100 , 125.0 ,-480.0>
  angle 45
  look_at   <50.0 ,125.0 , 0.0>
}
//-----LUMIERES
// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color red 0.8  green 0.8  blue 0.8  // light's color
  translate <62, 200, -400>
  shadowless
}
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-2500, 5000, -1000>
  shadowless
}


//--------CIEL---------
sky_sphere{S_Cloud1}

// Porte du four
union{
  intersection{
    difference{
      box{<-17.9,5,0.2>,<17.9,36,2>}
      box{<-7,15,-0.3>,<7,25,2.2>}
    } 
    cylinder{<0,0,-.3>,<0,0,2.1>,24 translate<0,10.9,0>}
   }
   box{<-20,21,-3>,<-13,23,0>}
   box{<-20,10,-3>,<-13,12,0>}
   cylinder{<-19.5,20,-1.5>,<-19.5,23,-1.5>,.5}
   cylinder{<-19.5,7,-1.5>,<-19.5,10,-1.5>,.5}
   
  
    torus{1.5,.4 translate<-19.5,20.5,-1.5>}  
    torus{1.5,.4 translate<-19.5,9.5,-1.5>}

    torus{1.5,.4 translate<19.9,15,-1.5>}
    box{<12,16,-1.5>,<20,18,-.5>}
    box{<19.75,14,-1.5>,<20,16,-.5>}
    cylinder{<17,17,-2.5>,<17,17,0>,.5}
    texture{T_Fonte}
  translate<0,0,-54>
}


#declare LargPuits=80
#declare PosPuits=<111,0,13>
#include "sol.inc"
//-------FOUR-----------
box{<-54,53,-54>,<54,54,54> texture{T_Mur translate y*-2}}
difference{
           box{<-54,0,-54>,<54,53,54> texture{T_Mur}}
           intersection{//ouverture du four
                        cylinder{<0,0,-55>,<0,0,50>,24 translate<0,11,0>}
                        box{<-18,-.1,-55>,<18,36,50>}
                        texture{pigment{rgb C_Briques}}
                        texture{//suie
                                pigment{
                                      bozo
                                      color_map{
                                                [0 rgbt<0.1,0.1,0.1,0.1>]
                                                [1 rgbt<0.1,0.1,0.1,0.5>]
                                      }
                                 }
                         }
           }

}
box{<-18,0,-55>,<18,4.5,51>//assise du four
               texture{T_Mur rotate y*90 translate y*1}
               texture{//suie lgre
                                pigment{
                                      bozo
                                      color_map{
                                                [0 rgbt<0.1,0.1,0.1,0.3>]
                                                [1 rgbt<0.1,0.1,0.1,1>]
                                      }
                                 }
            }

}
box{<-18,4.4,-55>,<18,4.8,51>//assise du four partie suprieure
               texture{T_Mur rotate y*90 translate y*1}
               texture{//suie
                                pigment{
                                      bozo
                                      color_map{
                                                [0 rgbt<0.1,0.1,0.1,0>]
                                                [1 rgbt<0.1,0.1,0.1,1>]
                                      }
                                 }
            }

}

#declare Arcade= pigment{
                          radial
                          frequency 42

                          color_map{
                           //  [ END_VAL color red R green G blue B filter F transmit T]
                           [  0.0 Gray30]
                           [  0.2 Gray30]
                           [  0.2 C_Briques]
                           [  1.0 C_Briques]
                           }
                           rotate x*90
                  }

difference{//arcade de briques
           cylinder{<0,0,-54.5>,<0,0,50>,30}
           cylinder{<0,0,-55>,<0,0,50>,24}
           plane{x,0 rotate z*degrees(asin(18/24))}
           plane{x,0 rotate z*-degrees(asin(18/24)) inverse}
           texture{
           pigment{
                    wood
                    pigment_map{
                      [.0 Arcade]
                      [.295 Arcade]
                      [.295 Gray30]
                     }
                 scale 200
                }
            }
             texture{//suie
                                pigment{
                                      bozo
                                      color_map{
                                                [0 rgbt<0.1,0.1,0.1,0.5>]
                                                [1 rgbt<0.1,0.1,0.1,1>]
                                      }
                                 }
            }
            translate y*11
}
//------BRAISES
height_field
{
  gif "charbon.gif"
  scale <36,10,60>
  texture{ 
           crackle
           texture_map{
                [0 pigment {rgb 0}]
                [0.1 pigment{ rgb .2}]
                [1
                    pigment{ rgb<1,0.1,0>}
                    finish {
                      ambient .8
                      phong 0.1 phong_size 60
                    }
                ]
   }
   scale 2
   }
  translate<-18,4,-18>
}

// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color rgb <.5,0,0> // light's color
  translate <0, 20, 0>
}

//-----CUVE------
object{Cuve translate y*30}

//-----PILIER-----
box{<0,0,-8>,<16,203,8>
      texture{T_Pierre}
      translate x*54
}

//------PIVOT
box{<-6,203,5>,<6,223,8> translate x*62 texture{T_Fonte}}
cylinder{<62,218,-5.5>,<62,218,5.5>,2 pigment{Black}}

//-------CYLINDRE-----

#declare Cylindre=
     difference{
           union{
                 cylinder{y*168,y*170,19.5}
                 cylinder{y*164,y*170,18}
                 cylinder{y*100,y*164,13}//cylindre principal
           }
           cylinder{y*102,y*166,11}//evidement du cylindre principal
           cylinder{y*166,y*171,16}
      }

intersection{
      object{Cylindre}
      plane {z,0 inverse}
      texture{T_Copper_3A}
}
intersection{
      object{Cylindre}
      plane {z,0}
      pigment{rgbt <0.60, 0.30, 0.15,0.9>}
}


 cylinder{y*80,y*103,3
          texture{T_Brass_1A}
 }//tuyau de vapeur

//--------PLANCHER----
#declare R1=seed(1)
union{
      difference{
           //box{<-104,0,0>,<54,4,94>}
           union{
           #declare i=0 #while (i<=26)
                    box{<0,0,0>,<5.85,4,94>
                        texture{T_Charp rotate y*rand(R1)*5}
                        translate x*(-104+i*6)
                     }
            #declare i=i+1 #end
            }                                                                     
           cylinder{y*-0.1,y*4.1,13}
      }
      box{<-104,-10,13>,<54,0,23> texture{T_Charp}}//poutre
      translate y*160
}

//--------TUYAUX-------
union{//Tuyau d'arrive d'eau dans le cylindre
        cylinder{
            <21,100,0>,<32,170,0>,1
         }
         torus{
            6,1
            rotate x*90
            translate<15,100,0>
            clipped_by{plane{y,100}}
         }
          torus{
            4,1
            rotate x*90
            translate<36,170,0>
            clipped_by{plane{y,170 inverse}}
         }

         texture{T_Copper_1A}
}

//tuyau de sortie d'eau du cylindre
union{
cylinder{<-25,0,-55>,<-25,54,-55>,1}


#declare A1=<-25,54,-55>
#declare B1=<-10,100,0>
#declare A=A1+6*vnormalize((B1-A1)-<0,(B1-A1).y,0>)//centre tore du bas
#declare B=B1-6*vnormalize((B1-A1)-<0,(B1-A1).y,0>)//centre tore du haut

  #declare Beta=acos((B-A).y/vlength(B-A))
  #declare Alfa=asin(2*6/vlength(B-A))
  #declare Gamma=pi-Beta-Alfa
  #declare Dx=6*cos(Gamma)*vnormalize((B-A)-<0,(B-A).y,0>)
  #declare Dy=6*sin(Gamma)

  cylinder{A+<0,Dy,0>+Dx,B+<0,-Dy,0>-Dx,1}

  torus{6,1 rotate x*90
            clipped_by{plane{y,0  rotate z*degrees(Gamma) inverse}}
            clipped_by{plane{y,0 inverse}}
            rotate y*-degrees(atan2(55,15)) translate A
  }
  torus{6,1 rotate x*90
            clipped_by{plane{y,0  rotate z*degrees(Gamma)}}
            clipped_by{plane{y,0}}
            rotate y*-degrees(atan2(55,15)) translate B
  }
  texture{T_Copper_1A}
}
text { ttf "timrom.ttf" "F" 1, 0
     scale 10
    pigment { P_Lettre}
     translate <-35,25,-56>
  }

//--------RESERVOIR-------

object{Tonneau scale 9 translate<45,164,0>}
text { ttf "timrom.ttf" "A" 1, 0
     scale 10
    pigment { Red }
     translate <25,180,0>
  }

//---------CHAINES---


#include "chaine.inc"
object{Chaine1 translate <62,218,0> pigment{P_Fonte}}

object{Chaine2 translate <62,218,0> pigment{P_Fonte}}
//--------BALANCIER-----

#declare Demi_Roue=
 difference{
         cylinder{z*-5,z*5,61.5}
         cylinder{z*-5.1,z*5.1,52}
         plane{y,0 rotate z*-30 inverse}
         plane{y,0 rotate z*30}

         texture{T_Bois translate x*20 rotate y*90 rotate z*90}
}
#declare Rayon=
union{
    union{//Rayon suprieur avec la chaine
       box{<-50,-5,-4>,<0,5,5>
           texture{T_Bois rotate y*90 translate z*10}
       }
       object{ChaineDroite rotate z*-90 translate<-62+7,6,0> texture{T_Fonte}}
    rotate z*-28
    translate x*-7
    }
    box{<-50,-5,-4>,<0,5,5>
         texture{T_Bois rotate y*90}
         rotate z*28
         translate x*-7
    }
}

union{
    box{<-52,-5,-5>,<52,5,5>
         texture{T_Bois rotate y*90}//poutre centrale
     }
    box{<-5,-5.5,-5.5>,<5,5.5,5.5> texture{T_Fonte}}//renfort en metal
    object{Rayon}
    object{Rayon scale<-1,1,1>}
    object{Demi_Roue }
    object{Demi_Roue scale<-1,1,1>}
    rotate z*Pivot
    translate <62,218,0>
}



//-------PISTON----

union{
      cylinder{y*PosPiston,y*(PosPiston+3),10.9}//disque
      cylinder{y*(PosPiston+2),y*(PosPiston+10),2}//tige
      texture{T_Brass_1A}
      no_shadow

}

//--------CONTREPOIDS

#declare i=0
union{
       #while (i<10)
             cylinder{y*0,y*-3.8,10  translate y*(-i*4)}
       #declare i=i+1 #end
       cylinder{y*-40,y*-110,1.5 }//tige de la pompe
       sphere{y*-50,4 }
     text { ttf "timrom.ttf" "E" 1, 0
        scale 10
        pigment {P_Lettre}
       translate <-21,-20,0>
    }


       translate <124,PosPoids,0>
       texture {T_Fonte}
}


//---------TUYAU POMPE-------
cylinder{y*-100,y*60,3 texture{T_Cuve} translate x*124}
text { ttf "timrom.ttf" "G" 1, 0
     scale 10
    pigment {P_Lettre}
     translate <110,20,0>
  }

//---ROBINETS

#declare robinet=
union{
      torus{5,0.8 rotate x*-90 }
      #declare i=0 #while (i<4)
               cylinder{0,y*5,0.6 rotate z*(i*90)}
      #declare i=i+1 #end
      cylinder{0,z*7,1}
      translate z*-7
}
object{robinet //robinet de vapeur
      translate <0,90,0>
      pigment{rgb<0.7,0,0>}
}
text { ttf "timrom.ttf" "B" 1, 0
     scale 10
    pigment {P_Lettre}
     translate <-20,90,-7>
  }

object{robinet //robinet d'eau
       scale 0.6
       translate <15,94,0>
       pigment{rgb<0.7,0,0>}
}
text { ttf "timrom.ttf" "C" 1, 0
     scale 10
    pigment {P_Lettre}
     translate <24,94,-5>
  }
//----------SOUPAPE---------
union{
      cylinder{<10,79,0>,<10,85,0>,2 texture{T_Fonte}}
      box{<8,85,-2>,<38,86,2> texture{T_Fonte}}//barre
      cylinder{<35,79,0>,<35,84,0>,2.5 texture{T_Brass_1A}}//poids
      torus{2,.75 rotate z*-90 translate<35,84.5,0> texture{T_Brass_1A}}
      pigment{Gray30}
}
text { ttf "timrom.ttf" "D" 1, 0
     scale 10
     pigment {P_Lettre}
     translate <40,80,0>
  }

//COORDONNEES chemine
#declare xb1=-50  // base gauche
#declare xb2=50  // base droite
#declare xb3=xb2
#declare xb4=xb1
#declare zb1=-25   // base ant gauche
#declare zb2=zb1
#declare zb3=25    // base post gauche
#declare zb4=zb3
#declare yb1=0    // niveau de la base
#declare yb2=yb1
#declare yb3=yb1
#declare yb4=yb1

#declare xh1=-30   // en haut a gauche
#declare xh2=30   // en haut a droite
#declare xh3=xh2
#declare xh4=xh1
#declare zh1=-20    // en haut en avant
#declare zh2=zh1
#declare zh3=20    // en haut en arriere
#declare zh4=zh3
#declare yh1=280    // hauteur du sommet
#declare yh2=yh1
#declare yh3=yh1
#declare yh4=yh1

#declare Chemine=
union{
    polygon//face en -x
    {
          5, // nombre de points
          <xb1,yb1,zb1>,<xb2,yb2,zb2>,<xh2,yh2,zh2>,<xh1,yh1,zh1>,<xb1,yb1,zb1>
           pigment{
                   brick color Gray30, color C_Briques
                   brick_size<10,5,100>   // size of brick
                   mortar 0.8       // width of mortar

                }
    }
    polygon//face en +z
    {
          5, // nombre de points
          <xb2,yb2,zb2>,<xb3,yb3,zb3>,<xh3,yh3,zh3>,<xh2,yh2,zh2>,<xb2,yb2,zb2>
          pigment{
                   brick color Gray30, color C_Briques
                   brick_size<100,5,10>   // size of brick
                   mortar 0.5       // width of mortar
                }
    }
     polygon//face en +x
    {
          5, // nombre de points
          <xb4,yb4,zb4>,<xb3,yb3,zb3>,<xh3,yh3,zh3>,<xh4,yh4,zh4>,<xb4,yb4,zb4>
          pigment{
                   brick color Gray30, color C_Briques
                   brick_size<100,5,10>   // size of brick
                   mortar 0.8       // width of mortar
                }
    }
    polygon//face en -z
    {
          5, // nombre de points
          <xb4,yb4,zb4>,<xb1,yb1,zb1>,<xh1,yh1,zh1>,<xh4,yh4,zh4>,<xb4,yb4,zb4>
         pigment{
                   brick color Gray30, color C_Briques
                   brick_size<100,5,10>   // size of brick
                   mortar 0.8       // width of mortar
                }
    }
    polygon//face en +y
    {
          5, // nombre de points
          <xh1,yh1,zh1>,<xh2,yh2,zh2>,<xh3,yh3,zh3>,<xh4,yh4,zh4>,<xh1,yh1,zh1>
          pigment{Red}
    }

}


object{Chemine
       translate<0,54,74>
}


//------MUR DU FOND-----------
//----PARAMETRES FENETRE---------
#declare Ep=10//epaisseur du mur
#declare HFntr=17//hauteur de la fenetre
#declare LFntr=34//largeur de la fenetre
#declare RFntr=17//rayon de l'arcade
#include "Fenetre.inc"
#declare PosFenetre1=<80,275,0>

difference{
    box{<-114,0,0>,<350,350,10>}
    object{Fenetre  translate PosFenetre1}
    object{Fenetre  scale <1,-1,1> translate PosFenetre1}
      texture{T_Mur}
      texture{
                    T_Arc_Fenetre               
                    translate PosFenetre1
            }
      texture{
                    T_Arc_Fenetre
                    scale <1,-1,1>            
                    translate PosFenetre1
      }    
                     
    //cylinder{<80,275,-.1>,<80,275,10.1>,20}
    translate z*74
}
//cadre fentre hublot
union{
 difference{
   cylinder{PosFenetre1+<0,0,Ep/2>,PosFenetre1+<0,0,Ep/2+Ep/3>,RFntr}
   cylinder{PosFenetre1+<0,0,Ep/2-.1>,PosFenetre1+<0,0,Ep/2+Ep/3+.1>,RFntr-Ep/3}
 }
 union{
   #declare i=0 #while (i<=4)
       box{<-LFntr/2,-.5,Ep/2+Ep/6-1>,<LFntr/2,.5,Ep/2+Ep/6+.5> rotate z*i*180/4}
   #declare i=i+1 #end
 translate PosFenetre1
 }
 cylinder{PosFenetre1+<0,0,Ep/2+Ep/6-.5>,PosFenetre1+<0,0,Ep/2+Ep/6+.5>,RFntr
  texture{T_Old_Glass}
 }  
 pigment{White}
 translate z*74
} 

 
box{0,1
    pigment {
       image_map {
          gif "Newcomen16.gif"
       }
   }
   scale<105,128,10>//normalement <110,128,10>
   //translate<150,35,73>
   translate<135,15,73>
}
//------LEGENDE
text
{
  ttf  "timrom.ttf",
  "THE NEWCOMEN ENGINE",1,0
  scale 10
  translate<70,250,72>
  pigment{P_Lettre}
}

union{
text
{
  ttf  "timrom.ttf",
  "A : water tank",1,0
  scale 11
  translate<0,84,0>
}
text
{
  ttf  "timrom.ttf",
  "B : steam tap",1,0
    scale 11
  translate<0,72,0>
}
text
{
  ttf  "timrom.ttf",
  "C : water tap",1,0
    scale 11
  translate<0,60,0>
}
text
{
  ttf  "timrom.ttf",
  "D : safety valve",1,0
    scale 11
  translate<0,48,0>
}
text
{
  ttf  "timrom.ttf",
  "E : counterweight",1,0
    scale 11
  translate<0,36,0>
}
text
{
  ttf  "timrom.ttf",
  "F : emptying water pipe",1,0
    scale 11
  translate<0,24,0>
}
text
{
  ttf  "timrom.ttf",
  "G : pump pipe",1,0
    scale 11
  translate<0,12,0>
}
pigment{P_Lettre}
translate <135,145,72>
}
/*
box{0,1
   pigment {
       image_map {
          gif "legende.gif"
       }
   }
   scale<96,96,5>
   //translate<150,35,73>
   translate<135,145,73>
}
*/
//----------TOIT
union{
 plane{y,0 rotate z*45 translate<-114,200,0>}
 plane{y,0 rotate z*-45 translate<114+2*80,200,0>}
 clipped_by{box{<-114,200,-500>,<114+2*80,500,114>}}
 pigment{rgb<0.4,0.4,0.5>}
}
#declare Poutre=
box{<0,0,-500>,<10,10,74> texture{T_Charp} }
#declare i=0 #while (i<=1)
         object{Poutre translate<0,20+i*(109+62)/3,0>
            rotate z*-45
            translate <-109,200,0>
         }
         object{Poutre scale <-1,1,1> translate<0,20+i*(109+80)/3,0>
            rotate z*45
            translate <109+2*80,200,0>
         }
#declare i=i+1 #end
#declare i=1 #while (i<=14)
         box{<0,-5,0>,<(114+80)*sqrt(2),0,5>
                 texture{T_Charp rotate y*90}
                rotate z*45
                translate<-114,200,-200+i*20>
          }
          box{<0,-5,0>,<-(114+80)*sqrt(2),0,5>
                texture{T_Charp rotate y*90}
                rotate z*-45
                translate<114+2*80,200,-200+i*20>
          }
 #declare i=i+1 #end


//---Mur  l'arrire
box{<-114,0,0>,<350,350,10>
 texture{T_Mur}
 translate z*-500
}
//MUR DROIT
  box{<0,0,-350>,<10,199,94>

            texture{
               T_Mur
               rotate y*90
            }
  translate x*(2*80+103)
  }
//MUR GAUCHE
//----PARAMETRES FENETRE---------
#declare Ep=10//epaisseur du mur
#declare HFntr=90//hauteur de la fenetre
#declare LFntr=40//largeur de la fenetre
#declare RFntr=53//rayon de l'arcade
#include "Fenetre.inc"
#declare PosFenetre1=<0,38,45>
#declare PosFenetre2=<0,38,-20>
#declare PosFenetre3=<0,38,-85>

union{
      difference{
           box{<-10,0,-350>,<0,199,94>}
           object{Fenetre
                  rotate y*-90
                  translate PosFenetre2
           }
           object{Fenetre
                  rotate y*-90
                  translate PosFenetre3
           }
           texture{
               T_Mur
               rotate y*-90
               scale <5,1,1>
               translate z*2.5//evite le mortier sur les fenetres
            }
            texture{
                    T_Arc_Fenetre
                    rotate y*90
                    translate PosFenetre2
            }
             texture{
                    T_Arc_Fenetre
                    rotate y*90
                    translate PosFenetre3
            }
       }
       object{Cadre rotate y*-90 translate PosFenetre2}
       object{Cadre rotate y*-90 translate PosFenetre3}
       translate x*-104
}

box{<-10,0,0>,<0,164,94>//muret
   texture{T_Mur rotate y*-90}
   translate x*(62+5)
}
/*
box{<-10,0,-10.1>,<0,164,-10>//ct du mur
   texture{T_MurBout rotate y*-90 rotate x*90 scale <1,.5,1> translate <0.5,2.5,2.5>}
   translate x*-54
}
*/


//------TAS de CHARBON
height_field
{
  gif "charbon.gif"
  scale <60,35,60>
  texture{
       pigment{rgb<0.1,0.1,0.1>}
       normal{crackle
              bump_size 2
       }
       finish { phong 0.1 phong_size 60 }

       scale 2
  }
  translate<-104,0,-50>
}


//-----GENIE

object{Genie scale .9 translate y*(PosPiston+2)}

object{Genie2 scale .5 translate y*103 pigment{rgbt<1,0,0,.75>}}

