#version 3.0
global_settings 
{ 
  assumed_gamma 2.2 
  max_trace_level 20
}

#include "colors.inc"

//////////////////////////////////////////////////////////////////////////
//                                                                      //
//               CAMERA, LIGHT, BACKGROUND                              //
//                                                                      //
//////////////////////////////////////////////////////////////////////////

camera
  { 
    location <0, 5, -60>*3
    direction <0,0,1>*2
    look_at  <0,0,100>
  focal_point < 0, 0, -135>
    aperture 0.5
//  blur_samples 4       // fewer samples, faster to render
    blur_samples 20      // more samples, higher quality image  
  }

#include "Pballlit.inc"

#background { color DustyRose }


#include "skies.inc"
sky_sphere {
  pigment { P_Cloud3 scale <.15, .05, .15> }
  rotate y*15
}


//////////////////////////////////////////////////////////////////////////
//                                                                      //
//               THE BALLS                                              //
//                                                                      //
//////////////////////////////////////////////////////////////////////////
#include "Pball.inc"

#include "Pballglw.inc"

#ifdef (Simple)
  #declare Ball = sphere { <0,0,0>, PentaBallRad } // for testing only
#else
  #declare Ball = object { PentaBall }
#end

#declare T1 = <  5,   6, -75>*PentaBallRad
#declare T2 = <- 4,  11, -34>*PentaBallRad
#declare T3 = <-18,   5, -13>*PentaBallRad
#declare T4 = < 12,  19, - 2>*PentaBallRad
#declare T5 = <-28,  24,  10>*PentaBallRad
#declare T6 = <- 3,   7,  23>*PentaBallRad
#declare T7 = <  0,  23,  40>*PentaBallRad
#declare T8 = <- 6,  42,  80>*PentaBallRad


#declare Sc = 3.2

#declare Balls = 
  union { 
    object { Ball scale Sc rotate y*24 translate T1 pigment { color Red } }
    object { Ball scale Sc rotate y*15 translate T2 pigment { color Blue } }
    object { Ball scale Sc rotate y*20 translate T3 pigment { color Green } }
    object { Ball scale Sc rotate y*25 translate T4 pigment { color Yellow } }
    object { Ball scale Sc rotate y*30 translate T5 pigment { color Magenta } }
    object { Ball scale Sc rotate y*35 translate T6 pigment { color Cyan } }
    object { Ball scale Sc rotate y*40 translate T7 pigment { color White } }
    object { Ball scale Sc rotate y*48 translate T8 pigment { color Pink } }
  }

object { Balls }

#declare BallLights = 
  union { 
    object { BallLight translate <T1.x,0,T1.z> }
    object { BallLight translate <T2.x,0,T2.z> }
    object { BallLight translate <T3.x,0,T3.z> }
    object { BallLight translate <T4.x,0,T4.z> }
    object { BallLight translate <T5.x,0,T5.z> }
    object { BallLight translate <T6.x,0,T6.z> }
    object { BallLight translate <T7.x,0,T7.z> }
    object { BallLight translate <T8.x,0,T8.z> }
  }

object { BallLights }

//////////////////////////////////////////////////////////////////////////
//                                                                      //
//               PENTA PLANE                                            //
//                                                                      //
//////////////////////////////////////////////////////////////////////////

#include "Pplane.inc"

#declare Plane = 
  object { PentaPlane 
    scale Sc/5 /* to bring it in same scaling as PentaBall! */
    rotate y*56
    translate <0,-3,10>
  }

object { Plane }


