#include "colors.inc"

#declare Amb = .3

#declare P_Brass1    = color rgb <0.58*0.7, 0.42*0.7, 0.20*0.7>
#declare P_Brass2    = color rgb <0.58*1.5, 0.42*1.5, 0.20*1.5>
#declare P_Brass3    = color rgb <0.58*2.0, 0.42*2.0, 0.20*2.0>
#declare P_Brass4    = color rgb <0.65, 0.50, 0.25>
#declare P_Silver1    = color rgb <0.94, 0.93, 0.80>

#declare F_MetalB = 
  finish {
    ambient  Amb    brilliance 3      diffuse 0.4      metallic
    specular 0.70   roughness 1/60    reflection 0.25 
  }

#declare F_MetalC  =
finish {
    ambient Amb     brilliance 4     diffuse 0.5    metallic
    specular 0.80   roughness 1/80   reflection 0.5
}

#declare F_Metal = finish { F_MetalC }

#declare Brass1  = texture { pigment { P_Brass1 }  finish { F_Metal } }
#declare Brass2  = texture { pigment { P_Brass2 }  finish { F_Metal } }
#declare Brass3  = texture { pigment { P_Brass3 }  finish { F_Metal } }
#declare Brass4  = texture { pigment { P_Brass4 }  finish { F_Metal } }
#declare Silver1 = texture { pigment { P_Silver1 } finish { F_Metal } }

#declare TexRho =
  texture{ Silver1
    normal { crackle 0.3 scale 0.1 }
  } 

#declare TexCyl  = 
  texture { 
    pigment { crackle  turbulence .4 scale .2
      pigment_map {
	[0.0  P_Brass4 ]
	[0.1  P_Brass3 ]
	[1.0  P_Brass3 ]
      }
    }
//    normal { dents 2 scale 0.02 }
  } 

#declare TexSph = texture { TexCyl }

