#include <math.h>

/* 
   compileer als: 
  cc -O -o penta penta.c -lm
*/   

#define PAGE_WIDTH   400
#define PAGE_HEIGHT  300

typedef double real;

typedef struct complex_struct { real re, im; } complex;

complex zeta[6];
complex eta;
real pi = M_PI;
real gama[5];  /* gamma is predefined math function */
int scale;
real width, height;
complex grid_min, grid_max;

init_constants()
{
  real h = 2 * pi / 5;

  zeta[0].re = 1;
  zeta[0].im = 0;

  zeta[1].re = cos(h);
  zeta[1].im = sin(h);

  zeta[2].re = cos(2*h);
  zeta[2].im = sin(2*h);

  zeta[3].re = cos(2*h);
  zeta[3].im = -sin(2*h);

  zeta[4].re = cos(h);
  zeta[4].im = -sin(h);

  zeta[5].re = 1;
  zeta[5].im = 0;

  gama[0] = .1;
  gama[1] = .1;
  gama[2] = .1;
  gama[3] = .1;
  gama[4] = - gama[0] - gama[1] - gama[2] - gama[3]; 

  eta.re = gama[0]*zeta[0].re  
         + gama[1]*zeta[1].re  
         + gama[2]*zeta[2].re  
         + gama[3]*zeta[3].re  
         + gama[4]*zeta[4].re;
  eta.im = gama[0]*zeta[0].im  
         + gama[1]*zeta[1].im  
         + gama[2]*zeta[2].im  
         + gama[3]*zeta[3].im  
         + gama[4]*zeta[4].im;


}

f(z,fz)
complex z, *fz;
{
 int i, K[5];
 for (i=0; i<5; i++)
   {
     K[i] = roof(z.re * zeta[5-i].re - z.im * zeta[5-i].im + gama[i]);
   }
 zetaprod(K,fz);
}

int inside(x, y)
real x, y;
{
  if (x > width+2)  return (0);
  if (y > height+2) return (0);
  if (x < -width-2) return (0);
  if (y < -height-2) return (0);
  return (1);
}

handle_parameters(argc,argv)
int argc;
char **argv;
{
  complex MIN, MAX;
  real c;

  if (argc == 1) exit(1);

  scale = atoi(argv[1]);
  width  = PAGE_WIDTH / (2 * (real)scale);
  height = PAGE_HEIGHT / (2 * (real)scale);

  c = 1 + 2 * cos(pi/5) + cos(2*pi/5);

  grid_min.re = ( -width - eta.re - c)*2/5;
  grid_max.re = (  width - eta.re + c)*2/5;
  grid_min.im = (-height - eta.im - c)*2/5;
  grid_max.im = ( height - eta.im + c)*2/5;

 f(grid_min,&MIN); f(grid_max,&MAX);

}

print_init()
{ printf("#declare Penta = \n"); 
  printf("// intersection { \n");
  printf("    union {\n");
}


print_exit()
{
  printf("scale %d\n", scale);
  printf("    }\n");
/*
  printf("//   box{ <%f11,-2,%f11> <%f11,1,%f11> }\n", 
         -width, -height, width, height
        );
*/
  printf("// }\n");
}

zetaprod(A,pc)
int A[];
complex *pc;
{
  pc->re = A[0]*zeta[0].re  
         + A[1]*zeta[1].re  
         + A[2]*zeta[2].re  
         + A[3]*zeta[3].re  
         + A[4]*zeta[4].re;
  pc->im = A[0]*zeta[0].im  
         + A[1]*zeta[1].im  
         + A[2]*zeta[2].im  
         + A[3]*zeta[3].im  
         + A[4]*zeta[4].im;
}

int roof(r)
real r;
{
  int i;
  i = r;
  if (i < r) i++;
  return (i);
}

int round(r)
real r;
{ int i;
  if (r < 0)
    { 
      r = -r;
      i = r + .5;
      i = -i;
    }
  else
    i = r + .5;
  return i;
}

int delta(i,j)
int i, j;
{ 
  if (i == j) return 1;
  else        return 0;
}

print_rhombus(shape,gr,rd)
char *shape;
complex gr, rd;
{
  real dx, dy;
  int angle;

  dx = rd.re - gr.re;
  dy = rd.im - gr.im;
  if (dx == 0)
    angle = 90;
  else if (dx > 0)
    if (dy >= 0)
      angle = round(atan(dy / dx) * 180 / pi);  
    else
      angle = round(- atan((-dy) / dx) * 180 / pi); 
  else
    if (dy >= 0)
      angle = round(180 - atan(dy / (-dx)) * 180 / pi); 
    else
      angle = round(180 + atan((-dy) / (-dx)) * 180 / pi); 

  if (angle <= 0) angle += 360;

  if (inside(gr.re, gr.im))
    printf("    object{%s   rotate y*%3d   translate <% f11,0,% f11>}\n", 
	   shape, 360-angle, gr.re, gr.im);
    
}

real min(x,y)
real x,y;
{
  if (x < y) return x;
  else       return y;
}

real max(x,y)
real x,y;
{
  if (x > y) return x;
  else       return y;
}

kr_extremes(r,krmin,krmax)
int r, *krmin, *krmax;
{
  real b1, b2, b3, b4;

  b1 = grid_min.re * zeta[5-r].re - grid_min.im * zeta[5-r].im + gama[r];
  b2 = grid_max.re * zeta[5-r].re - grid_min.im * zeta[5-r].im + gama[r];
  b3 = grid_min.re * zeta[5-r].re - grid_max.im * zeta[5-r].im + gama[r];
  b4 = grid_max.re * zeta[5-r].re - grid_max.im * zeta[5-r].im + gama[r];
  *krmin = roof(min(min(b1,b2),min(b3,b4)));
  *krmax = max(max(b1,b2),max(b3,b4));
}

ks_extremes(r,kr,s,N,ksmin,ksmax)
int r, kr, s, *ksmin, *ksmax;
real N;
{
  real b1, b2, b3, b4, b;

  if (r == 0)
    {
      b1 = -100000000000000.0;
      b2 =  100000000000000.0;
      b3 = ((kr-gama[r])*zeta[5-s].re-N*grid_min.im) + gama[s];
      b4 = ((kr-gama[r])*zeta[5-s].re-N*grid_max.im) + gama[s];
    }
  else
    {
      b1 = ((kr-gama[r])*zeta[5-s].im-N*grid_min.re)/zeta[5-r].im + gama[s];
      b2 = ((kr-gama[r])*zeta[5-s].im-N*grid_max.re)/zeta[5-r].im + gama[s];
      b3 = ((kr-gama[r])*zeta[5-s].re-N*grid_min.im)/zeta[5-r].re + gama[s];
      b4 = ((kr-gama[r])*zeta[5-s].re-N*grid_max.im)/zeta[5-r].re + gama[s];
    }
  
  if (b1 > b2)
    { b = b1; b1 = b2; b2 = b; }
  if (b3 > b4)
    { b = b3; b3 = b4; b4 = b; }

  *ksmin = max(b1,b3);
  *ksmax = roof(min(b2,b4));

}


int main(argc,argv)
int argc;
char **argv;
{
  real N;
  int r, s, kr, ks, indl, indh, i, krmin, krmax, ksmin, ksmax, up;
  complex z, fl, fh, gr, rd;
  int Kl[5], Kh[5];

  init_constants();
  handle_parameters(argc,argv);  

  print_init();
  
  for (r=0; r<5; r++) /* grid1 */
    {
      kr_extremes(r,&krmin, &krmax); 
      for (kr=krmin; kr<=krmax; kr++) /* line of grid1 */
	{
	  for (s=r+1; s<5; s++) /* grid2 */
	    {
	      N = zeta[5-r].re * zeta[5-s].im - zeta[5-s].re * zeta[5-r].im;
	      ks_extremes(r,kr,s,N,&ksmin,&ksmax);
	      for (ks=ksmin; ks<=ksmax; ks++) /* line of grid2 */
		{
		  z.re = ( (kr - gama[r]) * zeta[5-s].im - 
			   (ks - gama[s]) * zeta[5-r].im
			 ) / N;
		  z.im = ( (kr - gama[r]) * zeta[5-s].re -
			   (ks - gama[s]) * zeta[5-r].re
			 ) / N;
		  for (i = 0; i < 5; i++)
		    {
		      if (i == r)      Kl[i] = kr;
		      else if (i == s) Kl[i] = ks;
		      else		    
			Kl[i] = roof(z.re * zeta[5-i].re - 
				     z.im * zeta[5-i].im + gama[i]);
		    }		    
		  zetaprod(Kl,&fl);
		  indl = (Kl[0] + Kl[1] + Kl[2] + Kl[3] + Kl[4]);
		  
		  for (i = 0; i < 5; i++)
		    {
		      Kh[i] = Kl[i] + delta(i,r) + delta(i,s);
		    }
		  zetaprod(Kh,&fh);
		  indh = (Kh[0] + Kh[1] + Kh[2] + Kh[3] + Kh[4]);
		  
		  if (indl == 1) 
		    {
		      gr = fl;
		      rd = fh;
		      up = 1;
		    }
		  else /* indl == 2 */
		    { if (indl != 2) printf("// ERROR<<<<<<<<<<<<<<<");
		      gr = fh;	    
		      rd = fl;
		      up = 0;
		    }
		  if ((s - r) == 2 || (s - r) == 3)
		    if (up)
		      print_rhombus("ThinUp   ",gr,rd);
		    else
		      print_rhombus("ThinDown ",gr,rd);
		  else
		    if (up)
		      print_rhombus("ThickUp  ",gr,rd);
		    else
		      print_rhombus("ThickDown",gr,rd);
		}
	    }
	}
    }

  print_exit();

  exit(0);
}






