OPEN "helix.pov" FOR OUTPUT AS #1
pi = 3.14159

orbits = 17
freq = 15
rmajor = 60
rminor = 45
steps = 1000
cylrad = 8
sphrad = 8

FOR t = 0 TO ((2 * pi) + ((2 * pi) / steps)) STEP ((2 * pi) / steps)
px = x: py = y: pz = z
x = COS(t * orbits) * (rmajor + (rminor * SIN(t * freq)))
y = SIN(t * orbits) * (rmajor + (rminor * SIN(t * freq)))
z = rminor * COS(t * freq)

IF t > 0 THEN GOSUB povout
NEXT t
END

povout:
zto = t / (2 * pi)
  rval = (1 + SIN(t)) / 2
  gval = (1 + COS(t)) / 2
  bval = (1 + SIN(t + pi)) / 2
PRINT #1, USING "cylinder { <####.######, ####.######, ####.######>, <####.######, ####.######, ####.######>, ####.#### open "; x; y; z; px; py; pz; cylrad
PRINT #1, USING "pigment { color rgb <####.######, ####.######, ####.######> }"; rval; gval; bval
PRINT #1, "}"
PRINT #1, USING "sphere { <####.######, ####.######, ####.######>, ####.#### "; x; y; z; sphrad
PRINT #1, USING "pigment { color rgb <####.######, ####.######, ####.######> }"; rval; gval; bval
PRINT #1, "}"
RETURN


