
// Glenn's Locomotive POV-Ray Object File
// This file does not render.  #include "Locomotive.inc" in another .pov file
// first concept 21-May-97  last update 8-June-97
// This file modified slightly for distribution...
// copyright 1997 Glenn McCarter

// A Locomotive and Coal Car
// Intended scale is English system (inches)
// Locomotive stands on Z=0 plane, origin at ground level, at front of main boiler
// +X is towards the rear of the Locomotive
// Uses RH coord system


//===============================================
//             Variable Declarations
//===============================================

#declare BoilerHt = 7*Feet // off the ground
#declare BoilerRad = 3*Feet
#declare CabHalfWidth = 4.5*Feet

//===============================================
//             Transformations
//===============================================

#declare InverseY = // forms a mirror image
	transform {
  	matrix < 1, 0, 0,
             0, -1, 0,
             0, 0, 1,
             0, 0, 0 >
	}

//===============================================
//             Textures
//===============================================

#declare SteelTex =
	texture {
		pigment { color rgb<.9,.9,.9> }
		finish {
			ambient .06
			brilliance 6
			diffuse .7
			metallic
			specular .9
			roughness .003
//			reflection .3
		}
	}
#declare PolishedSteelTex =
	texture {
		pigment { color rgb<.9,.9,.9> }
		normal { bumps .2 scale <.5,.1,.5> }
		finish {
			ambient .05
			brilliance 6
			diffuse .7
			metallic
			specular .95
			roughness .01
			reflection .2
		}
	}
#declare LocoTex =
	texture {
//		pigment { color rgb<1,1,1> } // test
		pigment { color rgb<.1,.1,.2> }
		finish { ambient .01 specular .7 roughness .05 }
	}

//===============================================
//             Wheels
//===============================================

#declare DriveWheel = //backside of main rim at Y=0
			cylinder { //dummy
				<0,0,0>,<0,3,0>,24
				texture { PolishedSteelTex }
			}

#declare SmallWheel = // center at middle of rail
			cylinder { // dummy
				<0,0,0>,<0,3,0>,12
				texture { PolishedSteelTex }
			}

#declare Axle =
	cylinder {
		<0,-20,0>,<0,20,0>,3
		texture { LocoTex }
	}

#declare SmallWheelAssy =
	union {
		object { SmallWheel translate <0,24,0> }
		object { SmallWheel transform InverseY translate <0,-24,0> }
		object { Axle translate <0,0,12> }
	}
#declare DriveWheelAssy =
	union {
		object { DriveWheel translate <0,24,0> }
		object { DriveWheel transform InverseY translate <0,-24,0> }
		object { Axle translate <0,0,24> }
	}

//===============================================
//             Boiler
//===============================================

#declare Boiler = // center at front end of main boiler
		cylinder { //main boiler
			<0,0,0>,<25*Feet,0,0>,3*Feet
			texture { LocoTex }
			translate <2,0,0>
		}


#declare BoilerAssy =
	union {
		object { Boiler translate <0,0,BoilerHt> }
//		object { SteamStacks }
//		object { BHandRailRH translate <12,0,BoilerHt> }
//		object { BHandRailLH translate <12,0,BoilerHt> }
//		object { MiscParts translate <0,0,BoilerHt> }
//		object { MiscParts transform InverseY translate <0,0,BoilerHt> }
	}

//===============================================
//             Undercarriage
//===============================================


#declare BoilerSupport =
	union {
		box { // front support RH
			<0,1.3*Feet,11>,<14,0.8*Feet,36>
		}
		box { // front support LH
			<0,-1.3*Feet,11>,<14,-0.8*Feet,36>
		}
		box { // cross bar
			<1,-1.3*Feet,18>,<13,1.3*Feet,26>
		}
		texture { LocoTex }
	}

#declare MainChassis =
	union {
		box { // main chassis box
			<14,-1.4*Feet,0>,<29*Feet,1.4*Feet,12>
			texture { LocoTex }
		}
		object { BoilerSupport translate <6*Feet,0,0> }
		object { BoilerSupport translate <12*Feet,0,0> }
		object { BoilerSupport translate <18*Feet,0,0> }
	}

#declare ChassisAssy =
	union {
		object { MainChassis translate <0,0,16> }
		object { DriveWheel translate <92,24,0> }
		object { DriveWheel translate <162,24,0> }
		object { DriveWheel translate <232,24,0> }
		object { DriveWheel rotate z*180 translate <92,-24,0> }
		object { DriveWheel rotate z*180 translate <162,-24,0> }
		object { DriveWheel rotate z*180 translate <232,-24,0> }
		object { Axle translate <92,0,24> }
		object { Axle translate <162,0,24> }
		object { Axle translate <232,0,24> }
		object { SmallWheel translate <280,24,0> }
		object { SmallWheel rotate z*180 translate <280,-24,0> }
		object { Axle translate <280,0,12> }
		object { SmallWheel translate <340,24,0> }
		object { SmallWheel rotate z*180 translate <340,-24,0> }
		object { Axle translate <340,0,12> }
	}

//===============================================
//             Front Undercarriage
//===============================================

#declare HandRail =
	union {
		cylinder { <0,0,0>,<0,0,-40>,.5 translate <7,0,0> } // rear
		intersection {
			torus { 7,.5 }
			box { <-9,-1,-9>,<9,1,0> inverse } // cut off bottom
			box { <-9,-1,-9>,<0,1,0> rotate <0,15,0> inverse } // cut off angle front
		}
		cylinder { <0,0,0>,<0,0,-30>,.5 translate <-7,0,0> rotate <0,15,0> } // front angled
		texture { SteelTex }
	}

#declare SmallCyls =
	union {
		cylinder {
			<-4,32,0>,<-4,32,12>,3.2
		}
		cylinder {
			<4,32,0>,<4,32,12>,2.2
		}
	}
#declare BigCylRH =
	union {
		cylinder {
			<0,32,0>,<0,32,12>,4.4
		}
		cylinder {
			<0,32,-1>,<0,32,13>,4.0
		}
		sphere { <0,0,0>,3.5 scale <1,1,.6> translate <0,32,13> }
	}
#declare HorizCylRH =
	union {
		cylinder {
			<0,22,0>,<18,22,0>,3.4
		}
		sphere { <0,0,0>,3.0 scale <.7,1,1> translate <0,22,0> }
		sphere { <18,22,0>,3.0 }
		box { <4,0,-2>,<14,-10,2> rotate <-40,0,0> translate <0,22,0> }
	}
#declare HorizTubeRH =
	union {
		cylinder {
			<0,20,0>,<38,20,0>,0.8
		}
		sphere { <6,20,0>,1.4 }
		sphere { <18,20,0>,1.4 }
	}
#declare TopPlatform =
	union {
		object { SmallCyls translate <-44,0,27> }
		object { SmallCyls transform InverseY translate <-44,0,27> }
		box { // top platform
			<0,-36,0>,<18,36,2>
			translate <-56,0,38>
		}
		box { // platform over wheels
			<0,-36,0>,<18,36,4>
			translate <-53,0,24>
		}
	}
#declare FrontChassis = // origin at front wheels
	union {
		box { // main chassis
			<-24,-20,0>,<24,20,8>
		}
		cylinder { // center pivot
			<0,0,11>,<0,0,22>,7
		}
		box { // rear top box
			<0,-27,0>,<12,27,11>
			translate <-40,0,33>
		}
		box { // center box under platform
			<0,-18,0>,<12,18,11>
			translate <-60,0,24>
		}
		box { // front main support
			<0,-20,0>,<34,20,18>
			translate <-46,0,6>
		}
		box { // fwd support small
			<0,-8,0>,<34,8,11>
			translate <-66,0,15>
		}
		box { // cowcatcher support
			<0,-18,0>,<48,18,11>
			translate <-70,0,9>
		}
		box { // cowcatcher overbox
			<0,-24,0>,<21,24,5>
			translate <-76,0,22>
		}
		object { TopPlatform }
		object { BigCylRH translate <-30,0,24> }
		object { BigCylRH transform InverseY translate <-30,0,24> }
		object { HorizCylRH translate <-62,0,8> }
		object { HorizCylRH transform InverseY translate <-62,0,8> }
		object { HorizTubeRH translate <-62,0,17> }
		object { HorizTubeRH transform InverseY translate <-62,0,17> }
		texture { LocoTex }
	}


#declare FrontChassisAssy = // origin midway between wheels
	union {
//		object { FrontChassis translate <0,0,10> }
//		object { CowCatcher translate <-85,0,10> }
		object { HandRail translate <-40,28,68> }
		object { HandRail translate <-40,-28,68> }
		object { SmallWheel translate <-26,24,0> }
		object { SmallWheel translate <26,24,0> }
		object { SmallWheel rotate z*180 translate <-26,-24,0> }
		object { SmallWheel rotate z*180 translate <26,-24,0> }
		object { Axle translate <-26,0,12> }
		object { Axle translate <26,0,12> }
	}

//===============================================
//             Running Gear
//===============================================

#declare MainLink =
	union {
		box { <0,0,-3>,<100,3,3> }
		cylinder { // end
			<0,-3.5,0>,<0,3.5,0>,5
			texture { SteelTex }
		}
		cylinder { // pivot
			<0,-4.1,0>,<0,4.1,0>,2
			texture { LocoTex }
		}
		cylinder { // end
			<0,-3.5,0>,<0,3.5,0>,5
			texture { SteelTex }
			translate <100,0,0>
		}
		cylinder { // pivot
			<0,-4.1,0>,<0,4.1,0>,2
			texture { LocoTex }
			translate <100,0,0>
		}
	}
#declare WheelLink =
	union {
		box { <0,0,-2>,<30,3,2> }
		cylinder { <0,-3.3,0>,<0,3.3,0>,3 }
		cylinder {
			<0,-3.3,0>,<0,3.3,0>,3
			translate <30,0,0>
		}
		texture { SteelTex }
	}
#declare FrontKnuckle =
	union {
		box { <0,-8,-4>,<8,4,4> } // fat part
		box { <0,-2,-16>,<5,2,9> } // tall part
		box { <0,0,0>,<1,1,1> } // lower part
		texture { LocoTex }
	}
#declare WierdPiece =
	union {
		box { <0,-9,-2>,<8,3,3> translate <0,0,19>} // wide upper part
		box { <2,-2,-12>,<6,2,20> translate <0,8,0> } // tall part
		texture { LocoTex }
	}
#declare LowerLink =
	union {
		box {
			<0,-2.5,-2>,<22,2.5,2>
			texture { LocoTex }
		}
		cylinder { // end
			<0,-3,0>,<0,3,0>,3
			texture { LocoTex }
		}
		cylinder { // pivot
			<0,-4.6,0>,<0,4.6,0>,1.6
			texture { SteelTex }
		}
		cylinder { // end
			<22,-3,0>,<22,3,0>,3
			texture { LocoTex }
		}
		cylinder { // pivot
			<0,-4.6,0>,<0,4.6,0>,1.6
			texture { SteelTex }
			translate <100,0,0>
		}
	}

#declare DriveLinkageRH = // origin at MainLink
	union {
		object { MainLink translate <0,8,0> }
		object { FrontKnuckle translate <-8,8,8> }
		object { WierdPiece translate <-28,0,0> }
		object { LowerLink translate <-22,8,-12> }
		object { WheelLink rotate <0,156,0> translate <0,2,0> }
		object { WheelLink rotate <0,32,0> translate <30,2,0> }
		object { WheelLink rotate <0,32,0> translate <100,2,0> }
	}

//===============================================
//             Cockpit
//===============================================

#declare CockpitBox = // basic shape of cab
	difference { // subtract cutouts
		union {
			box { // cockpit outer
				<0,-CabHalfWidth,3*Feet>,<8*Feet,CabHalfWidth,11*Feet>
			}
			box { // angled face RH
				<0,0,3*Feet>,<16,-24,11*Feet>
				rotate <0,0,-30>
				translate <0,4.4*Feet,0>
			}
			box { // angled face LH
				<0,0,3*Feet>,<16,-20,11*Feet>
				rotate <0,0,-30>
				translate <0,4.4*Feet,0>
				transform InverseY
			}
			box { // front face
				<-9,-30,3*Feet>,<1,30,11*Feet>
			}
			texture { LocoTex }
		} // end of union
		box { // RH lower cutout
			<-6,0,0>,<9*Feet,30,5*Feet>
			texture { LocoTex }
			translate <0,CabHalfWidth-8,0>
		}
		box { // LH lower cutout
			<-6,0,0>,<9*Feet,-30,5*Feet>
			texture { LocoTex }
			translate <0,-CabHalfWidth+8,0>
		}
	}

#declare RoofInnerShape =
	cylinder { <-3*Feet,0,0>,<20*Feet,0,0>,12*Feet translate <0,0,-22> }
#declare Roof =
	intersection {
		object { RoofInnerShape inverse }
		object { RoofInnerShape scale 1.02 }
		box { <-16,-CabHalfWidth-3,0>,<10*Feet,CabHalfWidth+3,20*Feet> }
		texture { LocoTex }
	}

#declare Cockpit = // origin at front of firewall, 3-feet above ground
	union {
		difference {
			object { CockpitBox }
			object { CockpitBox
				translate <-5*Feet,0,-7*Feet> // reset origin to center of cab
				scale <1,.95,.95>
				translate <5*Feet+2,0,7*Feet> // reset origin to front bottom
			}
			object { RoofInnerShape inverse texture { LocoTex } }
			box { // front window RH
				<-12,-4.8,88>,<3,4.8,110>
				texture { LocoTex }
				translate <0,46,0>
			}
			box { // front window LH
				<-12,-4.8,88>,<3,4.8,110>
				texture { LocoTex }
				translate <0,-46,0>
			}
			box { // side windows front
				<6,-90,80>,<30,90,106>
				texture { LocoTex }
				translate <0,0,0>
			}
			box { // side windows rear
				<38,-90,80>,<62,90,106>
				texture { LocoTex }
				translate <0,0,0>
			}
		} // end of difference
		object { Roof translate <0,0,-1> }
	}

//===============================================
//             Misc Objects
//===============================================

#declare HeadLamp = //origin at back end of mouting
	union {
		cylinder { // lamp mount
			<0,0,0>,<-4,0,0>,5
			texture { LocoTex }
			translate <0,0,0>
		}
		difference {
			cylinder { // lamp housing
				<-4.4,0,0>,<-14,0,0>,7
				texture { LocoTex }
				translate <0,0,0>
			}
			cylinder { // lamp mount
				<-5,0,0>,<-15,0,0>,6
				texture { LocoTex }
				translate <0,0,0>
			}
		}
		cylinder { // bright lens
			<-11,0,0>,<-12,0,0>,6.5
			texture {
				pigment { color rgb<1,1,1> }
				finish { ambient 1.0 }
			}
			translate <0,0,0>
		}
	}

#declare NumberPlate =
	union {
		box { //mountingplate
			<0,-13,0>,<-2,13,8>
			texture { LocoTex }
		}
		box { // white paint
			<-1.8,-12.5,0.5>,<-2.05,12.5,7.5>
			texture {
				pigment { color rgb<1,1,1> }
				finish { ambient .3 }
			}
		}
		text {
			ttf "c:\Windows\Fonts\TT1058M_.TTF",
			"8 3 2 5",
			1,     // THICKNESS_FLOAT extruded into +Z
			0       //OFFSET_VECTOR between letters
			texture { LocoTex }
			scale <6,6,1>
			rotate <90,0,-90>
			translate <-1.1,9,2>
		}
	}

#declare DriveUnit = //center at front of upper cyl
	union {
		cylinder { // upper main cylinder
			<0,0,0>,<24,0,0>,8
			texture { LocoTex }
			translate <0,0,0>
		}
		cylinder { // lower main cylinder
			<0,0,0>,<24,0,0>,8
			texture { LocoTex }
			translate <0,0,-11>
		}
		cylinder { // upper end cyl-1
			<-1,0,0>,<25,0,0>,7
			texture { LocoTex }
			translate <0,0,0>
		}
		cylinder { // lower end cyl-1
			<-1,0,0>,<25,0,0>,7
			texture { LocoTex }
			translate <0,0,-11>
		}
		cylinder { // upper end cyl-2
			<-1.5,0,0>,<25.5,0,0>,4
			texture { LocoTex }
			translate <0,0,0>
		}
		cylinder { // lower end cyl-2
			<-1.5,0,0>,<25.5,0,0>,4
			texture { LocoTex }
			translate <0,0,-11>
		}
		cylinder { // upper drive cyl
			<24,0,0>,<78,0,0>,1.6
			texture { PolishedSteelTex }
			translate <0,0,0>
		}
		cylinder { // lower drive cyl
			<24,0,0>,<90,0,0>,2.4
			texture { PolishedSteelTex }
			translate <0,0,-11>
		}
	}

//===============================================
//             Coal Car
//===============================================

#declare CMainBox =
#declare Roundness = .15 // range 0 to .5, larger = more rounded
#include "GShapes.inc"
object { RoundedBox
	scale <200,54,76>
	translate <120,0,68>
	texture { LocoTex }
}
#declare CCarriage =
	box {
		<0,-20,13>,<240,20,31>
		texture { LocoTex }
	}

#declare CoalCar = // origin at connection to locomotive
	union {
		object { CMainBox }
		object { CCarriage }
		object { SmallWheelAssy translate <36,0,0> }
		object { SmallWheelAssy translate <66,0,0> }
		object { SmallWheelAssy translate <168,0,0> }
		object { SmallWheelAssy translate <204,0,0> }
	}

//===============================================
//             Assembly
//===============================================

#declare Locomotive =
	union {
		object { Cockpit translate <25*Feet,0,0> }
		object { BoilerAssy }
		object { ChassisAssy translate <0,0,0> }
		object { FrontChassisAssy translate <18,0,0> }
		object { HeadLamp translate <0,0,BoilerHt+24> }
		object { NumberPlate translate <0,0,BoilerHt+8> }
		object { DriveUnit translate <10,-30,44> }
		object { DriveUnit translate <10,30,44> }
		object { DriveLinkageRH translate <114,24,24> }
		object { DriveLinkageRH transform InverseY translate <114,-24,24> }
		object { CoalCar translate <410,0,0> }
	}

