
// Glenn's Pistol POV-Ray Scene File
// This file does not render.  #include "Pistol.inc" in another .pov file
// first concept: 31-May-97 last update: 31-May-97
// copyright Glenn McCarter 1997

//
// A .38 Snub Nose Police Special, "Revolver38"
// and being fired, "Revolver38Flash"
//
// Intended scale is English system (inches)
// Pistol stands in XY plane, origin somewhere near trigger
// +X is towards the rear of the gun
// Uses RH coordinate reference system


//===============================================
//             Variables
//===============================================

#declare BarrelLength = 2.8

//===============================================
//             Textures
//===============================================

#declare GunTex =
	texture {
		pigment { color rgb<0.1,0.1,0.2> }
		normal { bumps .12 scale <.04,.004,.004> }
		finish {
//			ambient 0.25
//			diffuse .94
			metallic .5
			brilliance .9
			phong .99
			phong_size 60
			specular 0.96
			roughness .1
			reflection .2
		}
	}

#declare HandleTex =
	texture {
		pigment { color rgb<0.42,0.33,0.10> }
		finish {
			ambient 0.1
			specular 0.9
			roughness .01
		}
	}

#declare ShinyBulletTex =
	texture {
		pigment { color rgb<0.8,0.8,0.8> }
		finish {
			ambient 0.1
			specular 0.9
			roughness .05
		}
	}


//===============================================
//             Objects
//===============================================


#declare BarrelAssy = // origin at end of barrel
	union {
		difference { // cutout bore
			cylinder { // main barrel
				<0,0,0>,<BarrelLength,0,0>,.38/2+.2
				texture { GunTex }
			}
			cylinder { // inner bore
				<-.5,0,0>,<3.5,0,0>,.38/2
				texture { GunTex }
			}
		} // end of difference
		torus { // barrel end, around Y-axis
			.38/2+.1, 0.1
			texture { GunTex }
			rotate <0,0,90>
			scale <.3,1,1>
			translate <0,0,0>
		}
		box { // top box 1
			<0,-.18,0>,<BarrelLength+2,.18,.22>
			texture { GunTex }
			translate <.1,0,.3>
		}
		box { // top box 2
			<0,-.13,0>,<BarrelLength+2.5,.13,.15>
			texture { GunTex }
			translate <.1,0,.60>
		}
		box { // top box support fwd
			<0,-.10,0>,<.4,.10,.13>
			texture { GunTex }
			translate <.1,0,.5>
		}
		box { // top box support mid
			<0,-.10,0>,<.4,.10,.13>
			texture { GunTex }
			translate <.9,0,.5>
		}
		box { // top box support rwd
			<0,-.10,0>,<.4,.10,.13>
			texture { GunTex }
			translate <1.7,0,.5>
		}
		box { // gunsight
			<0,-.08,0>,<.3,.08,.2>
			texture { GunTex }
			translate <.2,0,0.68>
		}
		cylinder { // under rod 1
			<0,0,0>,<-1.1,0,0>, .12
			texture { GunTex }
			translate <BarrelLength,0,-.6>
		}
		cylinder { // under rod 2
			<0,0,0>,<-.4,0,0>, .16
			texture { GunTex }
			translate <BarrelLength-0.8,0,-.6>
		}
		sphere { // under rod end cap
			<-.4,0,0>, .16
			texture { GunTex }
			translate <BarrelLength-0.8,0,-.6>
		}
	} // end union

#declare BulletChamber =
	union {
		difference { // cutout holes from revolver
			#declare CylRad = 1
			cylinder {
				<0,0,0>,<1.4,0,0>,CylRad
				texture { GunTex }
			}
			#declare RotX = 0
			#while ( RotX < 360 )
				cylinder { // bullet hole
					<-0.2,0,0>,<1.2,0,0>,.40/2
					texture { GunTex }
					translate <0,0,CylRad-.3>
					rotate x*RotX
				}
				#declare RotX = RotX + 360/6
			#end
			#declare RotX = 360/12 // initial offset
			#while ( RotX < 360 )
				cylinder { // exterior round notches
					<-0.2,0,0>,<0.9,0,0>,.4
					texture { GunTex }
					translate <0,0,CylRad+.3>
					rotate x*RotX
				}
				sphere { // exterior round notch ends
					<0.9,0,0>,.4
					texture { GunTex }
					translate <0,0,CylRad+.3>
					rotate x*RotX
				}
				#declare RotX = RotX + 360/6
			#end
		} // end difference
		#declare RotX = 0
		#while ( RotX < 360 )
			sphere { // bullets
				<0,0,0>,.38/2
				texture { ShinyBulletTex }
				scale <2,1,1>
				translate <.35,0,CylRad-.3>
				rotate x*RotX
			}
			#declare RotX = RotX + 360/6
		#end
	}

#declare Chassis = // origin at barrel base
	union {
		difference { //
			superellipsoid { // main chamber
				<.1,.1>
				texture { GunTex }
				scale <1.7,.43,1.1>
				rotate <0,0,0>
				translate <1.4,0,0>
			}
			box { // cutout for bullet chamber
				<0,-.8,-1.0>,<1.5,.8,1.0>
				texture { GunTex }
				translate <.2,0,0>
			}
			cylinder { // front lower notch LH
				<0,0,0>,<1,0,0>,.15
				texture { GunTex }
				translate <-.5,-.5,-.4>
			}
			cylinder { // front lower notch RH
				<0,0,0>,<1,0,0>,.15
				texture { GunTex }
				translate <-.5,.5,-.4>
			}
		} // end chamber difference
		sphere { // bullet chamber guard
			<0,0,0>,.85
			texture { GunTex }
			scale <1.4,1,1>
			clipped_by { box { <0,-1,-1>,<1,1,1> } }
			translate <1.7,0,0>
		}
		superellipsoid { // chamber top
			<.06,.06>
			texture { GunTex }
			scale <1.2,.27,.15>
			rotate <0,0,0>
			translate <1.3,0,1.06>
		}
		cylinder { // upper rear screw
			<0,-0.6,0>,<0,0.6,0>,.19
			texture { GunTex }
			translate <2.7,0,1.0>
		}
		difference { // subtract screw slot
			sphere { // upper rear screw cap LH
				<0,0,0>,.19
				texture { GunTex }
				scale <1,.3,1>
				translate <2.7,-0.6,1.0>
			}
			box {
				<-.04,-.1,-.3>,<.04,.1,.3>
				texture { GunTex }
				rotate <0,30,0>
				translate <2.7,-0.6,1.0>
			}
		} // end difference
		difference { // subtract screw slot
			sphere { // upper rear screw cap RH
				<0,0,0>,.19
				texture { GunTex }
				scale <1,.3,1>
				translate <2.7,0.6,1.0>
			}
			box {
				<-.04,-.1,-.3>,<.04,.1,.3>
				texture { GunTex }
				rotate <0,30,0>
				translate <2.7,0.6,1.0>
			}
		} // end difference
		cylinder { // rear rivet
			<0,-0.5,0>,<0,0.5,0>,.11
			texture { GunTex }
			translate <2.8,0.0,-.2>
		}
		sphere { // rear rivet cap RH
			<0,0,0>,.11
			texture { GunTex }
			translate <2.8,-0.5,-.2>
		}
		difference { // rear gunsight
			box { // gunsight
				<0,-.16,0>,<.1,.16,.3>
				texture { GunTex }
				translate <2.4,0,1.15>
			}
			box { // gunsite notch
				<-.5,-.04,-.01>,<.5,.04,.4>
				texture { GunTex }
				translate <2.4,0,1.15+.1>
			}
		} // end gunsight difference
	} // end chamber union

#declare HandleAssy =
	union {
		superellipsoid { //
			<.2,.2>
			scale <.8,.43,1.3>
			texture { GunTex }
		}
		superellipsoid { // handle
			<.2,.2>
			scale <.9,.52,1.5>
			translate <0,0,-1.5>
			texture { HandleTex }
		}
	} // end of union

#declare Trigger =
	difference {
		intersection {
			box { //
				<0,-.1,0>,<2,.1,-2>
				texture { GunTex }
			}
			cylinder {
				<0,-.2,0>,<0,.2,0>,1.4
				texture { GunTex }
			}
		} // end of intersection
		cylinder {
			<0,-.22,-.3>,<0,.22,-.3>,1.0
			texture { GunTex }
		}
		cylinder { // chops off end
			<0,-.23,-1.3>,<0,.23,-1.3>,0.5
			texture { GunTex }
		}
		translate <-0.4,0,1.3> // origin at trigger tip
		rotate <0,-30,0>
	}

#declare TriggerGuard =
	union {
		cylinder { // upright
			<0,0,.2>,<0,0,-.4>,0.08
			texture { GunTex }
			scale <1,3,1>
		}
		torus {
			.5,.08
			texture { GunTex }
			clipped_by { box { <-1,-.4,-1>,<0,.4,0> } }
			scale <1,3,1>
			translate <.5,0,-.4>
		}
		cylinder { // lower
			<0,0,0>,<1.7,0,0>,0.08
			texture { GunTex }
			scale <1,3,1>
			translate <.5,0,-.9>
		}
	}

#declare Hammer = // origin at cyl rad
	union {
		cylinder {
			<0,-.15,0>,<0,.15,0>,0.17
			texture { GunTex }
		}
		box {
			<0,-.15,-.17>,<1.2,.15,.17>
			texture { GunTex }
			rotate <0,120,0>
		}
	}

#declare FlashTri = // gun firing flash flare
		triangle {
			<0,.2,0>,<0,-.2,0>,<1,0,0>
			texture {
				pigment {
					gradient x
					color_map {
						[ 0.0 color rgbt<3,3,3,.2> ]
						[ 0.2 color rgbt<3,3,1,.2> ]
						[ 1.0 color rgbt<3,.5,.2,1> ]
					}
				}
			}
		}

#declare FS = seed(10737) // random number seed
#declare SmallFlash =
	union {
		#declare FDeg = 0
		#while ( FDeg < 360 )
			object { FlashTri scale <rand(FS)*5+2,1.6,1> rotate <0,0,FDeg> }
			#declare FDeg = FDeg + 45
		#end
		rotate <0,90,0> //set it upright
		translate <-BarrelLength-1,0,0> // move it in front of barrel
	}

#declare Revolver38 =
	union {
		object { Chassis}
		object { BulletChamber translate <.2,0,0> }
		object { BarrelAssy translate <-BarrelLength+.1,0,.6> }
		object { HandleAssy rotate <0,-22,0> translate <2.7,0,-1.2> }
		object { Trigger translate <1.3,0,-2.0> }
		object { TriggerGuard translate <.5,0,-1.4> }
		object { Hammer translate <3.5,0,1.1> }
	}

#declare Revolver38Flash =
	union {
		object { Revolver38 }
		object { SmallFlash }
	}

