
// Glenn's StreetLight POV-Ray Scene File
// This file does not render.  #include "StreetLight.inc" in another .pov file
// first concept 27-May-97 last update 28-May-97
// copyright 1997 Glenn McCarter

// An old street light mounted on a wooden pole
// Intended scale is English system (inches)
// Uses RH coordinate system
// Origin is at center of base
// Light is at x=36
//
// StreetLightA is the area_light version (takes longer to render)

// Declarations ---------------------------------------
// #declare these in your file to set the variables:
// #declare SBrightness = 1.0
// #declare SDistance = 8*Feet


//===============================================
//             Textures
//===============================================

#declare ShadeTex =
  texture {
    pigment { color <.34,.25,.11> }
		normal { granite .3 scale .15 }
		finish { ambient .15 diffuse .3 specular .15 roughness .02 }
  }
#declare SteelColor = color rgb <0.66, 0.48, 0.56>
#declare ArmTexture =
	texture {
		pigment { color SteelColor }
		normal { bumps 0.02 scale <.9,.2,.2> }
		finish {
			ambient 0.1
			brilliance 4
			diffuse 0.5
			metallic
			specular 0.95
			roughness .005
			reflection 0.4
		}
	}

//===============================================
//             Objects
//===============================================

#declare Bulb =
	union {
	  light_source {//main filament light
  	  <0,0,0>
    	colour rgb <SBrightness*1.3, SBrightness*1.2, SBrightness*1.0>
			fade_distance SDistance
			fade_power 1
	    spotlight
  	  point_at <0, 0, -4>
    	radius 28    // degrees fully lit (*2)
	    falloff 76   // degrees no lighting (*2)
  	  tightness 1
	    looks_like {
				intersection {
	  	    sphere {
  	  	    <0,0,0>, 5
	  	      texture {
  	  	      pigment { color rgbf<.98,1,.99,.93> }
    	  	    finish { ambient .56 diffuse .2 refraction 1 ior 1.3 caustics 1 reflection 0.2 }
      	  	}
      		}
	  	    sphere {
  	  	    <0,0,0>, 4.8
	  	      texture {
  	  	      pigment { color rgbf<.98,1,.99,.93> }
    	  	    finish { ambient .56 diffuse .2 refraction 1 ior 1.3 caustics 1 reflection 0.2 }
      	  	}
						inverse
      		}
				}
	    }
	  }
		light_source {//throws sharp rim shadow
  	  <0,0,0>
    	colour rgb <SBrightness*.5, SBrightness*.5, SBrightness*.4>
			fade_distance SDistance
			fade_power 1
	    spotlight
  	  point_at <0, 0, -4>
    	radius 73    // degrees fully lit (*2)
	    falloff 76   // degrees no lighting (*2)
  	  tightness 1
	    fade_distance 8*Feet
	  }
		cylinder {//bulb base
			<0,0,5>,<0,0,8>,.35
			texture {
				pigment { color rgb<.9,.9,.3> }}
      	finish { ambient .99 diffuse .2 }
		}
	}
#declare BulbA = //substitute bulb with Area Light
	union {
	  light_source {//main filament light
  	  <0,0,0>
    	colour rgb <SBrightness*1.3, SBrightness*1.2, SBrightness*1.0>
			fade_distance SDistance
			fade_power 1
			area_light <0,6,0>, <6,0,0>, 3,3
	    spotlight
  	  point_at <0, 0, -4>
    	radius 28    // degrees fully lit (*2)
	    falloff 76   // degrees no lighting (*2)
  	  tightness 1
	    looks_like {
  	    sphere {
    	    <0,0,0>, 5
	        texture {
  	        pigment { color rgbf<1,1,.92,.85> }
    	      finish { ambient .99 diffuse .2 reflection .5 }
      	  }
      	}
	    }
	  }
		light_source {//throws sharp rim shadow
  	  <0,0,0>
    	colour rgb <SBrightness*.5, SBrightness*.5, SBrightness*.4>
			fade_distance SDistance
			fade_power 1
	    spotlight
  	  point_at <0, 0, -4>
    	radius 73    // degrees fully lit (*2)
	    falloff 76   // degrees no lighting (*2)
  	  tightness 1
	    fade_distance 8*Feet
	  }
		cylinder {//bulb base
			<0,0,5>,<0,0,8>,3.5
			texture {
				pigment { color rgb<.9,.9,.3> }}
      	finish { ambient .99 diffuse .2 }
		}
	}

#declare Shade = // origin at bulb
	union {
		cone { //inner surface
			<0,0,0>,15,<0,0,7>,12
			open
			texture {
				pigment { color rgb <1,1,1> }
				finish { ambient .84 }
			}
		}
		cone { //outer surface
			<0,0,0>,15.5,<0,0,7.5>,12.5
			open
			texture { ShadeTex }
		}
		disc { //cooling ring topside
			<0,0,7.4>,<0,0,7.5>,11,8
			texture { ShadeTex }
		}
		disc { //cooling ring underside
			<0,0,7.3>,<0,0,7.45>,11.05,7.95
			texture {
				pigment { color rgb <1,1,1> }
				finish { ambient 0.7 }
			}
		}
		cone { //upper surface
			<0,0,7.4>,7,<0,0,17>,5
			texture { ShadeTex }
		}
	}

#declare Arm =
	union {
		cylinder { // lamp support
			<0,0,0>,<36,0,0>,3
			texture {
				pigment { color rgb<.8,.9,.9> }
				finish { metallic specular .8 roughness .01 }
			}
		}
	}

#declare WoodPole =
	cylinder { // wood pole
		<0,0,0>,<0,0,38*Feet>,6
		texture {
			GWood
		}
	}

//===============================================
//             Assemblies
//===============================================

#declare HeadAssy =
	object {
		union {
			object { Bulb translate <0,0,3>}
			object { Shade }
		}
		translate <0,0,-11> //new origin at pivot point
	}

#declare HeadAssyA =
	object {
		union {
			object { BulbA translate <0,0,3>}
			object { Shade }
		}
		translate <0,0,-11> //new origin at pivot point
	}

#declare StreetLight = // base at origin, light at x=36
	union {
		object { WoodPole }
		object { Arm translate <0,0,36*Feet> }
		object { HeadAssy translate <36,0,35.5*Feet> }
	}

#declare StreetLightA = // base at origin, light at x=36
	union {
		object { WoodPole }
		object { Arm translate <0,0,36*Feet> }
		object { HeadAssyA translate <36,0,35.5*Feet> }
	}
