
// Glenn's "Velocity" POV-Ray Scene File
// created 21-May-97 for the May/June 1997 Internet Ray Tracing Competition
// last update 24-June-97
// copyright 1997 Glenn McCarter

// NOTE: these files have many embedded tabs.
// To best viewing, use the POV-Ray for Windows editor,
// and set Editor | Tabs | Real Tabs, with tab size 2.

#include "colors.inc"
#include "shapes.inc"
#include "shapes2.inc"
#include "textures.inc"
#include "GIncludeRH.inc"
#include "Buildings.inc"
#include "Weeds.inc"
#include "Railroad.inc"
#include "RRSign.inc"
#include "Locomotive.inc"
#include "LocoSteam.inc"
#include "BlobMan.inc"
#include "HF1.inc"
#include "AllText.inc"

#version 3.0
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 5
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,    -0.2,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
/*   // Focal Blur section: uncomment to enable focal blur
  blur_samples 6
  aperture .05    //lower value = wider range in focus
  focal_point <0,0,0>
	confidence .995
	variance 1/128
*/   // end focal blur
  location  <-144, 120, 12>
  look_at   <0, 0, 60>
  angle 100
}
#declare Cockpit_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.1,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
/*   // Focal Blur section: uncomment to enable focal blur
  blur_samples 6
  aperture .05    //lower value = wider range in focus
  focal_point <0,0,0>
	confidence .995
	variance 1/128
*/   // end focal blur
//  location  <-100, 170, 60> // near car
//  look_at   <-60, 150, 50>
//  location  <-185, -280, 50> // far car side view
//  look_at   <-98, -280, 50>
//  location  <-200, -260, 50> // far car pullaway
//  look_at   <-98, -280, 40>
//  location  <-90, -80, 50> // far car front view
//  look_at   <-90, -280, 50>
//  location  <-126, -270, 54> // gun side
//  look_at   <-100, -270, 54>
//  location  <-100, -240, 54> // gun front
//  look_at   <-100, -270, 54>
//  location  <-120, -240, 54> // gun cool view 1
//  look_at   <-109, -270, 54>
//  location  <-138, -265, 54> // gun cool view 2
//  look_at   <-109, -283, 54>
  location  <-157, -260, 47> // 50-deg render view
  look_at   <-109, -283, 53>
//  angle 60
  angle 50
}

#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  angle 40
//    location <-180, 120, 12> //untilted render view
//	  look_at   <0, 0, 60>
//    location <-240, 260, 62> //near render view
//		look_at   <0, 0, 20>
//    location <-500, 500, 100> //overall scene
//		look_at   <0, 0, 20>
//    location <-300, 300, 50> //road height
//		look_at   <-60, 0, 20>
//		location <900,700,300> // overall scene reverse angle (close)
//    look_at <0, 150, 150>
//		location <1500,1100,400> // overall scene reverse angle (far)
//    look_at <0, 150, 150>
//		location <-100,100,36> // near origin
//    look_at <0, 0, 0>
//		location <-36,82,16> // RR ties closeup near origin
//    look_at <-24, 24, -6>
//		location <200,750,12> // locomotive overall side view
//    look_at <220, 0, 40>
//		location <460,550,55> // Coal car side view
//    look_at <500, 0, 60>
//		location <-200,300,48> // locomotive 3/4 view
//    look_at <140, 0, 60>
//		location <-200,300,85> // locomotive steam 3/4
//    look_at <40, 0, 120>
//		location <100,700,120> // locomotive steam side
//    look_at <100, 0, 140>
//		location <0,300,120> // locomotive steam closeup
//    look_at <0, 0, 130>
//		location <-600,0,120> // locomotive steam front
//    look_at <100, 0, 140>
//		location <-200,0,150> // locomotive top front view
//    look_at <140, 0, 80>
//		location <200,300,80> // locomotive cockpit
//    look_at <330, 30, 60>
//		location <290,170,90> // locomotive cockpit closeup
//    look_at <330, 30, 75>
//		location <-200,300,150> // locomotive top of boiler
//    look_at <140, 0, 80>
//		location <-100,100,86> // front of locomotive boiler
//    look_at <0, 0, 86>
//		location <-60,240,28> // locomotive front wheels and front carriage
//    look_at <-10, 28, 48>
//		location <-140,140,55> // locomotive front carriage assy 3/4
//    look_at <-20, 28, 48>
//		location <0,240,55> // locomotive front carriage assy side
//    look_at <0, 28, 48>
		location <171,320,38> // locomotive drive train side view
    look_at <170, 28, 38>
		location <0,200,38> // locomotive drive train 3/4
    look_at <170, 28, 38>
//		location <-220,66,86> // rrxing sign
//    look_at <-60, 66, 40>
//		location <-160,100,16> // rrxing splinters
//    look_at <-128, 64, 20>
//		location <-180,100,16> // rrxing sign base
//    look_at <-132, 64, 8>
//		location <-120,450,80> // car frontish view
//    look_at <-60, 150, 0>
//		location <-170,290,30> // car front bumper
//    look_at <-60, 210, 10>
//		location <-70,220,160> // car front bumper top viw
//    look_at <-60, 210, 0>
//		location <-300,150,60> // car side view
//    look_at <-60, 150, 40>
//		location <-250,250,60> // car 3/4 view
//    look_at <-60, 170, 20>
//		location <-150,320,60> // car front end (7/8 view)
//    look_at <-20, 150, 20>
//		location <-160,-20,30> // car rear 3/4
//    look_at <-66, 100, 24>
//		location <-110,176,59> // car cockpit
//    look_at <-60, 150, 44>
//		location <-140,176,49> // car cockpit door
//    look_at <-60, 150, 36>
//		location <-140,100,20> // car rear wheel
//    look_at <-60, 100, 20>
//		location <-140,260,29> // car front end closeup
//    look_at <-46, 180, 20>
//		location <-120,170,20> // car front wheel closeup
//    look_at <-80, 185, 12>
//		location <-80,180,80> // car cherrytop
//    look_at <-50, 150, 66>
//		location <-100,100,60> // building overall
//    look_at <-80*Feet, 50*Feet, 12*Feet>
//		location <-52*Feet,34*Feet,80> // building closeup
//    look_at <-80*Feet, 60*Feet, 8*Feet>
  }

camera {
//    Special_Cam
//    Cockpit_Cam
    Render_Cam
  }

//===============================================
//             Lighting
//===============================================

#declare SBrightness = 1.4
#declare SDistance = 12*Feet
#include "StreetLight.inc"
object {StreetLight rotate z*-90 translate <40*Feet,12*Feet,-18*Feet> } // far
//object {StreetLight rotate z*-90 translate <-13*Feet,12*Feet,-18*Feet> } // near
object {StreetLightA rotate z*-90 translate <-13*Feet,12*Feet,-18*Feet> } // near area_light

#declare CopSpot1 = // from front of cop car
  light_source {
    <-48,-140,50>
    colour rgb <1, 1, 1>
    spotlight
		fade_distance 80
		fade_power 1
    point_at <-100,-320,54>
    radius 13    // degrees fully lit (*2)
    falloff 28   // degrees no lighting (*2)
    tightness 1
  }
object { CopSpot1 }
#declare CopSpot2 = // from rear side of cop car
  light_source {
    <-200,-500,60>
    colour rgb <.7, .7, .7>
    spotlight
		fade_distance 80
		fade_power 1
    point_at <-100,-320,54>
    radius 13    // degrees fully lit (*2)
    falloff 28   // degrees no lighting (*2)
    tightness 1
  }
//object { CopSpot2 }

//===============================================
//             Environment
//===============================================

//background { color rgb <0.05, 0.1, 0.3> }
//  sky_sphere {S_Cloud5  }
//object {O_Cloud1}
//object {GroundPlaneTan translate z*-0}
	sky_sphere {
		pigment {
			gradient z
			color_map {
				[0 color rgb<0,0,.2> ]
				[1 color rgb<0,0,0> ]
			}
		}
	}

/*
fog {
	distance 300
	color rgb<.05,.05,.1>
}
*/
/*
atmosphere {
	type 3
		samples 10
		distance 300
		scattering 0.0005
//		color rgbf<0,0,0,.5>
	}
*/


//===============================================
//             Variables
//===============================================

// -------- INSET PICTURE -------------
// camera: cockpit_cam
// lighting: CopSpot2 on
// misc: small cherrytop flare on in PackardCar.inc
//       big cherrytop beam off in PackardCar.inc
//       gunfiring off in blobman.inc
//       inset balloon on in AllText.inc
//       cop car x8 rot
// revise pose angles

// -------- FINAL RENDER -------------
// camera: render_cam
// lighting: CopSpot2 off
// misc: small cherrytop flare off in PackardCar.inc
//       big cherrytop beam on in PackardCar.inc
//       gunfiring on in blobman.inc
//       inset balloon off in AllText.inc
//       cop car x4 rot
// revise pose angles


//===============================================
//             Objects
//===============================================

#declare InsetBox = // image on XZ plane
	union {
		box {
			<0,0,0>,<33,.03,25>
			texture { pigment { color rgb<1,1,1> } finish { ambient 1 } }
			texture {
				pigment {
					image_map { // default mapping onto XY plane
						tga "Inset.tga"
						once
					}
				}
				scale <32,24,1> rotate <90,90,0> rotate <0,-90,0> translate <-1,1,1>
				finish { ambient 1 }
		}
		}
		box { // backside is nearly black
			<-.01,.02,-.01>,<33.01,.031,25.01>
			texture { pigment { color rgb<0,0,.1> } }
		}
		no_shadow
	}
#declare InsetCirc = // image is on XZ plane
	union {
		cylinder {
			<8,0,25>,<8,.02,25>,24.2
			texture { pigment { color rgb<1,1,1> } finish { ambient 1 } }
			texture {
				pigment {
					image_map { // default mapping onto XY plane
						tga "Inset.tga"
						once
					}
				}
				scale <38,31,1> rotate <90,0,0> translate <-2.0,1.0,0.8>
				finish { ambient .9 }
			}
		}
		cylinder { // outer white rim
			<8,0.01,25>,<8,.03,25>,25
			texture { pigment { color rgb<1,1,1> } finish { ambient 1 } }
		}
		cylinder { // backside is nearly black
			<8,.02,25>,<8,.031,25>,25.01
			texture { pigment { color rgb<0,0,.1> } }
		}
		no_shadow
	}

#declare Bullet = // .44 caliber
	sor { // point at <0,0,0>, extends in +y, spun around y-axis
	  10,
    <0.00, -0.10>
    <0.00, 0.00>
    <0.06, 0.10>
    <0.09, 0.20>
		<0.12, 0.30>
		<0.14, 0.40>
		<0.15, 0.50>
    <0.17, 0.60>
    <0.22, 1.80>
    <0.22, 2.10>
		texture {
			pigment { color rgb<.8,.8,.8> }
			normal { bumps .8 scale <.1,1,.1> }
			finish { specular .9 roughness .05 reflection .15 }
		}
  }

#declare SBulletTex =
	texture {
		pigment {
			marble
			color_map {
				[ 0.0  color rgbt<0.5,0.5,0.5,1> ]
				[ 0.3  color rgbt<0.5,0.5,0.5,1> ]
				[ 0.5  color rgbt<0.15,0.15,0.15,.3> ]
				[ 0.6  color rgbt<0.15,0.15,0.15,.3> ]
				[ 0.7  color rgbt<0.5,0.5,0.5,1> ]
				[ 1.0  color rgbt<0.5,0.5,0.5,1> ]
			}
		}
	}

#declare BColor = color rgb<.532,.532,.532>  // color of filter
#declare BFX = 22         // blurred area X scale
#declare BFY = .7         // blurred area Y scale
#declare BStrength = .5  // 0=clear, 1=opaque at center
#declare BXMax = .12      // Percentage of distance along X-axis
                         // where color reaches max intensity
#declare BYSpread = .6   // Spread of the color in the Y-direction
                         // 0=soft fade, 1=full color throughout Y
#include "BlurFilt.inc"
#declare BulletBlur =
	object { FadeBlurFilter }

#declare SpeedingBullet =
	union {
		object { Bullet }
		object { BulletBlur translate <0,-.35,0> rotate <0,0,90> rotate y*135 }
	}


//===============================================
//             Object Transformations
//===============================================

#declare ShearXZn05 =
	transform {
  	matrix < 1, 0, 0, // shear along x-axis
             0, 1, 0,
           -.5, 0, 1,
             0, 0, 0 >
	}
#declare ShearXZn08 =
	transform {
  	matrix < 1, 0, 0, // shear along x-axis
             0, 1, 0,
           -.8, 0, 1,
             0, 0, 0 >
	}

#declare SLocomotive = // sheared along x-axis
  object { Locomotive transform ShearXZn05 }

#declare RimColor = color rgb<.68,.09,.09>
#include "PackardCar.inc"
object { SPackardCar rotate z*-65 translate <-55,217,2> } // near

#declare SteeringAngle = 35
#declare LFJounce = 2
#declare LRJounce = -4
#declare RRJounce = -4
#declare RimColor = color rgb<.06,.03,.16>
#include "PackardCar.inc"
#declare CopCarWithCop =
	union {
		object { BCopCar }
		object { Cop rotate <0,12,0> translate <75,-15,42> }
	}
object { CopCarWithCop rotate <4,-4,-105> translate <-55,-230,7> } // far


//===============================================
//             Object Placement
//===============================================

object { DistantMountains }
object { LocalRoad }
object { RailRoad }
object { SLocomotive translate <3*Feet,0,4> }
object { HaloSteam translate <-44+3*Feet,0,145> }
object { WheelSteam scale <44,16,16> rotate <20,10,0> translate <44+3*Feet,32,36> }
object { SpeedingBullet rotate <6,0,-163> translate <-142.5,118,13.5> }
object { RRSign rotate z*0 translate <-123,64,-3> } // near
object { RRSign rotate z*180 translate <132,-64,-12> } // far
object { Weeds2 rotate z*0 translate <-125,70,-4.5> } // base of RRSign
object { Weeds1 rotate z*40 translate <-138,106,1> } // near camera closest
object { WeedBlades1 rotate z*100 translate <-138,108,2> } // near camera closest
object { WeedStalks2 rotate z*160 translate <-110,121.5,-2.5> } // near LH side
object { WeedBlades1 scale <1,1,1.2> rotate z*32 translate <-113,122.5,3> } // near LH side
object { WeedBlades1 scale <1,1,0.8> rotate z*132 translate <-113.5,120,2.3> } // near LH side
object { WeedStalks2 rotate z*26 translate <-120,42,-4> } // RR ties
object { WeedStalks2 rotate z*53 translate <-130,36,-4> } // RR ties
object { WeedBlades1 rotate z*162 translate <-127,59,-4> } // behind sign
object { WeedBlades1 scale .8 rotate z*60 translate <-118,68,-3.6> } // LH of sign, small
object { Weeds2 rotate z*125 translate <-135,36,-4> } // RR ties RH
object { Weeds2 rotate z*60 translate <-126,36,-4> } // RR ties at rocks
object { Weeds1 rotate z*225 translate <-100,36,-2> } // RR ties near road
object { Bldg1 rotate z*180 translate <-70*Feet,40*Feet,0> } // near side
object { Bldg2 rotate z*180 translate <-60*Feet,-40*Feet,0> } // far side
object { InsetCirc scale <1,1,1> rotate <18,8,-125> translate <-90,132,33> }
object { AllText }


// TEST OBJECTS - DO NOT RENDER
//object { TestSphere scale 29 translate <0,10,0> }
//object { SCopCar rotate z*-55 rotate <0,-8,-25> translate <-50,210,0> } // near, tilted
//object { StdBulb100Watt translate <-11*Feet,18*Feet,6*Feet> } // for test only
//object { StdBulb100Watt translate <81*Feet,8*Feet,6*Feet> } // for test only
//object { InsetBox scale <1,1,1> rotate <18,8,-125> translate <-90,135,36> }
//object { Locomotive translate <3*Feet,0,4> }
// test cars; real cars are rendered above
//object { SPackardCar rotate z*-65 translate <-55,217,4> } // near
//object { CopCarWithCop rotate <8,0,-100> translate <-55,-230,7> } // far



