
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#declare ABCDE = 0
#declare False = 0
#declare True = 1
global_settings {
  adc_bailout 5/255
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 2.2
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 20
  number_of_waves 10
    radiosity {
        count 800                // Ensure that we get good, accurate samples
        error_bound 0.2          // And calculate lots of them.  (more important than count)
        gray_threshold 0.5
        distance_maximum 30       // Scene-dependant!
        low_error_factor 0.7     // force many extra samples to be calculated...
        nearest_count 9          // so we can average them together for smoothness
        minimum_reuse 0.01       // get quite tightly into corners
        brightness 3.3           // doesn't really matter.  Not used in final output.
        recursion_limit 1        // Try this = 2, but drop the count to maybe 300
   }
}
/*
#default {
  finish {  ambient .2
            diffuse 0.6
            reflection 0.01
            phong 0
            phong_size 0
         }
}
*/
light_source{ <0, 9, -1> color White }
camera{ location <0 , 3.0 ,-10> look_at < 0.0 , 1.0 , 0.0>}

#declare HelmetFin =
finish { ambient 0.3 diffuse 0.7 reflection 0.15
         brilliance 8 specular 0.8 roughness 0.1}
#declare HelmetNorm = normal { bumps -0.5 scale <1, 0.001, 0.001>}

#declare HelmetTex1 =
       texture { pigment { color LightGray }
       finish { HelmetFin }
       normal { HelmetNorm }
}
#declare HelmetTex2 =
       texture { pigment { color BrightGold }
       finish { ambient 0.2 diffuse 0.7 specular 0 roughness 0.1}
       normal { bumps -0.9 scale <1, 0.01, 0.01>}
}
#declare HelmetTex3 =
       texture { pigment { color CoolCopper }
       finish { ambient 0.3 diffuse 0.7 specular 0 roughness 0.1}
       normal {HelmetNorm }
}
#declare HelmetTex4 =
       texture { pigment { color Bronze }
       finish { ambient 0.3 diffuse 0.7 specular 0 roughness 0.1}
       normal {HelmetNorm }
}

#declare BackTex1 =
       texture {
         pigment { bozo turbulence 8
           color_map
             {
               [0.00 color Mica ]
               [0.50 color BakersChoc ]
               [0.50 color NewMidnightBlue ]
               [0.60 color Silver ]
               [0.60 color VioletRed ]
               [1.00 color Quartz ]
             }
           scale .2
         }

       finish { ambient 0.2 diffuse 0.2  }
       normal { bumps -0.7 scale <1, 0.01, 0.01>}
}
#declare BodyTex1 =
       texture { pigment { color Red }
       finish { ambient 0.2 diffuse .2}
       normal { dents 0.7 scale <1, 0.1, 0.1>}
}

#declare PentTex =
texture {
pigment {
    marble turbulence 2.3
    color_map {
    [0.0, 0.8 color Black  color LBlue]
    [0.8, 0.9 color LBlue  color Vein]
    [0.9, 1.0 color Vein   color Black]
    }
    }
finish { ambient .1 diffuse .5 reflection .75 metallic }
scale .2
}


#declare Apocalyps = texture
{
  pigment
  {
    bozo
    color_map
    {
      [0.00 color rgb<0.800, 0.000, 0.000>]
      [0.40 color rgb<0.400, 0.000, 0.400>]
      [0.40 color rgb<0.400, 0.000, 0.400>]
      [0.60 color rgb<0.000, 0.000, 0.200>]
      [0.60 color rgb<0.000, 0.000, 0.200>]
      [1.00 color rgb<0.000, 0.000, 0.000>]
    }
  }
scale .1
finish { ambient 0.3 diffuse 0.7 specular 0 roughness 0.1}
normal { bumps -0.5 scale <1, 0.001, 0.001>}
}

#declare BloodSky = texture
{
  pigment
  {
    bozo
    turbulence 0.5
    color_map
    {
      [0.00 color rgb<0.898, 0.698, 0.000>]
      [0.50 color rgb<0.298, 0.200, 0.000>]
      [0.50 color rgb<0.600, 0.024, 0.000>]
      [0.60 color rgb<0.898, 0.698, 0.000>]
      [0.60 color rgb<0.600, 0.024, 0.000>]
      [1.00 color rgb<0.600, 0.024, 0.000>]
    }
  }
//  scale <3000.0, 850.0, 2000.0>
scale .25
}


#declare Black_Marble = pigment {
    marble
    turbulence 1.0
    color_map {
	[0.0 0.3   color red 0.3 green 0.3 blue 0.3
		   color red 0.45 green 0.45 blue 0.45]
	[0.3 0.7   color red 0.45 green 0.45 blue 0.45
		   color red 0.6 green 0.6 blue 0.6]
	[0.7 0.9   color red 0.6 green 0.6 blue 0.6
		   color White]
	[0.9 1.001 color White color White]
    }
}


///////////////////////////////////////////////////



#declare Fire =
texture {
    pigment {
        gradient x*0.00+ y*1+ z*0
        color_map {
            [ 0.000 rgb <1.000,1.000,1.000> ]
            [ 0.080 rgbf <0.980,1.000,0.016,0.08> ]
            [ 0.290 rgbf <1.000,0.737,0.012,0.40> ]
            [ 0.530 rgbf <1.000,0.157,0.008,0.67> ]
            [ 0.790 rgbf <1.000,1.000,1.000,1.00> ]
            [ 1.000 rgbf <1.000,1.000,1.000,1.00> ]
        }
        phase 0.850
        turbulence <0.300, 0.250, 0.300>
        omega 0.800
        scale <2.500, 18.500, 2.500>
        scale .2
    }
    finish { ambient 1 diffuse .1 phong 0}
    normal { ripples turbulence 1.8 scale <1, 10, 0.01>}
    scale <3.0, 9.000, 4.000>
    translate <-8.000, -45.000, -8.000>
}


