
#ifndef (ABCDE)
#include "defaults.inc"
light_source{ <0, 5, -10> color White }

#end
//============================================================
#declare A1Tex = texture {HelmetTex1 }
#declare A2Tex = texture {HelmetTex2 }
#declare A3Tex = texture { HelmetTex3 }
#declare A4Tex = texture { HelmetTex4 }
#declare B1Tex =
   texture {pigment { color CoolCopper }
   finish { ambient 0.3 diffuse 0.7 specular 0 roughness 0.1}
   normal { bumps -0.8 scale <1, 0.001, 0.001>}
}
#declare B2Tex =
   texture {pigment { color Bronze2 }
   finish { ambient 0.3 diffuse 0.7 specular 0 roughness 0.1}
   normal { bumps -0.5 scale <1, 0.001, 0.001>}
}
#declare B3Tex = texture {B1Tex}

#declare CanTop =
object {
lathe {
   linear_spline
   5,
   <0.99, 0.805>,
   <0.795, 0.595>,
   <0.40, 0.395>,
   <0.205, 0.20>,
   <0.205, 0.005>
   sturm
}
texture { B1Tex}
scale 2
}
#declare CanBase =
object {
lathe {
   linear_spline
   15,
   <0.195, 0.995>,
   <0.20, 0.805>,
   <0.405, 0.795>,
   <0.405, 0.595>,
   <0.60, 0.58>,
   <0.605, 0.405>,
   <0.79, 0.38>,
   <0.805, 0.20>,
   <0.985, 0.195>,
   <0.99, 0.00>,
   <0.225, 0.915>,
   <0.425, 0.705>,
   <0.63, 0.495>,
   <0.83, 0.295>,
   <0.95, 0.095>
   sturm
}
texture { B3Tex}
scale 2
}

#declare FlameCandleHalo =
   halo {
      linear
      max_value 1.0
      planar_mapping
      emitting
      turbulence 8
              color_map {
            [ 0.000 rgbf <0.000,0.000,0.00,0> ]
            [ 0.080 rgbf <0.980,1.000,0.016,0.18> ]
            [ 0.290 rgbf <1.000,0.997,0.012,0.50> ]
            [ 0.530 rgbf <1.000,0.157,0.008,0.77> ]
            [ 0.790 rgbf <1.000,0.900,0.000,0.00> ]
            [ 1.000 rgbf <0.000,0.000,0.000,1.00> ]
        }
         scale <3, 4, 3>
         translate < 0, 1, 0>
      samples 20}

#declare A1 =
object{
blob {   threshold 0.6
#declare Y = 0 #while (Y <= 150 )
  sphere { < 0,   0,    0>, 1, .2 translate < -1, Y/10, 0 > rotate < 0, Y*10, 0 >}
#declare Y = Y + 1 #end
}
texture {A1Tex}
scale .5
}
#declare A2 =
object{
blob {   threshold 0.6
#declare Y = 0 #while (Y <= 150 )
  sphere { < 0,   0,    0>, 1, .2 translate < -1, (Y/10)  , 0 > rotate < 0, (Y* (-10))+90, 0 >}
#declare Y = Y + 1 #end
}
texture {A2Tex}
scale .5
}
#declare A3 =
object{
blob {   threshold 0.6
#declare Y = 0 #while (Y <= 150 )
  sphere { < 0,   0,    0>, 1, .2 translate < 1, Y/10, 0 > rotate < 0, Y*10, 0 >}
#declare Y = Y + 1 #end
}
texture {A3Tex}
scale .5
}
#declare A4 =
object{
blob {   threshold 0.6
#declare Y = 0 #while (Y <= 150 )
  sphere { < 0,   0,    0>, 1, .2 translate < 1, (Y/10)  , 0 > rotate < 0, (Y* (-10))+90, 0 >}
#declare Y = Y + 1 #end
}
texture {A4Tex}
scale .5
}

#declare B1 =
union {
#declare Y = 0
#declare Cnt = 0 #while ( Cnt <= 3 )
  torus {  0.8,  0.2 translate < 0, Y, 0>}
#declare Y = Y + .2
#declare Cnt = Cnt + 1 #end
texture { B2Tex}
scale <.8, .5, .8 >
}
#declare CanStick =
union {
object { A1}
object { A2 }
object { A3 }
object { A4 }
#declare Y = 0
#declare Cnt = 0 #while ( Cnt <= 5 )
object { B1 translate < 0, Y, 0> }
#declare Y = Y + 1.45
#declare Cnt = Cnt + 1 #end
object { CanBase }
object { CanTop translate < 0, 6.8, 0> }
scale < .5, 1, .5>
scale .35
}



#declare FireCandle =
union {
object {  quartic {
                   < 4,   0,   0,   -3,  0,   0,   0,   0,   0,  0,
                     0,   0,   0,    0,  0,   0,   0,   0,   0,  0,
                     0,   0,   0,    0,  0,   1,   0,   0,   0,  0,
                     0,   0,   1,    0,  0>
                  } sturm hollow no_shadow
                texture {pigment {color Clear } finish  {ambient 1 diffuse 0}}
         halo{FlameCandleHalo }
         scale < .5, 1.5, .5 >
         translate < .1, 3.1, .1>}

object { CanStick translate < .3, 0, .1>}
}

//object {FirePot1 rotate < 0, 0, 0 > translate <-.1, -2.5, -.1> scale 3}
///*
object {FireCandle translate < -3.5, 0, -5>}
object {FireCandle translate <  3, 0, -5>}
object {FireCandle translate < -4, 0,  4>}
object {FireCandle translate <  3, 0,  4>}
//*/
//object { FireCandle/* rotate < -90, 0, 0 > */translate < 0,-1, -5 >}
