
#ifndef (ABCDE)
#include "defaults.inc"
#end
//============================================================

#declare Pot =
lathe {
   linear_spline
   12,
   <0.19, 0.795>,
   <0.585, 0.795>,
   <0.615, 0.725>,
   <0.595, 0.60>,
   <0.705, 0.505>,
   <0.805, 0.405>,
   <0.85, 0.20>,
   <0.86, 0.00>,
   <0.88, -0.21>,
   <0.905, -0.415>,
   <0.93, -0.59>,
   <0.95, -0.81>
   sturm
}

#declare FlamePotHalo =
   halo {
      linear
      max_value 1.0
      planar_mapping
      emitting
      turbulence .8
      colour_map {
         [0.00 color rgbt <0.5,0.3,0.0,0.2>]
         [0.20 color rgbt <0.4,0.3,0.0,0.8>]
         [0.20 color rgbt <0.3,0.3,0.0,0.8>]
         [0.60 color rgbt <0.2,0.2,0.0,0.7>]
         [0.75 color rgbt <1.0,0.8,0.0,0.3>]
         [0.90 color rgbt <1.0,0.8,0.6,0.5>]
         [0.95 color rgbt <1.0,1.0,0.0,-0.1>]
         [1.00 color rgbt <1.0,0.8,0.5,-2.0>]
     }
         scale <.1, 1. .1>
      samples 20}

#declare FirePot1 =
union {
object {  quartic {
                   < 4,   0,   0,   -4,  0,   0,   0,   0,   0,  0,
                     0,   0,   0,    0,  0,   0,   0,   0,   0,  0,
                     0,   0,   0,    0,  0,   1,   0,   0,   0,  0,
                     0,   0,   1,    0,  0>
                  } sturm hollow no_shadow
         texture {pigment {color Clear } finish  {ambient 1 diffuse 0}}
                 halo{FlamePotHalo }
         scale < .75, 3, .75 >
         translate < -.55, -1, 0>}
object { Pot
         texture { pigment { Black_Marble scale .1}
                   finish { ambient 0.3 diffuse 0.7 specular 0 roughness 0.1}
                   normal { bumps -0.5 scale <1, 0.001, 0.001>}
                 } translate < 0, -2.5, 0> }
scale .25
translate < .9, .75, 3.1>
}

//object {FirePot1 rotate < 0, 0, 0 > translate <-.1, -2.5, -.1> scale 3}
