
// Glenn's BlobHead POV-Ray Scene File
// first concept 30-May-97 last update 20-Aug-97
// copyright Glenn McCarter 1997
// This file does not render.  #include "BlobHead.inc" in another .pov file
//
// A head: uses a bitmap image for the face
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system

//================================================================
//      Remove this section -- only used for test renders!
//================================================================

/*
//#include "GRuler.inc"
#include "Colors.inc"
#include "Textures.inc"
#include "GIncludeRH.inc"
#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  location  <-28, -0, 0> // front view
  look_at   <0.000, 0.000, 0.000>
//  location  <-0, -26, 0> // side view
//  look_at   <0, 0, 0>
//  location  <-1, -1, 28> // top view
//  look_at   <0.000, 0.000, 4.000>
//  location  <-9, -4, 2.2> // eye closeup
//  look_at   <0.000, 0.000, 2.200>
//  location  <-7, -3, 0.0> // under nose
//  look_at   <-3.0, 0.0, 1.2>
//  location  <-15, 12, 4> // 3/4 on head RHS
//  look_at   <0.000, 0.000, 2.000>
//  location  <-15, -12, 4> // 3/4 view
//  look_at   <0.000, 0.000, 2.000>
	angle 40
}
camera { Render_Cam }
object {StdBulb60Watt translate <-40,80,70> }
object {StdBulb100Watt translate <-100,-60,80> }
//object {StdBulb50Watt translate <-40,80,-70> }
*/

//===============================================
//             Variable Declarations
//===============================================

#ifndef ( Eyes )
#declare EyeLeft = 0 // positive = eyes to the left
#declare EyeUp = 0 // positive = up
#end

//===============================================
//             Transformations
//===============================================

#declare InverseY = // forms a mirror image
	transform {
  	matrix < 1, 0, 0,
             0, -1, 0,
             0, 0, 1,
             0, 0, 0 >
	}

//===============================================
//             Textures
//===============================================

#declare SkinTex =
	texture {
		pigment { color rgb<.9,.8,.5> }
		finish { ambient .12 specular .1 roughness .1 }
	}
#declare HairTex =
	texture {
		pigment {
			gradient x
			color_map {
				[ 0.0  color rgbt<0.3,0.15,0.05,.3> ]
				[ 0.5  color rgbt<0.1,0.04,0.04,.8> ]
				[ 1.0  color rgbt<0.3,0.15,0.05,.3> ]
			}
			turbulence .8
			scale <.15,.15,.15>
		}
		normal { granite .6 scale <.5,.5,.5> }
		finish { ambient .2 specular .1 roughness .05 }
	}

//===============================================
//       Objects
//===============================================


#declare HeadThreshold = .65
#declare HT = HeadThreshold
   // this controls the raw size of the components.
   // the larger the number, the smaller the raw component,
   // although the "joins" remain big.
#declare HeadRadiusFactor = 1.6
#declare HRF = HeadRadiusFactor
   // this controls the size of the "join"
   // between components.  The bigger,
   // the thicker the "connecting tissue"
   // (but also the bigger the component).
#declare HeadStrengthFactor = .96
#declare HSF = HeadStrengthFactor
   // This is the strength of the blob components.
   // Also controls the size of the "join".
   // but also the bigger the factor, the bigger the blob itself.
   //
   // HINTS
   // A perpendicular, negative cylinder at a join will depress it
   // along the cyl axis.
   // Always make HT bigger and HRF smaller, or vice-versa
   // interesting combinations of crossed cylinders:
   // HT=1 HRF=1 HSF=1: tiny overall, slightly pointed, no cyls
   // HT=.01 HRF=1 HSF=1: sharp corners at joins
   // HT=0.5 HRF=1 HSF=1: nice overall
   //
   // Head NEGATIVE depressions:
   //		HRF*3.6, -HSF/NSF*4, scale 1 = VERY gentle overall push
   //   HRF*1.0, -HSF/NSF*8, scale 1 = almost sharp edged
   //   HRF*1.0, -HSF/NSF*4, scale 1 = small and deep
   //   HRF*1.0, -HSF/NSF*2, scale 1 = like a poke in a balloon
   //   HRF*1.0, -HSF/NSF*2, scale 1.5 = soft rubber
   //
   // Head POSITIVE push outs:
   //		HRF*1, HSF*1, scale 1 = too much like a big wart
   //		HRF*1, HSF*3, scale 1 = even sharper join on wart
   //		HRF*1, HSF*.3, scale 1 = gentler radius on wart
   //		HRF*1, HSF*.03, scale 1 = VERY gentle pull out
   //		HRF*3, HSF*.5, scale 1 = huge elephant head


#declare HT  = 0.75 // Head Threshold
#declare HRF = 1.6  // Head Radius Factor
#declare HSF = 1.0  // Head Strength Factor
#declare NSF = 24.0 // Negative Strength Factor ( divisor )

#declare TestBlob =
	blob {
		threshold HT
			sphere { // START: main head
				<0,0,0>,HRF*7.2,HSF
				scale <1,.75,1>
				translate <0,0,0>
			}
/*
			sphere { // TEST: flatten face
				<0,0,0>,
//				HRF*3.6, -HSF/NSF*4 // VERY gentle
//				scale <1.0,1.0,1.0>
//				translate <-3.0,0,0>
				HRF*3.0, -HSF/NSF*4
				scale <1.0,1.0,1.0>
				translate <-3.0,0,0>
			}
*/
			sphere { // add jaw
				<0,0,0>,
				HRF*1.0, HSF*.03
				scale <1.0,1.0,1.0>
				translate <-4.0,0,0>
			}

		texture { SkinTex }
		translate <0,0,2>
	}

#declare Ear =
	blob {
		threshold 0.4
		sphere { // main ear
			<0,0,0>,2,1
			scale <.8,.2,.8>
			translate <0,0,0>
		}
		sphere { // main ear cutout
			<0,0,0>,2,-.6
			scale <.5,.15,.5>
			translate <0,-.2,-.1>
		}
		sphere { // hearing hole
			<0,0,0>,.6,-.4
			scale <.5,1,.5>
			translate <-.3,0,-.4>
		}
		sphere { // lobe
			<0,0,0>,1,1
			scale <.8,.2,.8>
			translate <-.3,0,-1>
		}
//		texture { SkinTex }
	}

#declare Nose =
		blob {
			cylinder { // main nose ridge
				<0,0,0>,<0,0,1.6>,
				HRF*1.3,HSF*1.7
				scale <1,.4,1>
				rotate <0,36,0>
				translate <-2.1,0,-.1>
			}
			sphere { // bony ridge bump
				<0,0,0>,
//				HRF*1.2, HSF*.7
				HRF*2.0, HSF*0.1
				scale <.4,.18,.4>
				translate <-2.6,0,0.8>
			}
			sphere { // nose tip 1
				<0,0,0>,
				HRF*1.2, HSF*.7
				scale <.4,.2,.4>
				translate <-3.0,0,-0.5>
			}
			sphere { // nose tip 2
				<0,0,0>,
				HRF*0.8, HSF*.7
				scale <.4,.2,.4>
				translate <-3.2,0,-0.5>
			}

			cylinder { // flatten underside
				<0,-.8,0>,<0,.8,0>
				HRF*0.6, -HSF/NSF*11
				scale <1.0,1.0,1.0>
				translate <-2.2,0,-1.0>
			}

			sphere { // nostril RH
				<0,0,0>,
				HRF/1.3, HSF*1.2
				scale <.8,.4,.4>
				rotate <0,0,20>
				translate <-2.2,.4,-0.7>
			}
			sphere { // nostril LH
				<0,0,0>,
				HRF/1.3, HSF*1.2
				scale <.8,.4,.4>
				rotate <0,0,-20>
				translate <-2.2,-.4,-0.7>
			}
/*
			sphere { // nostril hole RH
				<0,0,0>,
				HRF*0.3, -HSF/NSF*40.0
				scale <.8,.6,.6>
				translate <-2.3,.4,-1.2>
			}
			sphere { // nostril hole LH
				<0,0,0>,
				HRF*1.3, -HSF/NSF*5.0
				scale <.8,.6,.6>
				translate <-2.3,-.4,-1.2>
			}
*/
//		texture { SkinTex }
		}

#declare EyeBall =
	union {
		sphere { // white eyeball
			<0,0,0>,.8
			texture {
				pigment { color rgb<1,1,1> }
				finish { ambient 0.4 phong 1 phong_size 110 }
			}
		}
		difference {
			sphere { // pupil
				<-.5,0,0>,.4
				texture {
					pigment { color rgb<.2,.2,0.6> }
					finish { phong 1 phong_size 110 }
				}
			}
			cylinder { // iris
				<-1,0,0>,<.3,0,0>,.07
				texture {
					pigment { color rgb<.03,.03,.2> }
					finish { specular 0.95 roughness .005 }
				}
			}
		}
		rotate <0,0,EyeLeft> // shift eyes left/right
		rotate <0,EyeUp,0> // shift eyes up/down
	}

#declare EyeCutout =
	intersection {
		sphere { // upper lid
			<0,0,0>,.8
			scale <1,1,.34>
			texture { SkinTex }
		}
		sphere { // lower lid
			<0,0,0>,1.0
			scale <1,1,.34>
			translate <0,0,.2>
			texture { SkinTex }
		}
	}

#declare Teeth =
	cylinder {
			<0,0,-.4>,<0,0,.4>,1.0
			texture {
				pigment { color rgb<1,1,1> }
				finish { ambient 0.3 specular 0.95 roughness .005 }
			}
		}
#declare MouthCavity =
	sphere {
		<0,0,0>, .8
		texture { pigment { color rgb<.3,.1,.1> } }
	}

#declare Neck =
	blob {
		threshold HT
		cylinder {
			<0,0,0>,<0,0,6>,
				HRF*2.0,HSF*2
		texture { SkinTex }
		}
	}

#declare HeadBlobRaw = // center at neck rotation point
	blob {
		threshold HT

			sphere { // main head
				<0,0,0>,HRF*7.2,HSF
				scale <1,.75,1>
				translate <0,0,0>
			}

			sphere { // flatten face
				<0,0,0>,
				HRF*3.6, -HSF/NSF*4
				translate <-3.0,0,0>
			}

			sphere { // forehead
				<0,0,0>,HRF*3,HSF*.06
				scale <.7,1.92,1>
				translate <1,0,3>
			}

			sphere { // wedge head LH
				<0,0,0>,
				HRF*4.0, -HSF/NSF*5.0
				translate <-3.0,-6.0,-3>
			}
			sphere { // wedge head RH
				<0,0,0>,
				HRF*4.0, -HSF/NSF*5.0
				translate <-3.0,6.0,-3>
			}

			sphere { // flatten cheek LH
				<0,0,0>,
				HRF*3.0, -HSF/NSF*4.0
				translate <-4.0,-5.0,-3>
			}
			sphere { // flatten cheek RH
				<0,0,0>,
				HRF*3.0, -HSF/NSF*4.0
				translate <-4.0,5.0,-3>
			}

			cylinder { // jawbone LH
				<-6,0,0>,<0,0,0>
				HRF*1.4,HSF*.05
				rotate <0,0,-15>
				translate <-1.0,-1.4,-3>
			}
			cylinder { // jawbone RH
				<-6,0,0>,<0,0,0>
				HRF*1.4,HSF*.05
				rotate <0,0,15>
				translate <-1.0,1.4,-3>
			}

			cylinder { // neg under jaw LH
				<-6,0,0>,<0,0,0>
				HRF*.9,-HSF/NSF*1.5
				rotate <0,-20,-5>
				translate <1.0,-2.1,-3.5>
			}
			cylinder { // neg under jaw RH
				<-6,0,0>,<0,0,0>
				HRF*.9,-HSF/NSF*1.5
				rotate <0,-20,5>
				translate <1.0,2.1,-3.5>
			}
			cylinder { // cleft chin
				<-.6,0,0>,<.6,0,0>,
				HRF*0.2,-HSF/NSF*0.10
				translate <-2.9,0.0,-2.9>
			}
			cylinder { // lips1
				<0,-1.5,0>,<0,1.5,0>
				HRF*0.3,-HSF/NSF*0.2
//				translate <-2.5,0.0,-1.6>
				translate <-2.5,0.0,-2.0>
			}
			cylinder { // lips2 - diagonal LH
				<0,-.5,0>,<0,.5,0>
				HRF*0.2,-HSF/NSF*0.2
				rotate <60,0,0>
//				translate <-2.3,-0.9,-1.3>
				translate <-2.3,-0.9,-1.7>
			}
			cylinder { // lips2 - diagonal RH
				<0,-.5,0>,<0,.5,0>
				HRF*0.2,-HSF/NSF*0.2
				rotate <-60,0,0>
//				translate <-2.3,0.7,-1.3>
				translate <-2.3,0.7,-1.7>
			}

			cylinder { // main eye socket RH
				<0,0,0>,<0,2,0>,
				HRF*.9,-HSF/NSF*0.4
				rotate <-15,0,-20>
				translate <-2.4,1.2,.2>
			}
			cylinder { // main eye socket LH
				<0,0,0>,<0,-2,0>,
				HRF*.9,-HSF/NSF*0.6
				rotate <15,0,20>
				translate <-2.4,-1.2,.2>
			}
			sphere { // Eye socket inner LH
				<0,0,0>,
				HRF*0.7,-HSF/NSF*0.8
				translate <-1.5,-0.3,.4>
			}
			sphere { // Eye socket inner RH
				<0,0,0>,
				HRF*0.7,-HSF/NSF*0.8
				translate <-1.5,0.3,.4>
			}

			sphere { // eye lids RH
				<0,0,0>,
				HRF/1.3, HSF/1.7
				scale <.7,1.1,.7>
				translate <-1.2,.8,.3>
			}
			sphere { // eye lids LH
				<0,0,0>,
				HRF/1.3, HSF/1.7
				scale <.7,1.1,.7>
				translate <-1.2,-.8,.3>
			}

			cylinder { // EyeBrowRidge
				<0,-1.9,0>,<0,1.9,0>,
				HRF*0.5,HSF*0.01
				translate <-2.0,0,.9>
			}
			sphere { // Cheekbone LH
				<0,0,0>,
				HRF*0.8,HSF*0.02
				translate <-1.5,-2.0,-.5>
			}
			sphere { // Cheekbone RH
				<0,0,0>,
				HRF*0.8,HSF*0.02
				translate <-1.5,2.0,-.5>
			}
			sphere { // Forehead Hair
				<0,0,0>,
				HRF*1.2,HSF*0.03
				scale <1,3,.4>
				rotate <0,40,0>
				translate <-2.0,0,3.6>
			}

//		texture { SkinTex }
	}

#declare TestHead =
	cylinder {
		<0,0,0>,<1,0,0>,6
		scale <1,.6,1>
		translate <0,0,2>
	}
#declare BlobHead =
	union {
		object { HeadBlobRaw }
		object { Nose translate <0,0,-.6> }
		object { Ear transform InverseY translate <1,3.0,0.0> } // LH
		object { Ear translate <1,-3.0,0.0> } // RH
		texture { SkinTex }
			texture {
				pigment {
					image_map { // default mapping onto XY plane
						tga "Face.tga"
						once
					}
				}
				scale <7.5,11,1> rotate <0,90,0> rotate <89,0,0> translate <0,-4,-5.4>
				finish { ambient .3 }
			}
		translate <0,0,2> // center everything at neck rotation point
	} // end of assembly union

#declare Hair =
	difference {
		object { HeadBlobRaw
			translate <0,0,-2> // set at origin
			scale <1.05,1.05,1.05>
			translate <0,0,2> // move back to original position
			texture { HairTex }
		}
		cylinder { // ear cutout
			<1,6,0>,<1,-6,0>,0.7
			texture { HairTex }
		}
		difference {
			cylinder { // front line
				<0,6,0>,<0,-6,0>,2.3
				texture { HairTex }
				translate <-3.0,0,1.5>
			}
//			box {
//				<-6,-6,2.5>,<6,6,9>
//				texture { HairTex }
//			}
		}
		box { // rear line
			<0,-6,-8>,<6,6,0>
			rotate <0,30,0>
			translate <1,0,-.5>
			texture { HairTex }
		}
		box { // sideburn bottom
			<-6,-6,-6>,<1,6,-1>
			texture { HairTex }
		}
		box { // sideburn front
			<-6,-6,-6>,<-0.5,6,2>
			texture { HairTex }
		}
		box { // eliminate all below
			<-6,-6,-16>,<6,6,-1.5>
			texture { HairTex }
		}
	}

#declare MaleHead = // origin at base of neck
	union {
		object { BlobHead }
		object { Hair translate <0,0,2> }
		object { Neck translate <1.5,0,-4> }
		translate <-1.5,0,4.2>
	}

//object { TestBlob }
//object { BlobHead }
//object { MaleHead rotate <0,0,0> translate <0,0,0> }

#warning concat("\n","BlobHead by Glenn McCarter, copyright 1997","\n")
