// Persistence of Vision Ray Tracer Scene Description File
// File: furnish.pov
// Vers: 3.01 Watcom Win32
// Desc: Furniture for Attic
// Date: June 23, 1997
// Auth: Sonya Roberts
// Note:

#if (I_Table=True)
	#declare TableLeg=
	object {
		#declare bflc=<.025,0,.025>
		#declare bbrc=<.175,0,.175>
		#declare tflc=<0,2.75,0>
		#declare tbrc=<.2,2.75,.2>
		#include "pyr_cube.inc"
		translate  <-.1,0,-.1>
	}

	#declare Table=
	object {
		union {
			box {						// Table Top
				<-1.25,2.75,-2.5>,<1.25,2.9,2.5>
				texture {T_Wood3 rotate <rand(RSD)*360,rand(RSD)*360,rand(RSD)*360>}
			}
			union {						// Rails
				box {<-1,2.5,-2.25>,<-.9,2.75,2.25>}
				box {<.9,2.5,-2.25>,<1,2.75,2.25>}
				texture {T_Wood3 rotate <rand(RSD)*360,rand(RSD)*360,rand(RSD)*360>}
			}
			union {
				box {<-.9,2.5,-2.248>,<.9,2.75,-2.4>}
				box {<-.9,2.5,2.24>,<.9,2.75,2.48>}
				texture {T_Wood3 rotate <rand(RSD)*360,rand(RSD)*360,rand(RSD)*360>}
			}
			union {						// Braces
				box {<-.65,1,-2.325>,<.65,1.2,-2.275>}
				box {<-.65,1,2.325>,<.65,1.2,2.275>}
				texture {T_Wood3 rotate <rand(RSD)*360,rand(RSD)*360,rand(RSD)*360>}
			}
			box {
				<-.025,1.025,-2.3>,<.025,1.175,2.3>
				texture {T_Wood3 rotate <rand(RSD)*360,rand(RSD)*360,rand(RSD)*360>}
			}
			union {					// Legs
				object {TableLeg translate <-.65,0,-2.3>}
				object {TableLeg translate <.65,0,-2.3>}
				object {TableLeg translate <-.65,0,2.3>}
				object {TableLeg translate <.65,0,2.3>}
				texture {T_Wood3 rotate <rand(RSD)*360,rand(RSD)*360,rand(RSD)*360>}
			}
		}
	}
#end

#if (I_Dummy=True)
	#declare Dummy=
	object {
		#include "dummy.pov"
		texture {T_Chrome_3A}
		scale <.75,.75,.75>
	}
#end

#if (I_Couch=True)
	#declare Couch=
	union {
		object {
			#include "couch.pov"
			texture {CouchFabric	scale <.25,.25,.25>}
		}
		object {
			#include "cushions.pov"
			texture {CushionFabric	scale <.25,.25,.25>}
		}
		object {
			#include "blanket.pov"
			texture {pigment {color White}	scale <.25,.25,.25>}
		}
		#include "child.pov"
		scale <1.35,1.35,1.35>
	}
#end


// ---- Position Items ----
#if (I_Table)
	object {Table	rotate y*90	translate <2,0,12.75>}
#end
#if (I_Dummy)
	object {Dummy	rotate y*55	translate <4.25,0,10>}
#end
#if (I_Couch)
	object {Couch	rotate y*-20	translate <-3.5,0,10.25>}
#end

