// -=-=-=-=-=-=-=--=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
// exileTex.inc
// texture Include File for POV-Ray 3.x
// July 97, SjG (libelle@webbwerks.com)
//
// Samuel Goldstein. libelle@webbwerks.com
// -=-=-=-=-=-=-=--=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
#declare stoneLayer = texture {
		normal
			{
			agate
			turbulence 0.3
			scale <0.4,2,0.4>
			rotate <0,30,0>
			}
		finish
			{
			ambient 0.2
			roughness 1
			}
		pigment
			{
			agate
			color_map
				{
				[0 	color Gray40]
				[0.3	color Gray60]
				[0.7	color DarkSlateGrey]
				[1.0	color LightSteelBlue]
				}
			turbulence 1.5
			scale <0.2,0.2,0.2>
			}
		}
		
#declare surfaceLayer = texture {
		normal
			{
			agate
			turbulence 0.3
			scale <0.4,2,0.4>
			rotate <0,30,0>
			}
		finish
			{
			ambient 0.3
			roughness 1
			}
		pigment
			{
			gradient y
			color_map
				{
				[0 	color MidnightBlue]
				[0.1	color rgbt<0.309804,0.32,0.184314,0.2>]
				[0.2	color rgbt<0.309804,0.309804,0.184314,0.2>]
				[0.3	color rgbt <0.309,0.285,0.1,0.4>]
				[1.0	color rgbt <1,1,1,1>]
				}
			}
		}
		
#declare topLayer = texture {
		finish
			{
			ambient 0.3
			roughness 1
			}
		pigment
			{
			bozo
			color_map
				{
				[0		color DarkGreen/2] // was DarkGreen
				[0.05	color rgbt<0.309804,0.32,0.184314,0.5>]
				[0.1	color rgbt <1,1,1,1>]
				[1.0	color rgbt <1,1,1,1>]
				}
			turbulence 3
			scale <0.25,0.5,0.25>
			}
		}

#declare icoSilver = texture{T_Wood8} 
/*texture {
		finish
			{
			reflection 0.1
			}
		pigment
			{
			color rgb <0.602, 0.62, 0.655>
			}
		}
*/

#declare icoGold = texture{T_Wood22} 
/*texture {
		finish
			{
			reflection 0.1
			}
		pigment
			{
			color rgb <0.647,0.643,0.173>
			}
		}
*/

#declare dullCloud = pigment {
    wrinkles
    turbulence 1
    octaves 8
    omega 0.7
    lambda 2
    color_map {
        [0.0, 0.1   color rgb <0.78, 0.25, 0.37>
                    color rgb <0.50, 0.20, 0.12>]
        [0.1, 0.5   color rgbt <0.50, 0.20, 0.12, 0>
                    color rgbt <0.1258, 0.1258, 0.2435, 0.2>  ]
        [0.5, 1.001 color rgbt <0.1258, 0.1258, 0.2435, 0.2>
                    color rgbt <0.1258, 0.1258, 0.2435, 0.5> ]
    }
    scale <6, 1, 6>
	}
	
#declare lighterCloud = pigment {
    bozo
    color_map {
        [0.0, 0.1   color rgb <0.01, 0.01, 0.01>
                    color rgb <0.12, 0.12, 0.125>]
        [0.1, 0.5   color rgbt <0.12, 0.12, 0.125, 0>
                    color rgbt <0.3, 0.3, 0.3, 0.3> ]
        [0.5, 1.001 color rgbt <0.3, 0.3, 0.4, 0.3>
                    color rgbt <0.1, 0.1, 0.2, 0.3>]
    }
    turbulence 0.6
    octaves 6
    omega 0.71
    lambda 2.2
    scale <6, 4, 6>
}
