// -=-=-=-=-=-=-=--=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
// banishment.pov
// The Wizard's Banishment, source file for PovRay 3.x
// 25 July 1997, SjG (libelle@webbwerks.com)
//
// Requires the following custom files:
//
// dragonfly.inc
// forest.inc
// banishTex.inc 
// chain11s.inc (a modified version of Rob Antonishen's chain11.inc)
// moorIco.inc
// face1.tga
// land2.tga (generated by mountGen2.pov)
//
// Samuel Goldstein. libelle@webbwerks.com
// -=-=-=-=-=-=-=--=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
#include "colors.inc"	// Standard Color definitions
#include "woods.inc"
#include "banishTex.inc"

global_settings{ max_trace_level 12}

#declare StdCam = camera
	{
	location  <-1.0, 20.0, -25.0>
	direction z 
	up        y
	right     4/3*x
	look_at   <0.0, 21.0,  0.0>
	}
	
#declare TopCam = camera
	{
	location  <0.0, 700.0, -20.0>
	direction z 
	up        y
	right     4/3*x
	look_at   <0.0, 1.0,  0.0>
	}
	
#declare FrontCam = camera
	{
	location  <0.0, 0.0, -500.0>
	direction z 
	up        y
	right     4/3*x
	look_at   <0.0, 0.0,  0.0>
	}
	
#declare ZoomCam = camera
	{
	location  <-1.0, 25.0, -10.0>
	direction z 
	up        y
	right     4/3*x
	look_at   <0.0, 25.0,  0.0>
	}
	
#declare mainLight = light_source
	{
	0*x
	color red 1.0  green 1.0  blue 1.0
	translate <-50,50,-50>
	}
	
#declare secondaryLight = light_source
	{
	0*x
	color red 0.3  green 0.3  blue 0.3
	translate <50,20,-50>
	shadowless
	}
	
#declare tertiaryLight = light_source
	{
	0*x
	color red 0.4  green 0.4  blue 0.4
	translate <-40,40,-50>
	shadowless
	}
	

#declare primaryFog = box {
<-2,0,-2>,<2,0.5,2>
texture
	{
	pigment
		{
		color rgbt <1, 1, 1, 1>
		}
   halo
   	{
      attenuating
      planar_mapping
      cubic
      turbulence <2,3,2> // was 2,5,2
      lambda 2
      color_map
      	{
			[0		color rgbt <1,  1, 1, 1> ]
			[0.1		color rgbt <.348, .299, .399, -0.5> ]
			[1			color rgbt <.348, .299, .399, -1.0> ]
			}
      samples 10
      scale <1, 0.85, 1>
    	}
    scale <0.1, 1, 0.1>
    }
hollow
}

#declare secondaryFog = box {
<-2,0,-2>,<2,0.5,2>
texture
	{
	pigment
		{
		color rgbt <1, 1, 1, 1>
		}
   halo
   	{
      attenuating
      planar_mapping
      cubic
      turbulence <2.2,5,2.3>
      lambda 2
      color_map
      	{
			[0		color rgbt <1,  1, 1, 1> ]
			[1			color rgbt <1, 1, 1, 0.5> ]
			}
      samples 10
      scale <1, 0.85,1>
    	}
    scale <0.3, 1, 0.3>
    }
hollow
}

// Needs to lie in the XZ plane
#declare icoBaseTriangle = union {
	cylinder {<0.04,0,0.14>,<1.02,0,0.14>,0.08 scale <1,0.25,1>	texture{icoGold}}
	
	cylinder {<0.32,0,-0.01>,<0.42,0.02,0.18>,0.025	texture{icoSilver}}
	sphere{<0.42,0.02,0.18>,0.025	texture{icoSilver}}
	cylinder {<0.42,0.02,0.18>,<0.7,-0.02,0.62>,0.025	texture{icoSilver}}
	sphere{<0.7,-0.02,0.62>,0.025	texture{icoSilver}}
	cylinder {<0.7,-0.02,0.62>,<0.84,0.02,0.9>,0.025	texture{icoSilver}}
	sphere{<0.84,0.02,0.9>,0.025	texture{icoSilver}}
	cylinder {<0.84,0.02,0.9>,<1.04,0,1.22>,0.025	texture{icoSilver}}
	cylinder {<0.16,0,-0.01>,<0.26,-0.02,0.18>,0.025	texture{icoSilver}}
	sphere{<0.26,-0.02,0.18>,0.025	texture{icoSilver}}
	cylinder {<0.26,-0.02,0.18>,<0.46,0,0.52>,0.025	texture{icoSilver}}
	sphere{<0.46,0,0.52>,0.025	texture{icoSilver}}
	cylinder {<0.46,0,0.52>,<0.38,0,0.72>,0.025	texture{icoSilver}}
	sphere{<0.38,0,0.72>,0.025	texture{icoSilver}}
	cylinder {<0.38,0,0.72>,<0.58,0,0.74>,0.025	texture{icoSilver}}
	sphere{<0.58,0,0.74>,0.025	texture{icoSilver}}
	cylinder {<0.58,0,0.74>,<0.7,0.02,0.96>,0.025	texture{icoSilver}}
	sphere{<0.7,0.02,0.96>,0.025	texture{icoSilver}}
	cylinder {<0.7,0.02,0.96>,<0.86,-0.02,1.22>,0.025	texture{icoSilver}}
	sphere{<0.86,-0.02,1.22>,0.025	texture{icoSilver}}
	cylinder {<0.86,-0.02,1.22>,<1.04,0,1.52>,0.025	texture{icoSilver}}
	cylinder {<0.7,0,-0.01>,<0.7,-0.02,0.22>,0.025	texture{icoSilver}}
	sphere{<0.7,-0.02,0.22>,0.025	texture{icoSilver}}
	cylinder {<0.7,-0.02,0.22>,<0.78,0.02,0.34>,0.025	texture{icoSilver}}
	sphere{<0.78,0.02,0.34>,0.025	texture{icoSilver}}
	cylinder {<0.78,0.02,0.34>,<0.84,0,0.46>,0.025	texture{icoSilver}}
	sphere{<0.84,0,0.46>,0.025	texture{icoSilver}}
	cylinder {<0.84,0,0.46>,<0.84,-0.02,0.9>,0.025	texture{icoSilver}}
	sphere{<0.84,-0.02,0.9>,0.025	texture{icoSilver}}
	cylinder {<0.84,-0.02,0.9>,<0.84,0.02,1.22>,0.025	texture{icoSilver}}
	sphere{<0.84,0.02,1.22>,0.025	texture{icoSilver}}
	cylinder {<0.84,0.02,1.22>,<0.84,0,1.52>,0.025	texture{icoSilver}}
	cylinder {<0.84,0,-0.01>,<0.84,0.02,0.22>,0.025	texture{icoSilver}}
	sphere{<0.84,0.02,0.22>,0.025	texture{icoSilver}}
	cylinder {<0.84,0.02,0.22>,<0.78,-0.02,0.34>,0.025	texture{icoSilver}}
	sphere{<0.78,-0.02,0.34>,0.025	texture{icoSilver}}
	cylinder {<0.78,-0.02,0.34>,<0.7,0,0.46>,0.025	texture{icoSilver}}
	sphere{<0.7,0,0.46>,0.025	texture{icoSilver}}
	cylinder {<0.7,0,0.46>,<0.7,0.02,0.9>,0.025	texture{icoSilver}}
	sphere{<0.7,0.02,0.9>,0.025	texture{icoSilver}}
	cylinder {<0.7,0.02,0.9>,<0.7,-0.02,1.22>,0.025	texture{icoSilver}}
	sphere{<0.7,-0.02,1.22>,0.025	texture{icoSilver}}
	cylinder {<0.7,-0.02,1.22>,<0.7,0,1.24>,0.025	texture{icoSilver}}
}
#declare icoFaceThickness = 0.0125
#declare icoEdgeTexture = texture {icoSilver}
#declare moorRosetteOrder = 1
#declare extendLen = 2.3839601 // because the side of the triangle is 1.7320508

#declare link = union {
	intersection {
		torus {0.25,0.05}
		plane{x,0}
		translate <0.15,0,0>
		}
	intersection {
		torus {0.25,0.05}
		plane{-x,0}
		translate <0.75,0,0>
		}
	cylinder {<0.15,0,0.25>,<0.75,0,0.25>,0.05}
	cylinder {<0.15,0,-0.25>,<0.75,0,-0.25>,0.05}
	texture{icoGold}
}

#declare blurredWings=1
#declare dragonflySeed = seed(1714)

#declare dfXlate = <0,extendLen*1.5,(43*0.07)+extendLen*2>
#declare dfScale = <0.07,0.07,-0.07>

#declare chain_start=<0,0,extendLen>
// this one's higher up. It makes the image a bit more interesting...
#declare chain_end=<0, extendLen*1.5, extendLen*2>
#declare chain_type=2
#declare link_length=0.25
#declare chain_scale=0.1
#declare link_min_rotation = 60
#declare link_max_rotation = 90
#declare curlAngle = rand(dragonflySeed)*180
#declare chain1 = union {
	#include "chain11s.inc"
	#include "dragonfly.inc"
}

#declare dfXlate = <0,extendLen,(43*0.07)+extendLen*2>

#declare chain_start=<0,0,extendLen>
#declare chain_end=<0, extendLen, extendLen*2>
#declare chain_type=2
#declare link_length=0.25
#declare chain_scale=0.1
#declare link_min_rotation = 60
#declare link_max_rotation = 90
#declare curlAngle = rand(dragonflySeed)*90
#declare chain2 = union {
	#include "chain11s.inc"
	#include "dragonfly.inc"
}
#declare chain_start=<0,0,extendLen>
#declare chain_end=<0, extendLen, extendLen*2>
#declare chain_type=2
#declare link_length=0.25
#declare chain_scale=0.1
#declare link_min_rotation = 60
#declare link_max_rotation = 90
#declare curlAngle = rand(dragonflySeed)*180
#declare chain3 = union {
	#include "chain11s.inc"
	#include "dragonfly.inc"
}
#declare chain_start=<0,0,extendLen>
#declare chain_end=<0, extendLen, extendLen*2>
#declare chain_type=2
#declare link_length=0.25
#declare chain_scale=0.1
#declare link_min_rotation = 60
#declare link_max_rotation = 90
#declare curlAngle = rand(dragonflySeed)*180
#declare chain4 = union {
	#include "chain11s.inc"
	#include "dragonfly.inc"
}
#declare chain_start=<0,0,extendLen>
#declare chain_end=<0, extendLen, extendLen*2>
#declare chain_type=2
#declare link_length=0.25
#declare chain_scale=0.1
#declare link_min_rotation = 60
#declare link_max_rotation = 90
#declare curlAngle = rand(dragonflySeed)*40
#declare chain5 = union {
	#include "chain11s.inc"
	#include "dragonfly.inc"
}

#declare icos = union {
	#include "moorIco.inc"
	object {chain1 rotate <0,0,0> translate <0,centerDrop,0>}
	object {chain2 rotate <0,-72,0> translate <0,centerDrop,0>}
	object {chain3 rotate <0,-144,0> translate <0,centerDrop,0>}
	object {chain4 rotate <0,-216,0> translate <0,centerDrop,0>}
	object {chain5 rotate <0,-288,0> translate <0,centerDrop,0>}
	translate <0,1.4733704,0>
	no_shadow
   }

#declare theSky = sky_sphere {
	pigment {
		granite
		frequency 1.18
		turbulence 0.25
		color_map {
			[0.01	color LightBlue]
			[0.04	color White]
			[0.041	color Black]
			}
	scale <0.03,0.03,0.03> //0.025
	}
   pigment {
		gradient y
			pigment_map {
				[0.01 rgbt <0.4, 0.3, 0.45, 0.001> ] // horizon
				[0.25 dullCloud scale 0.25 rotate z*5]
				[0.60 lighterCloud scale <0.25, 0.15, 0.25> rotate z*10]
    		}
    	}
	translate <0,0.05,0>
	}
	


#declare theLand = height_field {
	tga "land2.tga"
	smooth
	#declare landSize=300 // 300x300 tga
	translate <-0.5,0,-0.5>
	texture{stoneLayer}
	texture{surfaceLayer}
	texture{topLayer translate <5,0,0>}
	scale <300,60,300>
	}
	
#declare earthPlane = cylinder {
	<0,0,0>,<0,1,0>,1
	texture{stoneLayer scale <1.5,1.5,1.5>}
	texture{topLayer scale <1.5,1.5,1.5>}
	scale <800,1,800>
}
 


#declare theFace=  intersection {
	height_field {
		tga "face1.tga"
		water_level 0.03
		smooth
		translate <-0.5,0,-0.5>
	}
	box{<-0.49,0.032,-0.49>,<0.49,1.1,0.49>}
	}

 
#declare theWizard = union {
	object {theFace scale <0.8, 0.5, 1>
		texture {T_Wood13 rotate <30,45,0>}}
		
	object {theFace scale <1, 1, 1.2> hollow
   	 pigment { color rgbt <1, 1, 1, 1> }
   	 halo {
      	emitting
      	spherical_mapping
      	linear
      	turbulence 0.8
      	color_map {
      	  [ 0.0 color rgbt <1, 0, 0,  1> ]
      	  [ 0.5 color rgbt <1, 1, 0, -0.5> ]
      	  [ 1.0 color rgbt <1, 1, 0,  1> ]
      	}
      	frequency 3
      	samples 20
      	scale 0.9
      	translate <0,0.5,0>
   	 }
	}
	light_source
		{
		0*x
		color rgb <1,1,0>
		translate <0,1.6,0.6>
		fade_distance 15
    	fade_power 1
		}
	}
 
// --=--=--=--=--=--=--=--=--=--=--=--=--=-- 
// Actual scene gets put together here...
// --=--=--=--=--=--=--=--=--=--=--=--=--=-- 
camera{StdCam}
object{mainLight}
object{secondaryLight}
object{tertiaryLight}
// detail switches for testing...
#if (1)
	sky_sphere{theSky}
#else
	background{Black}
#end
#if (1)
	object{theLand translate <0,-30,150>}
	object{theLand rotate <0,-90,0> scale <1.4,0.8,1.4>
		translate <-150,-30,550>}
	object{earthPlane translate <0,-32,150>}
#end
#if (1)
	#include "forest.inc"
#end
#if (1)
	object{primaryFog scale <150,30,150> translate <0,-19,300>}
	object{secondaryFog scale <150,10,150> translate <0,9,300>}
#end

#if (1)
	object {icos scale <2,2,2> rotate <-14,-5,0> translate <-10,29,10>}
	object {theWizard rotate <-90,-15,0> scale <8.5,8.5,8.5>
		translate <-11,30,13>}
#end
