#ifndef (ChaudronIsDeclared)

#declare ChaudronIsDeclare=1

#include "colors.inc"

#ifndef (ChaudronEp)       #declare ChaudronEp      = 0.05 #end
#ifndef (ChaudronEpBord)   #declare ChaudronEpBord  = 0.15 #end
#ifndef (ChaudronEpPgn)    #declare ChaudronEpPgn   = 0.25 #end
#ifndef (ChaudronRotPgn)   #declare ChaudronRotPgn  =80    #end
#ifndef (ChaudronEpFixPgn) #declare ChaudronEpFixPgn= 0.10 #end
#ifndef (ChaudronHautPgn)  #declare ChaudronHautPgn = 0.45 #end
#ifndef (ChaudronSclPgn)   #declare ChaudronSclPgn  = 0.15 #end
#ifndef (ChaudronOuv)      #declare ChaudronOuv     = 0.80 #end
#ifndef (ChaudronHautLiq)  #declare ChaudronHautLiq = 0.55 #end


// Toutes ces variables ne peuvent pas etre changee
#declare ChaudronOuvHaut=sqrt(1- (ChaudronOuv * ChaudronOuv))
#declare ChaudronXPgn=sqrt(1- (ChaudronHautPgn * ChaudronHautPgn))

#ifndef (ChaudronTextLiq)
#declare ChaudronTextLiq=texture {
   pigment { rgb <1,0.4,0.2> }
   normal { bumps 1.5 scale 0.1 }
   finish {
      phong 1.5
      diffuse 0.5
      ambient 0.1
      reflection 0.5
      refraction 0.5
      ior 1.33
   }
}
#end

#ifndef (ChaudronText)
#declare ChaudronText=texture {
   pigment {
      rgb <0.20,0.20,0.20>
   }

   normal { granite 1.5 }
   
   finish {
      phong 0.7
      diffuse 0.8
      ambient 0.2
      reflection 0.3
   }
}
#end

#declare ChaudronPoignee=union {
   union {
      cylinder { <-1.5,0, 1.0>, < 1.5,0, 1.0>, ChaudronEpPgn }
      cylinder { <-1.5,0,-1.0>, < 1.5,0,-1.0>, ChaudronEpPgn }
      cylinder { < 2.0,0,-0.5>, < 2.0,0, 0.5>, ChaudronEpPgn }
      cylinder { <-2.0,0,-0.5>, <-2.0,0, 0.5>, ChaudronEpPgn }
      
      torus { 0.5, ChaudronEpPgn
	 clipped_by { box { <0,-1,0>, <1,1,1> } }
	 translate < 1.5, 0, 0.5>
      }
      torus { 0.5, ChaudronEpPgn
	 clipped_by { box { <0,-1,0>, <-1,1,1> } }
	 translate < -1.5, 0, 0.5>
      }
      torus { 0.5, ChaudronEpPgn
	 clipped_by { box { <0,-1,0>, <-1,1,-1> } }
	 translate < -1.5, 0, -0.5>
      }
      torus { 0.5, ChaudronEpPgn
	 clipped_by { box { <0,-1,0>, <1,1,-1> } }
	 translate < 1.5, 0, -0.5>
      }
      
      translate <0,0,-1>
      scale ChaudronSclPgn
   }
   sphere { <0,0,0>, ChaudronEpFixPgn }
}

#declare ChaudronCorp=union {
   difference {
      sphere{
	 <0,0,0>, 1
      }
      
      sphere {
	 <0,0,0>, 1-ChaudronEp
      }
      
      box {
	 <2,0,2>, <-2,2,-2>
	 translate y*ChaudronOuvHaut
      }
   }
   
   torus {
      ChaudronOuv, ChaudronEpBord
      translate y*ChaudronOuvHaut
   }
   
   object {
      ChaudronPoignee 
      rotate -x*ChaudronRotPgn
      translate <0,ChaudronHautPgn, -ChaudronXPgn - ChaudronEpFixPgn*0.8>
   }

   object {
      ChaudronPoignee 
      rotate y*180
      rotate x*ChaudronRotPgn
      translate <0,ChaudronHautPgn, ChaudronXPgn + ChaudronEpFixPgn*0.8>
   }
   
   texture { ChaudronText }


}

#declare ChaudronContenu=intersection {
   isosurface {
      box  <-1,-1,-1>, <1,ChaudronHautLiq*2,1>
      function {
	 "BumpBox",
	 <0.025,0.02,ChaudronHautLiq>,
	 library "fonc.so"
      }
      eval
   }
   sphere { <0,0,0>, 1-ChaudronEp}  
   texture { ChaudronTextLiq }
}


#declare Chaudron=union {
   object { ChaudronCorp }
   object { ChaudronContenu }
}


#end
