#ifndef (PailleIsDeclared)
#declare PailleIsDeclared=true

#include "colors.inc"

// Variables utilisateur...
#ifndef (PailleTubEp)     #declare PailleTubEp     = 0.01  #end
#ifndef (PailleTubRay)    #declare PailleTubRay    = 0.1   #end
#ifndef (PailleGdTubLg)   #declare PailleGdTubLg   = 3     #end
#ifndef (PaillePtTubLg)   #declare PaillePtTubLg   = 1     #end
#ifndef (PailleAngArt)    #declare PailleAngArt    = 40    #end
#ifndef (PailleElemArtSz) #declare PailleElemArtSz = 0.07  #end
#ifndef (PailleArtNbElem) #declare PailleArtNbElem = 5     #end
#ifndef (PailleArtDef)    #declare PailleArtDef    = 0.01  #end

#declare PailleAngElem = PailleAngArt / PailleArtNbElem

#ifndef (TextPaille)
#declare TextPaille=texture {
   pigment {
      radial
      color_map {
	 [0.00 color rgb <1,1,1>]
	 [0.40 color rgb <1,1,1>]
	 [0.50 color rgb <1,0,0>]
	 [0.60 color rgb <1,1,1>]
	 [1.00 color rgb <1,1,1>]
      }   
      frequency 5
   }
   finish {
      phong 0.5
      ior 1
      reflection 0
      diffuse 0.7
      ambient 0.2
      refraction 0.2
   }
}
#end

#declare PailleGdTube=difference {
   cylinder { <0,-PailleGdTubLg,0>, <0,0,0>, PailleTubRay }
   cylinder { <0,-PailleGdTubLg-0.1,0>, <0,0.2,0>, PailleTubRay-PailleTubEp }
   texture { TextPaille }
}

#declare PaillePtTube=difference {
   cylinder { <0,PaillePtTubLg,0>, <0,-PailleElemArtSz,0>, PailleTubRay }
   cylinder { <0,PaillePtTubLg+0.1,0>, <0,-PailleElemArtSz-0.2,0>, PailleTubRay-PailleTubEp }
   texture { TextPaille }

   rotate z*PailleAngElem*0.5
   translate y*PailleElemArtSz*0.5
   
   #declare j=0
   #while ( j <= PailleArtNbElem )
	rotate z*PailleAngElem
	translate y*PailleElemArtSz
	#declare j = j + 1
   #end
}

#declare PailleArtElem=difference {      
      
   isosurface {
      box <-PailleTubRay*2, -PailleElemArtSz, -PailleTubRay*2>,
      <PailleTubRay*2, PailleElemArtSz, PailleTubRay*2>
      function {
	 "ArtPaille",
		<PailleTubRay,
		 PailleElemArtSz/2,
		 PailleAngElem/2,
		 PailleArtDef>,
	 library "fonc.so"
      }
      eval
   }
   
   isosurface {
      box <-PailleTubRay*2, -PailleElemArtSz*1.1, -PailleTubRay*2>,
      <PailleTubRay*2, PailleElemArtSz*1.1, PailleTubRay*2>
      function {
	 "ArtPaille",
	 <PailleTubRay-PailleTubEp,
	 PailleElemArtSz/2,
	 PailleAngElem/2,
	 PailleArtDef>,
	 library "fonc.so"
      }
      eval
   }
   
   texture { TextPaille }
   rotate z*PailleAngElem
}

#declare PailleArticulation=union {
   #declare i=0
   #while ( i < PailleArtNbElem ) 
	object {
	   PailleArtElem
	   rotate z*PailleAngElem*0.5
	   translate y*PailleElemArtSz*0.5

	   #declare j=0
	   #while ( j < i )
		rotate z*PailleAngElem
		translate y*PailleElemArtSz
		#declare j = j + 1
	   #end
	}
	#declare i = i +1
   #end
}
	   


#declare Paille=union {
   object { PailleGdTube }
   object { PailleArticulation }
   object { PaillePtTube }
   rotate y*180
}

#end

