#ifndef (RecetteIsDeclared)
#declare RecetteIsDeclared=true

#include "colors.inc"

// Variables utilisateurs...
#ifndef (RecetteEp) #declare RecetteEp = 0.01 #end
#ifndef (RecetteCadreEp) #declare RecetteCadreEp = 0.02 #end
#ifndef (RecetteScl) #declare RecetteScl = 0.75 #end

#ifndef (RecetteTextCadre)
#declare RecetteTextCadre=texture {
   pigment { color rgb <0.65, 0.35, 0.15> }
   finish {
      ambient 0.35
      brilliance 2
      diffuse 0.3
      metallic
      specular 0.80
      roughness 1/20
      reflection 0.1
   }
}
#end

#ifndef (RecetteTextVis)
#declare RecetteTextVis=texture {
   RecetteTextCadre
}
#end


#ifndef (RecetteText)
#declare RecetteText=texture {
   pigment {
      image_map {
	 tga "Recipe.tga"
	 map_type 0
	 once
      }
      translate <-0.5, -0.5, 0>
      scale <545,250,1>
      scale 1/500*RecetteScl
   }
}
#end

#declare RecetteVis=difference {
   sphere { <0,0,0>, 1 scale z*0.5 }
   box { <2,2,0.02>, <-2,-2,1> }
   box { <2,0.1,-1>, <-2, -0.1, 0.01> }
   
   texture {
      RecetteTextVis
   }
}
  

#declare RecettePano=
  difference {
     intersection {
	sphere {
	   <0,0,0>, 1+RecetteEp
	   texture { RecetteText }
	}
	
	box {
	   <-0.5, -0.5,-1>, <0.5, 0.5, 0>
	   scale <545,250,2>
	   scale <1/500*RecetteScl,1/500*RecetteScl, 1>
	}
	
     }
     sphere {
	<0,0,0>, 1
     }
     
  }


 
#declare RecetteCadre=
  union {
     difference {
	
	intersection {
	   sphere {
	      <0,0,0>, 1+RecetteCadreEp
	   }
	   
	   box {
	      <-0.5, -0.5,-1>, <0.5, 0.5, 0>
	      scale <600,300,2>
	      scale <1/500*RecetteScl,1/500*RecetteScl, 1>
	   }  
	   
	}
	
	box {
	   <-0.5, -0.5,-1>, <0.5, 0.5, 0>
	   scale <545,250,2>
	   scale <1/500*RecetteScl,1/500*RecetteScl, 1>
	}
	
	sphere {
	   <0,0,0>, 1
	}
	
	texture { 
	   RecetteTextCadre
	}
     }
     
     object {
	RecetteVis
	scale 0.015
	translate -z*(1+RecetteCadreEp)
	rotate z*10
	rotate x*11.5
	rotate y*25
     }

       object {
	RecetteVis
	scale 0.015
	translate -z*(1+RecetteCadreEp)
	rotate -z*32
	rotate -x*11.5
	rotate y*25
     }
      object {
	RecetteVis
	scale 0.015
	translate -z*(1+RecetteCadreEp)
	rotate -z*92
	rotate x*11.5
	rotate -y*25
     } 
     object {
	RecetteVis
	scale 0.015
	rotate z*54
	translate -z*(1+RecetteCadreEp)
	rotate -x*11.5
	rotate -y*25
     }
  }

#declare Recette = union {
   object { RecettePano }
   object { RecetteCadre }
}

#end

