#define DLL
#include "isofunc.h"

#define EPSILON 0
#define BORNE(B,A) (min(A, max(-A, B)))


#define IsNULL(A) (((A<=EPSILON)&&(A>=-EPSILON))?1:0)

/* Les valeurs a, b, et c doivent etre dans l'ordre.... */
DBL varVal( DBL a, DBL b, DBL c, DBL va, DBL vb, DBL vc, DBL pos) {
  
  DBL newX;

  if ( pos < b ) {
    newX = ( pos  - a ) / ( b - a );
    return ( sin(newX * M_PI/2 ) * ( vb - va ) + va );
  } else if ( pos >= b ) {
    newX = ( pos - c ) / ( b - c );
    return ( sin(newX * M_PI/2 ) * ( vb - vc ) + vc );
  }
 
  return vb;
}	  

#define PA Func->parm[10]
#define PB Func->parm[11]

/* Translate Cartesian coord to spherical coord */
void Cart2Sph(VECTOR XYZ, VECTOR * RTP) {

  *RTP[0]=sqrt(x*x + y*y + z*z);
  *RTP[1]=atan(x/z);
  *RTP[2]=acos(y/  *RTP[0] );

}

/* Translate Cartesian coords to cylindrical coords */
void Cart2Cyl(VECTOR XYZ, VECTOR * RAH) {

  (*RAH)[0] = sqrt(x*x + y*y);
  (*RAH)[2] = z;
  if ( IsNULL( (*RAH)[0]) )
    (*RAH)[1] = 0;
  else
      (*RAH)[1] = acos( x / (*RAH)[0] );

}


FUNC Snake(FUNCTION * Func, VECTOR XYZ) {

  /* P0 Nombre de \/\/ entre -P0 et P0 */
  /* P1 Taille du \/\/ a -P0           */
  /* P2 Taille du \/\/ a 0             */
  /* P3 Taille du \/\/ a P0            */
  /* P4 Epaisseur a -P0		    */
  /* P5 Epaisseur a 0                  */
  /* P6 Epaisseur a P0                 */
  /* P7 Variation de Frequence avant 0 */
  /* P8 Variation de Frequence apres 0 */
  /* P9 Position borne inf             */
  /* PA Position centre                */
  /* PB Position borne sup             */

  DBL f;
  DBL d;
  DBL r;
  DBL Amplitude;
  DBL Frequence;

  r=varVal(P9, PA, PB, P4, P5, P6, x);
  Amplitude = varVal(P9, PA, PB, P1, P2, P3, x);
  Frequence = varVal(P9, P1, PB, P0+P7, P0, P0+P8, x);

  f = sin( x * M_PI * Frequence )* Amplitude;
  d = ( z - f )*( z - f ) + y * y;

  return d - r*r;
}
    
FUNC Heart(FUNCTION * Func, VECTOR XYZ) {

  VECTOR RAH;
  DBL r;
  DBL dist;

  Cart2Cyl(XYZ, &RAH);

  r =  (RAH[1]/M_PI + P1);

  dist = (RAH[0]+P0 - r);

  return BORNE( dist ,5);
  
}

FUNC AngTorus(FUNCTION * Func, VECTOR XYZ) {
  DBL BgRay=P0; /* Rayon Grand du tord... */
  DBL LtRay=P1; /* Rayon au moyen... */
  DBL Ang=P2;   /* Angle */
  
  DBL x2 = x*x;
  DBL y2 = y*y;
  DBL z2 = z*z;

  DBL Dist2O;
  DBL Dist2Circ;

  DBL CalcRay;
  
  Dist2O = sqrt(x2 + z2) - BgRay;
  Dist2Circ = sqrt(Dist2O * Dist2O + y2);

  CalcRay = LtRay + x * tan( Ang*M_PI/180 );

  return Dist2Circ - CalcRay;

}

FUNC ArtPaille(FUNCTION * Func, VECTOR XYZ) {
  /* P0 Rayon principal          */
  /* P1 Hauteur Principal        */
  /* P2 Angle                    */
  /* P3 Taille de la deformation */

  DBL Hauteur=P1 + x * tan( P2*M_PI/180 );
  DBL Ray=varVal(-Hauteur,0,Hauteur,P0,P0-P3,P0,y);

  DBL dist=sqrt(x*x + z*z);

  return dist - Ray;
}

FUNC BumpBox(FUNCTION * Func, VECTOR XYZ) {
  /* P0 : Frequence                     */
  /* P1 : Profondeur                    */
  /* P2 : Hauteur normale..             */
  
  /* Renvoi une demi boite ( y < P2 )  */
  /* dont la surface du dessus ( y = P2) est de traviole */
  
  DBL Pert;
  
  Pert = (sin(0.87942149*x/P0/M_PI))*(cos(2.123676213*z/P0/M_PI));
  Pert = Pert * sin(1.213564*x/P0/M_PI) * sin( -0.2465465479*(x+z)/P0/M_PI );
  Pert = Pert * P1;
 
  /* printf("%lf, %lf -> %lf\n",x, z, Pert); */
 
  return Pert + y - P2;
}
  
