
// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3

#include "colors.inc"
#include "textures.inc"
#include "finish.inc"
#include "tree.inc"
#include "tree3.inc"
#include "glass.inc"
#include "rocks.inc"


#declare True = 1
#declare False = 0
#declare testing = False
//#declare testing = True


global_settings
{ assumed_gamma 2.3
  #if (testing = False)
    max_trace_level 10
  #end
}



#declare fireX = -12
#declare fireY = 0
#declare fireZ = -24
#declare fireYrot=24

#declare pentYrot=17

#declare laserTop = 80

#declare camX = -160
#declare camY =  110
#declare camZ = -350

#declare lookX = -25
#declare lookY =  45
#declare lookZ = 0


camera
{
  location  <camX, camY, camZ>
  direction 1.7*z
  right     4/3*x
  look_at   <lookX, lookY,  lookZ>
}

 light_source{ <fireX ,laserTop ,fireZ>
                color rgb <1,.7,.4>*.6
  }




 #declare cam_loc = <camX, camY, camZ>           // use the x, y, and z of your camera
 #declare light_loc = <fireX ,laserTop ,fireZ >  // use the x, y, and z of the light
                                                 // you wish to flare
 #declare lookat = <lookX, lookY,  lookZ>        // the look_at vector of your camera
 #declare sky_vect = <0, 1, 0>                   // the sky vector of your camera
 #declare flare_type = "105mm_a"                 // or whatever pre-defined flare you like
 #include "lnsflare.inc"                         // create the lens flare

light_source{ 0*x          // light's position (translated below)
              color rgb <.7,1,1>.2  // light's color
              shadowless
              translate <-300,1000,-500>
}




#declare waterMult = 1.0
#declare Water = texture {
  pigment {
    color rgbf <1.2*waterMult, 1.2*waterMult, 1.10*waterMult, 0.2>
  }
  normal { bumps 1 scale <32,96,32>}
  finish {
    reflection 0.4
    refraction 0.5
    ior 1.33
    phong 1.0
    phong_size 100
  }
  scale <0.2,0.2,0.2>
}


#if (testing = False)
  sphere { <camX, camY, camZ>, 10000
    texture{
      pigment {
        image_map { gif "stars.gif"
          interpolate 2
        }
        translate <-0.5, -0.5, 0.0>
        scale 8000
      }
      finish { Luminous}
    }
    rotate <-3,-13,77>
    rotate <-1,-14,0>
    hollow
  }
#end


#declare spoon=
merge{
  cone { <0,0,0>, 2, <0,50,0>, 1.5}
  sphere{<0,50,0>,1.5}
  texture{
    pigment{color rgb <0.910, 0.557, 0.290>
           }
    finish{ diffuse 0.7 ambient 0.3 }
    normal{
      gradient x
      slope_map {
        [0   <0, 2>]
        [0.2 <1, 0>]
        [0.6 <1,-2>]
        [0.75 <0, 0>]
        [1.0 <0, 0>]
      }
    turbulence <0.65,0.4,0.1>
    scale <0.05, 0.05*3, 0.3>*10
     }
  }
}




#declare steam=
  cylinder{<fireX ,38,fireZ>, <fireX ,48,fireZ> ,17
    pigment { color rgbt <1, 1, 1, 1> }
    halo {
      emitting
      cylindrical_mapping
      linear
      turbulence 1.5
      colour_map {
        [0.0 color rgbt <.6, .6, .6, 1>]
        [0.5 color rgbt <.3, .3, .3, 0.8>]
        [1.0 color rgbt <0, 0, 0, 1>]
      }
      samples 4
      scale <20,5,20>
    }
    scale<1.75,1,1.75>
    rotate<0,15,0>
    translate<20,-3,0>
    hollow
    no_shadow
  }

#declare kettleHalo =
sphere { 0,1.5
    pigment { color rgbt <1, 1, 1, 1> }
    halo {
      emitting
      spherical_mapping
      linear
      turbulence 1.5
      color_map {
        [ 0 color rgbt <1, 0, 0,  1> ]
        [ 1 color rgbt <1, 1, 0, -1> ]
      }
      samples 5
      scale <.5,1,.5>
    }
    halo {
      emitting
      spherical_mapping
      linear
      turbulence 1.5
      color_map {
        [ 0 color rgbt <1, 0, 0,  1> ]
        [ 1 color rgbt <1, 1, 0, -1> ]
      }
      samples 5
      rotate<0,90,0>
      scale <.5,1,.5>
    }
    halo {
      emitting
      spherical_mapping
      linear
      turbulence 1.5
      color_map {
        [ 0 color rgbt <1, 0, 0,  1> ]
        [ 1 color rgbt <1, 1, 0, -1> ]
      }
      samples 5
      scale <.5,1,.5>
      rotate<0,180,0>
    }
    halo {
      emitting
      spherical_mapping
      linear
      turbulence 1.5
      color_map {
        [ 0 color rgbt <1, 0, 0,  1> ]
        [ 1 color rgbt <1, 1, 0, -1> ]
      }
      samples 10
      scale <.5,1,.5>
      rotate<0,270,0>
    }
    hollow
  }


#declare bigPot=
  lathe {
    quadratic_spline
    16,
    <0,0> <117,0> <192,0> <233,7> <272,18> <313,39>
    <356,68> <395,119> <425,187> <424,262> <404,322>
    <381,383> <365,439> <360,458> <365,480> <392,538>
  }

#declare xscale = 16.5
#declare BigKettle =
union{
  merge{
    object{ bigPot}
    object{ bigPot scale .98 translate<0,10.76,0>}
    torus{ 388.08,3.92 translate <0,536,0> }
    #if (testing = True)
       texture{pigment{Red}}
    #else
      texture{
        pigment {color rgb <.1,.1,.1>*.6}
        normal{
          bumps 0.15
          scale 0.05
        }
        finish{Dull}
      }
    #end
  }
  disc{<0,480,0>, <0,1,0>, 365
    texture{Water}
  }
}


#declare kettleFire=
union{
  merge{
    object{ kettleHalo scale <40,8,40> translate <5.5,0,0> rotate<0,0,0> no_shadow}
    object{ kettleHalo rotate<0,180,0>scale <40,8,40> translate <-5.5,0,0> rotate<0,0,0> }
  }

  #declare yRot= 0
  #while (yRot < 240)
    object{ kettleHalo
            scale<10,15,10> translate <26,0,0> rotate<0,yRot,0> }
    #declare yRot= yRot+25
  #end
}


#declare SkullTexture=
  texture{ pigment{White*1.5}
     finish{ roughness .2}
  }

#include "skull.inc"
#declare fiveSkulls=
union{
  object{skull rotate <0,-70,-40> scale 30 translate <90,1,0> rotate 15*y }
  object{skull rotate <0,-50,-40> scale 30 translate <85,1,0> rotate 90*y}
  object{skull rotate <0,-70,-40> scale 30 translate <90,1,0> rotate 160*y }
  object{skull rotate <0,-70,-40> scale 30 translate <90,1,0> rotate 235*y }
  object{skull rotate <0,-70,-40> scale 30 translate <90,1,0> rotate 305*y }
}

#declare fiveLasers=
union{
  cylinder {<0,laserTop,0>, <85, 3.75, -1.5>, .45 rotate 15*y}
  cylinder {<0,laserTop,0>, <85, 3.75,  1.5>, .45 rotate 15*y}
  cylinder {<0,laserTop,0>, <85, 3.75, -1.5>, .45 rotate 90*y}
  cylinder {<0,laserTop,0>, <85, 3.75,  1.5>, .45 rotate 90*y}
  cylinder {<0,laserTop,0>, <85, 3.75, -1.5>, .45 rotate 160*y}
  cylinder {<0,laserTop,0>, <85, 3.75,  1.5>, .45 rotate 160*y}
  cylinder {<0,laserTop,0>, <85, 3.75, -1.5>, .45 rotate 235*y}
  cylinder {<0,laserTop,0>, <85, 3.75,  1.5>, .45 rotate 235*y}
  cylinder {<0,laserTop,0>, <85, 3.75, -1.5>, .45 rotate 305.5*y}
  cylinder {<0,laserTop,0>, <85, 3.75,  1.5>, .45 rotate 305.5*y}
  no_shadow
  texture{
    pigment{color rgbt <2,.5,0, .6>}
    finish{Luminous}
  }
}


#declare pent=
height_field {
    gif "d:\pov-ra~1\blkmagic\p3.gif"

    translate <-0.5, 0, -0.5>    // center the whole shebang
scale <220,10,220>
rotate <180,0,0>
translate<0,.35,0>
translate<0,0,0>
}


#declare rockx = seed(233567)
#declare rocky = seed(854)
#declare rockz = seed(456)
#declare rockScalex = seed(987)
#declare rockScaley = seed(1256)
#declare rockScalez = seed(843)
#declare rockRad = seed(357)

#declare mult=1.4
#declare sand=
difference{
  box{<-.5,.25,-.5>,<.5,-12,.5> scale <10000,1,10000>}
  object{pent rotate <0,pentYrot,0> translate <fireX,fireY,fireZ>}
  texture {
    pigment{
      bozo
      turbulence 0.4
      color_map
       {[0.000, 0.154   color rgbf <0.800, 0.651, 0.557, 0.000>*mult
                        color rgbf <0.996, 0.835, 0.737, 0.000>*mult*1.3] //1.1
        [0.154, 0.308   color rgbf <0.996, 0.835, 0.737, 0.000>*mult*1.3
                        color rgbf <0.800, 0.651, 0.557, 0.000>*mult]
        [0.308, 0.444   color rgbf <0.800, 0.651, 0.557, 0.000>*mult
                        color rgbf <0.694, 0.624, 0.604, 0.004>*mult]
        [0.444, 0.615   color rgbf <0.694, 0.624, 0.604, 0.004>*mult
                        color rgbf <0.800, 0.651, 0.557, 0.000>*mult]
        [0.615, 0.812   color rgbf <0.800, 0.651, 0.557, 0.000>*mult
                        color rgbf <0.725, 0.655, 0.651, 0.000>*mult]
        [0.812, 1.001   color rgbf <0.725, 0.655, 0.651, 0.000>*mult
                        color rgbf <0.800, 0.651, 0.557, 0.000>*mult]
      }
      scale .2
    }
    normal {bumps 0.25  scale <10,3,10>}
    finish {roughness 0.2 crand 0.02}
  }
}

#declare rocks=
union{
  #declare rockCount = 0
  #while (rockCount < 2000)
     sphere{<rand(rockx)*400,rand(rocky)-.5,rand(rockz)*400>,  .5 + rand(rockRad)
       scale <rand(rockScalex),rand(rockScaley),rand(rockScalez)>
       translate<-150,0,-175>
       pigment{White*(.4 + rand(rocky))}
     }
     #declare rockCount = rockCount + 1
  #end

  #declare rockCount = 0
  #while (rockCount < 2000)
     sphere{<rand(rockx)*1000,rand(rocky)-.5,rand(rockz)*1000>,  .5 + rand(rockRad)
       scale <rand(rockScalex),rand(rockScaley),rand(rockScalez)>
       translate<-400,0,-300>  //-500
       pigment{White*(.4 + rand(rocky))}
     }
     #declare rockCount = rockCount + 1
  #end
}

#declare KettelAndFire=
union{
  #if (testing = False) object{kettleFire} #end
  object{BigKettle scale <0.061,0.061,0.061>}
  object{Rock1 rotate<0,90,0> scale 10 translate<-37,0,0>}
  object{Rock1 scale 10 translate<37,0,0> rotate<0,-20,0>}
  object{Rock1 scale 10 translate<36,0,0>}
  object{Rock3 rotate<20,90,0> scale 10 translate<37,-2.5,0> rotate<0,22,0>}
  object{Rock2 rotate<0,0,0> scale 10 translate<37,0,0> rotate<0,50,0>}
  object{Rock3 rotate<20,180,0> scale 10 translate<37,-2.5,0> rotate<0,72,0>}
  object{Rock1 rotate<0,180,0> scale 10 translate<37,0,0> rotate<0,90,0>}
  object{Rock3 rotate<20,0,0> scale 10 translate<37,-2.5,0> rotate<0,115,0>}
  object{Rock2 rotate<0,0,0> scale 10 translate<37,0,0> rotate<0,135,0>}
  object{Rock3 rotate<20,90,0> scale 10 translate<36,-2.5,0> rotate<0,155,0>}
  object{Rock1 rotate<0,90,0> scale 10 translate<-38.5,2,0> rotate<0,25,0>}


  #if (testing = False)
    #declare yRot = 0
  #else
    #declare yRot = 260
  #end

  #while (yRot < 270)
    #if (testing = False)
      light_source {<32,10,0> color rgb <1.0,.5,.05>*.42 // was .5
                     rotate<0,yRot,0> translate<fireX,0,fireZ>
        area_light
        <3, 0, 0> <0, 0, 3>
        2, 2
        adaptive 2
      }
    #else
      light_source {<fireX ,15,fireZ > color rgb <1,1,.7>*1 rotate<0,yRot,0>}
    #end
    #declare yRot= yRot+90
  #end
}


#declare RockMult = 1.0
#declare RockTex1=
  texture{
    pigment {color rgb<.8,.8,.8 >*RockMult}
    normal {
      bump_map {
         gif "fract001.gif"
         bump_size 5
      }
      translate <-1, 0, 0>
      scale 500
    }
    finish{crand 0.4}
  }


#declare RockTex2=
  texture{
    pigment {color rgb<.8,.8,.8 >*RockMult}
    normal {
      bump_map {
         gif "fract002.gif"
         bump_size 5
      }
      translate <-1, 0, 0>
      scale 500
    }
    finish{crand 0.4}
  }


#declare RockTex3=
  texture{
    pigment {color rgb<.8,.8,.8 >*RockMult}
    normal {
      bump_map {
         gif "fract003.gif"
         bump_size 5
      }
      translate <-1, 0, 0>
      scale 500
    }
    finish{crand 0.4}
  }

#declare RockTex4=
  texture{
    pigment {color rgb<.8,.8,.8 >*RockMult}
    normal {
      bump_map {
         gif "fract004.gif"
         bump_size 5
      }
      translate <-1, 0, 0>
      scale 500
    }
    finish{crand 0.4}
  }

#declare Block=
superellipsoid { <.12, .12>
  translate<0,1,1>
}

#declare Walls=
union{
  object{Block scale <12,12,12> texture{RockTex1 rotate<0,0,90>} translate<96,0,120-rand(rockz)>}
  object{Block scale <24,8,12> texture{RockTex2 rotate<0,0,0>} translate<108,24,120-rand(rockz)>}
  object{Block scale <12,12,12> texture{RockTex3 rotate<0,0,180>} translate<96,40,120-rand(rockz)>}
  object{Block scale <24,10,12> texture{RockTex4 rotate<0,0,270>} translate<108,64,120-rand(rockz)>}

//back wall
  object{Block scale <24,12,12> texture{RockTex4 rotate<0,0,270>} translate<12,0,120-rand(rockz)>}
  object{Block scale <20,12,12> texture{RockTex1 rotate<0,0,0>} translate<-32,0,120-rand(rockz)>}
  object{Block scale <26,12,12> texture{RockTex2 rotate<0,0,0>} translate<-78,0,120-rand(rockz)>}
  object{Block scale <22,12,12> texture{RockTex3 rotate<0,0,90>} translate<-126,0,120-rand(rockz)>}
  object{Block scale <18,8,12> texture{RockTex3 rotate<0,0,90>}  rotate<0,30,45>translate<-110,0,60>}

  object{Block scale <12,10,12> texture{RockTex3 rotate<0,0,180>} translate<24,24,120-rand(rockz)>}
  object{Block scale <24,10,12> texture{RockTex2 rotate<0,0,90>} translate<-12,24,120-rand(rockz)>}
  object{Block scale <26,10,12> texture{RockTex4 rotate<0,0,270>} translate<-62,24,120-rand(rockz)>}
  object{Block scale <24,10,12> texture{RockTex1 rotate<0,0,90>} translate<-112,24,120-rand(rockz)>}
  object{Block scale <26,10,12> texture{RockTex4 rotate<0,0,0>} translate<-122,24,120-rand(rockz)>}

  object{Block scale <24,10,12> texture{RockTex4 rotate<0,0,180>} translate<12,44,120-rand(rockz)>}
  object{Block scale <26,10,12> texture{RockTex1 rotate<0,0,0>} translate<-38,44,120-rand(rockz)>}
  object{Block scale <27.5,10,12> texture{RockTex3 rotate<0,0,90>} translate<-119.5,44,120-rand(rockz)>}

  object{Block scale <12,10,12> texture{RockTex1 rotate<0,0,0>} translate<24,64,120-rand(rockz)>}
  object{Block scale <25,10,12> texture{RockTex3 rotate<0,0,270>} translate<-13,64,120-rand(rockz)>}
  object{Block scale <13,10,12> texture{RockTex1 rotate<0,0,90>} translate<-51,64,120-rand(rockz)>}
  object{Block scale <12,10,12> texture{RockTex4 rotate<0,0,180>} translate<-103,64,120-rand(rockz)>}
  object{Block scale <24,10,12> texture{RockTex4 rotate<0,0,180>} translate<-139,64,120-rand(rockz)>}

  object{Block scale <42,6,12> texture{RockTex4 rotate<0,0,270>} translate<66,84,120-rand(rockz)>}
  object{Block scale <20,6,12> texture{RockTex3 rotate<0,0,0>} translate<4,84,120-rand(rockz)>}
  object{Block scale <19,6,12> texture{RockTex2 rotate<0,0,180>} translate<-35,84,120-rand(rockz)>}
  object{Block scale <22,6,12> texture{RockTex1 rotate<0,0,0>} translate<-76,84,120-rand(rockz)>}
  object{Block scale <24,6,12> texture{RockTex3 rotate<0,0,180>} translate<-122,84,120-rand(rockz)>}

  object{Block scale <36,10,12> texture{RockTex4 rotate<0,0,270>} translate<84,96,120-rand(rockz)>}
  object{Block scale <24,10,12> texture{RockTex4 rotate<0,0,270>} translate<24,96,120-rand(rockz)>}
  object{Block scale <22,10,12> texture{RockTex4 rotate<0,0,270>} translate<-22,96,120-rand(rockz)>}
  object{Block scale <20,10,12> texture{RockTex4 rotate<0,0,270>}  rotate<0,-20,0> translate<-70,96,120>}


//right wall
  object{Block  scale <24,12,12> texture{RockTex1 rotate<0,0,0>} rotate <0,90,0> translate<108-rand(rockx),0,108>}
  object{Block  scale <20,12,12> texture{RockTex2 rotate<0,0,90>} rotate <0,90,0> translate<108-rand(rockx),0,64>}
  object{Block  scale <26,12,12> texture{RockTex3 rotate<0,0,180>} rotate <0,90,0> translate<108-rand(rockx),0,18>}
  object{Block  scale <20,12,12> texture{RockTex4 rotate<0,0,270>} rotate <0,90,0> translate<108-rand(rockx),0,-28>}
  object{Block  scale <24,12,12> texture{RockTex4 rotate<0,0,270>} rotate <0,90,0> translate<108-rand(rockx),0,-72>}

  object{Block  scale <26,8,12> texture{RockTex4 rotate<0,0,0>} rotate <0,90,0> translate<108-rand(rockx),24,94>}
  object{Block  scale <22,8,12> texture{RockTex3 rotate<0,0,90>} rotate <0,90,0> translate<108-rand(rockx),24,46>}
  object{Block  scale <24,8,12> texture{RockTex1 rotate<0,0,270>} rotate <0,90,0> translate<108-rand(rockx),24,0>}
  object{Block  scale <24,8,12> texture{RockTex2 rotate<0,0,180>} rotate <0,90,0> translate<108-rand(rockx),24,-48>}

  object{Block  scale <24,12,12> texture{RockTex1 rotate<0,0,270>} rotate <0,90,0> translate<108-rand(rockx),40,108>}
  object{Block  scale <20,12,12> texture{RockTex2 rotate<0,0,180>} rotate <0,90,0> translate<108-rand(rockx),40,64>}
  object{Block  scale <22,12,12> texture{RockTex4 rotate<0,0,90>} rotate <0,90,0> translate<108-rand(rockx),40,22>}

  object{Block  scale <24,10,12> texture{RockTex1 rotate<0,0,180>} rotate <0,90,0> translate<108-rand(rockx),64,96>}
  object{Block  scale <20,10,12> texture{RockTex2 rotate<0,0,270>} rotate <0,90,0> translate<108-rand(rockx),64,52>}
  object{Block  scale <23,10,12> texture{RockTex3 rotate<0,0,0>} rotate <0,90,0> translate<108-rand(rockx),64,9>}

  object{Block  scale <24,6,12> texture{RockTex4 rotate<0,0,90>} rotate <0,90,0> translate<108-rand(rockx),84,108>}
  object{Block  scale <22,6,12> texture{RockTex3 rotate<0,0,0>} rotate <0,90,0> translate<108-rand(rockx),84,62>}

  object{Block  scale <24,10,12> texture{RockTex4 rotate<0,0,90>} rotate <0,90,0> translate<108,94,96>}

//start left wall
  object{Block  scale <24,12,12> texture{RockTex1 rotate<0,0,0>} rotate <0,-90,0> translate<-144,0,108>}
  object{Block  scale <22,12,12> texture{RockTex1 rotate<0,0,0>} rotate <0,-90,0> translate<-144,0,62>}
  object{Block  scale <24,12,12> texture{RockTex1 rotate<0,0,0>} rotate <0,-90,0> translate<-144,0,16>}
  object{Block  scale <24,12,12> texture{RockTex1 rotate<0,0,0>} rotate <0,-90,0> translate<-144,0,-32>}


  object{Block  scale <24,10,12> texture{RockTex1 rotate<0,0,0>} rotate <0,-90,0> translate<-144,24,120>}
  object{Block  scale <22,10,12> texture{RockTex1 rotate<0,0,0>} rotate <0,-90,0> translate<-144,24,74>}
  object{Block  scale <20,10,12> texture{RockTex1 rotate<0,0,0>} rotate <0,-90,0> translate<-144,24,32>}

  object{Block  scale <24,10,12> texture{RockTex1 rotate<0,0,270>} rotate <0,-90,0> translate<-144,44,108>}
  object{Block  scale <24,10,12> texture{RockTex1 rotate<0,0,270>} rotate <0,-90,0> translate<-144,44,108>}

  object{Block  scale <20,8,12> texture{RockTex4 rotate<90,0,0>} rotate <10,45,0> translate<-140,-3,-120>}
  object{Block  scale <20,8,12> texture{RockTex4 rotate<0,0,0>} rotate <0,0,60> translate<80,22,-135>}
}


object{Walls}
object{fiveSkulls rotate <0,pentYrot,0> translate <fireX,fireY,fireZ>}
object{fiveLasers rotate <0,pentYrot,0> translate <fireX,fireY,fireZ>}

object{KettelAndFire  scale 1.0 rotate<0,fireYrot,0> translate<fireX,fireY,fireZ>}
object{spoon  rotate<0,0,-33> rotate<0,-120,0> translate<fireX,fireY,fireZ>}

object{tree rotate<0,180,0> scale 50 translate<135,0,-20>}
object{tree3 rotate<0,-165,0> scale 40 translate<-160,24,-180>}
object{sand}
object{rocks}
object{steam}
